/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.testing.UnitTestExamples;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.FakeSerializable;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionLoader;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class SubscriptionPartitionLoaderTest {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Mock
    SerializableFunction<TopicPath, Integer> getPartitionCount;
    private SubscriptionPartitionLoader loader;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        FakeSerializable.Handle<SerializableFunction<TopicPath, Integer>> handle = FakeSerializable.put(this.getPartitionCount);
        this.loader = new SubscriptionPartitionLoader((TopicPath)UnitTestExamples.example(TopicPath.class), (SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class), (SerializableFunction & Serializable)topic -> (Integer)((SerializableFunction)handle.get()).apply(topic), Duration.millis((long)50L), true);
    }

    @Test
    public void singleResult() {
        Mockito.when((Object)((Integer)this.getPartitionCount.apply((Object)((TopicPath)UnitTestExamples.example(TopicPath.class))))).thenReturn((Object)3);
        PCollection output = (PCollection)this.pipeline.apply((PTransform)this.loader);
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new SubscriptionPartition[]{SubscriptionPartition.of((SubscriptionPath)((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)), (Partition)Partition.of((long)0L)), SubscriptionPartition.of((SubscriptionPath)((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)), (Partition)Partition.of((long)1L)), SubscriptionPartition.of((SubscriptionPath)((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)), (Partition)Partition.of((long)2L))});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void addedResults() {
        Mockito.when((Object)((Integer)this.getPartitionCount.apply((Object)((TopicPath)UnitTestExamples.example(TopicPath.class))))).thenReturn((Object)3).thenReturn((Object)4);
        PCollection output = (PCollection)this.pipeline.apply((PTransform)this.loader);
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new SubscriptionPartition[]{SubscriptionPartition.of((SubscriptionPath)((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)), (Partition)Partition.of((long)0L)), SubscriptionPartition.of((SubscriptionPath)((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)), (Partition)Partition.of((long)1L)), SubscriptionPartition.of((SubscriptionPath)((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)), (Partition)Partition.of((long)2L)), SubscriptionPartition.of((SubscriptionPath)((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)), (Partition)Partition.of((long)3L))});
        this.pipeline.run().waitUntilFinish();
    }
}

