/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.beam.model.expansion.v1.ExpansionApi;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.PipelineTranslation;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.expansion.service.ExpansionService;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.text.MatchesPattern;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.powermock.reflect.Whitebox;

@RunWith(value=JUnit4.class)
public class PubsubIOExternalTest {
    @Test
    public void testConstructPubsubRead() throws Exception {
        String topic = "projects/project-1234/topics/topic_name";
        String idAttribute = "id_foo";
        Boolean needsAttributes = true;
        ExternalTransforms.ExternalConfigurationPayload payload = PubsubIOExternalTest.encodeRow(Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"topic", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"id_label", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"with_attributes", (Schema.FieldType)Schema.FieldType.BOOLEAN)})).withFieldValue("topic", (Object)topic).withFieldValue("id_label", (Object)idAttribute).withFieldValue("with_attributes", (Object)needsAttributes).build());
        RunnerApi.Components defaultInstance = RunnerApi.Components.getDefaultInstance();
        ExpansionApi.ExpansionRequest request = ExpansionApi.ExpansionRequest.newBuilder().setComponents(defaultInstance).setTransform(RunnerApi.PTransform.newBuilder().setUniqueName("test").setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:org.apache.beam:pubsub_read:v1").setPayload(payload.toByteString()))).setNamespace("test_namespace").build();
        ExpansionService expansionService = new ExpansionService();
        TestStreamObserver observer = new TestStreamObserver();
        expansionService.expand(request, observer);
        ExpansionApi.ExpansionResponse result = (ExpansionApi.ExpansionResponse)observer.result;
        RunnerApi.PTransform transform = result.getTransform();
        MatcherAssert.assertThat((Object)transform.getSubtransformsList(), (Matcher)Matchers.hasItem((Matcher)MatchesPattern.matchesPattern((String)".*PubsubUnboundedSource.*")));
        MatcherAssert.assertThat((Object)transform.getSubtransformsList(), (Matcher)Matchers.hasItem((Matcher)MatchesPattern.matchesPattern((String)".*MapElements.*")));
        MatcherAssert.assertThat((Object)transform.getInputsCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)transform.getOutputsCount(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testConstructPubsubWrite() throws Exception {
        String topic = "projects/project-1234/topics/topic_name";
        String idAttribute = "id_foo";
        ExternalTransforms.ExternalConfigurationPayload payload = PubsubIOExternalTest.encodeRow(Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"topic", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"id_label", (Schema.FieldType)Schema.FieldType.STRING)})).withFieldValue("topic", (Object)topic).withFieldValue("id_label", (Object)idAttribute).build());
        Pipeline p = Pipeline.create();
        ((PCollection)p.apply("unbounded", (PTransform)Impulse.create())).setIsBoundedInternal(PCollection.IsBounded.UNBOUNDED);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p);
        String inputPCollection = (String)Iterables.getOnlyElement(((RunnerApi.PTransform)Iterables.getLast(pipelineProto.getComponents().getTransformsMap().values())).getOutputsMap().values());
        ExpansionApi.ExpansionRequest request = ExpansionApi.ExpansionRequest.newBuilder().setComponents(pipelineProto.getComponents()).setTransform(RunnerApi.PTransform.newBuilder().setUniqueName("test").putInputs("input", inputPCollection).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:org.apache.beam:pubsub_write:v1").setPayload(payload.toByteString()))).setNamespace("test_namespace").build();
        ExpansionService expansionService = new ExpansionService();
        TestStreamObserver observer = new TestStreamObserver();
        expansionService.expand(request, observer);
        ExpansionApi.ExpansionResponse result = (ExpansionApi.ExpansionResponse)observer.result;
        RunnerApi.PTransform transform = result.getTransform();
        MatcherAssert.assertThat((Object)transform.getSubtransformsList(), (Matcher)Matchers.hasItem((Matcher)MatchesPattern.matchesPattern((String)".*MapElements.*")));
        MatcherAssert.assertThat((Object)transform.getSubtransformsList(), (Matcher)Matchers.hasItem((Matcher)MatchesPattern.matchesPattern((String)".*PubsubUnboundedSink.*")));
        MatcherAssert.assertThat((Object)transform.getInputsCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)transform.getOutputsCount(), (Matcher)Matchers.is((Object)0));
        RunnerApi.PTransform writeComposite = result.getComponents().getTransformsOrThrow(transform.getSubtransforms(1));
        RunnerApi.PTransform writeComposite2 = result.getComponents().getTransformsOrThrow(writeComposite.getSubtransforms(1));
        RunnerApi.PTransform writeComposite3 = result.getComponents().getTransformsOrThrow(writeComposite2.getSubtransforms(3));
        RunnerApi.PTransform writeParDo = result.getComponents().getTransformsOrThrow(writeComposite3.getSubtransforms(0));
        RunnerApi.ParDoPayload parDoPayload = RunnerApi.ParDoPayload.parseFrom((ByteString)writeParDo.getSpec().getPayload());
        DoFn pubsubWriter = ParDoTranslation.getDoFn((RunnerApi.ParDoPayload)parDoPayload);
        String idAttributeActual = (String)Whitebox.getInternalState((Object)pubsubWriter, (String)"idAttribute");
        ValueProvider topicActual = (ValueProvider)Whitebox.getInternalState((Object)pubsubWriter, (String)"topic");
        MatcherAssert.assertThat((Object)(topicActual == null ? null : String.valueOf(topicActual)), (Matcher)Matchers.is((Object)topic));
        MatcherAssert.assertThat((Object)idAttributeActual, (Matcher)Matchers.is((Object)idAttribute));
    }

    private static ExternalTransforms.ExternalConfigurationPayload encodeRow(Row row) {
        ByteString.Output outputStream = ByteString.newOutput();
        try {
            SchemaCoder.of((Schema)row.getSchema()).encode((Object)row, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ExternalTransforms.ExternalConfigurationPayload.newBuilder().setSchema(SchemaTranslation.schemaToProto((Schema)row.getSchema(), (boolean)true)).setPayload(outputStream.toByteString()).build();
    }

    private static class TestStreamObserver<T>
    implements StreamObserver<T> {
        private T result;

        private TestStreamObserver() {
        }

        public void onNext(T t) {
            this.result = t;
        }

        public void onError(Throwable throwable) {
            throw new RuntimeException("Should not happen", throwable);
        }

        public void onCompleted() {
        }
    }
}

