/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PubsubClientTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private long parse(String timestamp) {
        ImmutableMap map = ImmutableMap.of((Object)"myAttribute", (Object)timestamp);
        return PubsubClient.extractTimestampAttribute((String)"myAttribute", (Map)map);
    }

    private void roundTripRfc339(String timestamp) {
        Assert.assertEquals((long)Instant.parse((String)timestamp).getMillis(), (long)this.parse(timestamp));
    }

    private void truncatedRfc339(String timestamp, String truncatedTimestmap) {
        Assert.assertEquals((long)Instant.parse((String)truncatedTimestmap).getMillis(), (long)this.parse(timestamp));
    }

    @Test
    public void noTimestampAttributeAndInvalidPubsubPublishThrowsError() {
        this.thrown.expect(NumberFormatException.class);
        PubsubClient.parseTimestampAsMsSinceEpoch((String)"not-a-date");
    }

    @Test
    public void timestampAttributeWithNullAttributesThrowsError() {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("PubSub message is missing a value for timestamp attribute myAttribute");
        PubsubClient.extractTimestampAttribute((String)"myAttribute", null);
    }

    @Test
    public void timestampAttributeSetWithMissingAttributeThrowsError() {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("PubSub message is missing a value for timestamp attribute myAttribute");
        ImmutableMap map = ImmutableMap.of((Object)"otherLabel", (Object)"whatever");
        PubsubClient.extractTimestampAttribute((String)"myAttribute", (Map)map);
    }

    @Test
    public void timestampAttributeParsesMillisecondsSinceEpoch() {
        long time = 1446162101123L;
        ImmutableMap map = ImmutableMap.of((Object)"myAttribute", (Object)String.valueOf(time));
        long timestamp = PubsubClient.extractTimestampAttribute((String)"myAttribute", (Map)map);
        Assert.assertEquals((long)time, (long)timestamp);
    }

    @Test
    public void timestampAttributeParsesRfc3339Seconds() {
        this.roundTripRfc339("2015-10-29T23:41:41Z");
    }

    @Test
    public void timestampAttributeParsesRfc3339Tenths() {
        this.roundTripRfc339("2015-10-29T23:41:41.1Z");
    }

    @Test
    public void timestampAttributeParsesRfc3339Hundredths() {
        this.roundTripRfc339("2015-10-29T23:41:41.12Z");
    }

    @Test
    public void timestampAttributeParsesRfc3339Millis() {
        this.roundTripRfc339("2015-10-29T23:41:41.123Z");
    }

    @Test
    public void timestampAttributeParsesRfc3339Micros() {
        this.truncatedRfc339("2015-10-29T23:41:41.123456Z", "2015-10-29T23:41:41.123Z");
    }

    @Test
    public void timestampAttributeParsesRfc3339MicrosRounding() {
        this.truncatedRfc339("2015-10-29T23:41:41.123999Z", "2015-10-29T23:41:41.123Z");
    }

    @Test
    public void timestampAttributeWithInvalidFormatThrowsError() {
        this.thrown.expect(NumberFormatException.class);
        this.parse("not-a-timestamp");
    }

    @Test
    public void timestampAttributeWithInvalidFormat2ThrowsError() {
        this.thrown.expect(NumberFormatException.class);
        this.parse("null");
    }

    @Test
    public void timestampAttributeWithInvalidFormat3ThrowsError() {
        this.thrown.expect(NumberFormatException.class);
        this.parse("2015-10");
    }

    @Test
    public void timestampAttributeParsesRfc3339WithSmallYear() {
        this.roundTripRfc339("1582-10-15T01:23:45.123Z");
    }

    @Test
    public void timestampAttributeParsesRfc3339WithLargeYear() {
        this.roundTripRfc339("9999-10-29T23:41:41.123999Z");
    }

    @Test
    public void timestampAttributeRfc3339WithTooLargeYearThrowsError() {
        this.thrown.expect(NumberFormatException.class);
        this.parse("10000-10-29T23:41:41.123999Z");
    }

    @Test
    public void projectPathFromIdWellFormed() {
        PubsubClient.ProjectPath path = PubsubClient.projectPathFromId((String)"test");
        Assert.assertEquals((Object)"projects/test", (Object)path.getPath());
    }

    @Test
    public void subscriptionPathFromNameWellFormed() {
        PubsubClient.SubscriptionPath path = PubsubClient.subscriptionPathFromName((String)"test", (String)"something");
        Assert.assertEquals((Object)"projects/test/subscriptions/something", (Object)path.getPath());
        Assert.assertEquals((Object)"/subscriptions/test/something", (Object)path.getFullPath());
    }

    @Test
    public void topicPathFromNameWellFormed() {
        PubsubClient.TopicPath path = PubsubClient.topicPathFromName((String)"test", (String)"something");
        Assert.assertEquals((Object)"projects/test/topics/something", (Object)path.getPath());
        Assert.assertEquals((Object)"/topics/test/something", (Object)path.getFullPath());
    }
}

