/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.pubsub.PubSubPayloadTranslation;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSink;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValues;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PubSubWritePayloadTranslationTest {
    private static final String TIMESTAMP_ATTRIBUTE = "timestamp";
    private static final String ID_ATTRIBUTE = "id";
    private static final PubsubClient.TopicPath TOPIC = PubsubClient.topicPathFromName((String)"testProject", (String)"testTopic");
    private final PubSubPayloadTranslation.PubSubWritePayloadTranslator sinkTranslator = new PubSubPayloadTranslation.PubSubWritePayloadTranslator();
    @Rule
    public TestPipeline pipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);

    @Test
    public void testTranslateSinkWithTopic() throws Exception {
        PubsubUnboundedSink pubsubUnboundedSink = new PubsubUnboundedSink(null, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)TOPIC), TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, 0, 0, 0, Duration.ZERO, null);
        PubsubUnboundedSink.PubsubSink pubsubSink = new PubsubUnboundedSink.PubsubSink(pubsubUnboundedSink);
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)new byte[0], (Object[])new byte[0][]));
        PDone output = (PDone)input.apply((PTransform)pubsubSink);
        AppliedPTransform appliedPTransform = AppliedPTransform.of((String)"sink", (Map)PValues.expandInput((PInput)input), (Map)PValues.expandOutput((POutput)output), (PTransform)pubsubSink, (ResourceHints)ResourceHints.create(), (Pipeline)this.pipeline);
        SdkComponents components = SdkComponents.create();
        components.registerEnvironment(Environments.createDockerEnvironment((String)"java"));
        RunnerApi.FunctionSpec spec = this.sinkTranslator.translate(appliedPTransform, components);
        Assert.assertEquals((Object)"beam:transform:pubsub_write:v1", (Object)spec.getUrn());
        RunnerApi.PubSubWritePayload payload = RunnerApi.PubSubWritePayload.parseFrom((ByteString)spec.getPayload());
        Assert.assertEquals((Object)TOPIC.getFullPath(), (Object)payload.getTopic());
        Assert.assertTrue((boolean)payload.getTopicRuntimeOverridden().isEmpty());
        Assert.assertEquals((Object)TIMESTAMP_ATTRIBUTE, (Object)payload.getTimestampAttribute());
        Assert.assertEquals((Object)ID_ATTRIBUTE, (Object)payload.getIdAttribute());
    }

    @Test
    public void testTranslateSinkWithTopicOverridden() throws Exception {
        ValueProvider runtimeProvider = this.pipeline.newProvider((Object)TOPIC);
        PubsubUnboundedSink pubsubUnboundedSinkSink = new PubsubUnboundedSink(null, runtimeProvider, TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, 0, 0, 0, Duration.ZERO, null);
        PubsubUnboundedSink.PubsubSink pubsubSink = new PubsubUnboundedSink.PubsubSink(pubsubUnboundedSinkSink);
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)new byte[0], (Object[])new byte[0][]));
        PDone output = (PDone)input.apply((PTransform)pubsubSink);
        AppliedPTransform appliedPTransform = AppliedPTransform.of((String)"sink", (Map)PValues.expandInput((PInput)input), (Map)PValues.expandOutput((POutput)output), (PTransform)pubsubSink, (ResourceHints)ResourceHints.create(), (Pipeline)this.pipeline);
        SdkComponents components = SdkComponents.create();
        components.registerEnvironment(Environments.createDockerEnvironment((String)"java"));
        RunnerApi.FunctionSpec spec = this.sinkTranslator.translate(appliedPTransform, components);
        Assert.assertEquals((Object)"beam:transform:pubsub_write:v1", (Object)spec.getUrn());
        RunnerApi.PubSubWritePayload payload = RunnerApi.PubSubWritePayload.parseFrom((ByteString)spec.getPayload());
        Assert.assertEquals((Object)((ValueProvider.NestedValueProvider)runtimeProvider).propertyName(), (Object)payload.getTopicRuntimeOverridden());
        Assert.assertTrue((boolean)payload.getTopic().isEmpty());
        Assert.assertEquals((Object)TIMESTAMP_ATTRIBUTE, (Object)payload.getTimestampAttribute());
        Assert.assertEquals((Object)ID_ATTRIBUTE, (Object)payload.getIdAttribute());
    }
}

