/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Arrays;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsub.PubSubPayloadTranslation;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubTestClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSource;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValues;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PubSubReadPayloadTranslationTest {
    private static final String TIMESTAMP_ATTRIBUTE = "timestamp";
    private static final String ID_ATTRIBUTE = "id";
    private static final String PROJECT = "project";
    private static final PubsubClient.TopicPath TOPIC = PubsubClient.topicPathFromName((String)"project", (String)"testTopic");
    private static final PubsubClient.SubscriptionPath SUBSCRIPTION = PubsubClient.subscriptionPathFromName((String)"project", (String)"testSubscription");
    private final PubSubPayloadTranslation.PubSubReadPayloadTranslator sourceTranslator = new PubSubPayloadTranslation.PubSubReadPayloadTranslator();
    public static TestPipeline pipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);
    private static final ValueProvider<PubsubClient.TopicPath> TOPIC_PROVIDER = pipeline.newProvider((Object)TOPIC);
    private static final ValueProvider<PubsubClient.SubscriptionPath> SUBSCRIPTION_PROVIDER = pipeline.newProvider((Object)SUBSCRIPTION);
    @Parameterized.Parameter(value=0)
    public Read.Unbounded<byte[]> readFromPubSub;
    @Parameterized.Parameter(value=1)
    public RunnerApi.PubSubReadPayload pubsubReadPayload;

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({Read.from((UnboundedSource)new PubsubUnboundedSource.PubsubSource(new PubsubUnboundedSource((PubsubClient.PubsubClientFactory)PubsubTestClient.createFactoryForCreateSubscription(), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)PubsubClient.projectPathFromId((String)PROJECT)), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)TOPIC), null, null, null, false, false))), RunnerApi.PubSubReadPayload.newBuilder().setTopic(TOPIC.getFullPath()).setWithAttributes(false).build()}, {Read.from((UnboundedSource)new PubsubUnboundedSource.PubsubSource(new PubsubUnboundedSource((PubsubClient.PubsubClientFactory)PubsubTestClient.createFactoryForCreateSubscription(), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)PubsubClient.projectPathFromId((String)PROJECT)), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)TOPIC), null, TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, true, true))), RunnerApi.PubSubReadPayload.newBuilder().setTopic(TOPIC.getFullPath()).setIdAttribute(ID_ATTRIBUTE).setTimestampAttribute(TIMESTAMP_ATTRIBUTE).setWithAttributes(true).build()}, {Read.from((UnboundedSource)new PubsubUnboundedSource.PubsubSource(new PubsubUnboundedSource((PubsubClient.PubsubClientFactory)PubsubTestClient.createFactoryForCreateSubscription(), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)PubsubClient.projectPathFromId((String)PROJECT)), TOPIC_PROVIDER, null, null, null, false, false))), RunnerApi.PubSubReadPayload.newBuilder().setTopicRuntimeOverridden(((ValueProvider.NestedValueProvider)TOPIC_PROVIDER).propertyName()).setWithAttributes(false).build()}, {Read.from((UnboundedSource)new PubsubUnboundedSource.PubsubSource(new PubsubUnboundedSource((PubsubClient.PubsubClientFactory)PubsubTestClient.createFactoryForCreateSubscription(), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)PubsubClient.projectPathFromId((String)PROJECT)), TOPIC_PROVIDER, null, TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, true, true))), RunnerApi.PubSubReadPayload.newBuilder().setTopicRuntimeOverridden(((ValueProvider.NestedValueProvider)TOPIC_PROVIDER).propertyName()).setIdAttribute(ID_ATTRIBUTE).setTimestampAttribute(TIMESTAMP_ATTRIBUTE).setWithAttributes(true).build()}, {Read.from((UnboundedSource)new PubsubUnboundedSource.PubsubSource(new PubsubUnboundedSource((PubsubClient.PubsubClientFactory)PubsubTestClient.createFactoryForCreateSubscription(), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)PubsubClient.projectPathFromId((String)PROJECT)), null, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)SUBSCRIPTION), null, null, false, false))), RunnerApi.PubSubReadPayload.newBuilder().setSubscription(SUBSCRIPTION.getFullPath()).setWithAttributes(false).build()}, {Read.from((UnboundedSource)new PubsubUnboundedSource.PubsubSource(new PubsubUnboundedSource((PubsubClient.PubsubClientFactory)PubsubTestClient.createFactoryForCreateSubscription(), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)PubsubClient.projectPathFromId((String)PROJECT)), null, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)SUBSCRIPTION), TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, true, true))), RunnerApi.PubSubReadPayload.newBuilder().setSubscription(SUBSCRIPTION.getFullPath()).setIdAttribute(ID_ATTRIBUTE).setTimestampAttribute(TIMESTAMP_ATTRIBUTE).setWithAttributes(true).build()}, {Read.from((UnboundedSource)new PubsubUnboundedSource.PubsubSource(new PubsubUnboundedSource((PubsubClient.PubsubClientFactory)PubsubTestClient.createFactoryForCreateSubscription(), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)PubsubClient.projectPathFromId((String)PROJECT)), null, SUBSCRIPTION_PROVIDER, null, null, false, false))), RunnerApi.PubSubReadPayload.newBuilder().setSubscriptionRuntimeOverridden(((ValueProvider.NestedValueProvider)SUBSCRIPTION_PROVIDER).propertyName()).setWithAttributes(false).build()}, {Read.from((UnboundedSource)new PubsubUnboundedSource.PubsubSource(new PubsubUnboundedSource((PubsubClient.PubsubClientFactory)PubsubTestClient.createFactoryForCreateSubscription(), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)PubsubClient.projectPathFromId((String)PROJECT)), null, SUBSCRIPTION_PROVIDER, TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, true, true))), RunnerApi.PubSubReadPayload.newBuilder().setSubscriptionRuntimeOverridden(((ValueProvider.NestedValueProvider)SUBSCRIPTION_PROVIDER).propertyName()).setIdAttribute(ID_ATTRIBUTE).setTimestampAttribute(TIMESTAMP_ATTRIBUTE).setWithAttributes(true).build()});
    }

    @Test
    public void testTranslateSourceToFunctionSpec() throws Exception {
        PCollection output = (PCollection)pipeline.apply(this.readFromPubSub);
        AppliedPTransform appliedPTransform = AppliedPTransform.of((String)"ReadFromPubsub", (Map)PValues.expandInput((PInput)pipeline.begin()), (Map)PValues.expandOutput((POutput)output), this.readFromPubSub, (ResourceHints)ResourceHints.create(), (Pipeline)pipeline);
        SdkComponents components = SdkComponents.create();
        components.registerEnvironment(Environments.createDockerEnvironment((String)"java"));
        RunnerApi.FunctionSpec spec = this.sourceTranslator.translate(appliedPTransform, components);
        Assert.assertEquals((Object)"beam:transform:pubsub_read:v1", (Object)spec.getUrn());
        RunnerApi.PubSubReadPayload result = RunnerApi.PubSubReadPayload.parseFrom((ByteString)spec.getPayload());
        Assert.assertEquals((Object)this.pubsubReadPayload, (Object)result);
    }
}

