/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2IO;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2IOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2MessageCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HL7v2IOReadWriteIT {
    private transient HealthcareApiClient client;
    private static String healthcareDataset;
    private static final String BASE;
    private static final String INPUT_HL7V2_STORE_NAME;
    private static final String OUTPUT_HL7V2_STORE_NAME;
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void createHL7v2tores() throws IOException {
        String project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
        healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", project);
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        client.createHL7v2Store(healthcareDataset, INPUT_HL7V2_STORE_NAME);
        client.createHL7v2Store(healthcareDataset, OUTPUT_HL7V2_STORE_NAME);
    }

    @AfterClass
    public static void deleteHL7v2tores() throws IOException {
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        client.deleteHL7v2Store(healthcareDataset + "/hl7V2Stores/" + INPUT_HL7V2_STORE_NAME);
        client.deleteHL7v2Store(healthcareDataset + "/hl7V2Stores/" + OUTPUT_HL7V2_STORE_NAME);
    }

    @Before
    public void setup() throws Exception {
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
        HL7v2IOTestUtil.writeHL7v2Messages(this.client, healthcareDataset + "/hl7V2Stores/" + INPUT_HL7V2_STORE_NAME);
    }

    @After
    public void tearDown() throws Exception {
        HL7v2IOTestUtil.deleteAllHL7v2Messages(this.client, healthcareDataset + "/hl7V2Stores/" + OUTPUT_HL7V2_STORE_NAME);
    }

    @Test
    public void testHL7v2IOE2E() throws Exception {
        HL7v2IO.Read.Result readResult = (HL7v2IO.Read.Result)((PCollection)this.pipeline.apply((PTransform)new HL7v2IOTestUtil.ListHL7v2MessageIDs(Collections.singletonList(healthcareDataset + "/hl7V2Stores/" + INPUT_HL7V2_STORE_NAME)))).apply((PTransform)HL7v2IO.getAll());
        PCollection numReadMessages = (PCollection)readResult.getMessages().setCoder((Coder)HL7v2MessageCoder.of()).apply(Count.globally());
        PAssert.thatSingleton((PCollection)numReadMessages).isEqualTo((Object)HL7v2IOTestUtil.MESSAGES.size());
        PAssert.that((PCollection)readResult.getFailedReads()).empty();
        HL7v2IO.Write.Result writeResult = (HL7v2IO.Write.Result)readResult.getMessages().apply((PTransform)HL7v2IO.ingestMessages((String)(healthcareDataset + "/hl7V2Stores/" + OUTPUT_HL7V2_STORE_NAME)));
        PAssert.that((PCollection)writeResult.getFailedInsertsWithErr()).empty();
        this.pipeline.run().waitUntilFinish();
        try {
            HL7v2IOTestUtil.waitForHL7v2Indexing(this.client, healthcareDataset + "/hl7V2Stores/" + OUTPUT_HL7V2_STORE_NAME, HL7v2IOTestUtil.MESSAGES.size(), Duration.standardMinutes((long)10L));
        }
        catch (TimeoutException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    static {
        BASE = "hl7v2_store_rw_it_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
        INPUT_HL7V2_STORE_NAME = BASE + "INPUT";
        OUTPUT_HL7V2_STORE_NAME = BASE + "OUTPUT";
    }
}

