/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOTestOptions;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FhirIOWriteIT {
    private final String fhirStoreName;
    private FhirIOTestOptions options;
    private transient HealthcareApiClient client;
    private String healthcareDataset;
    private long testTime = System.currentTimeMillis();
    public String version;
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> versions() {
        return Arrays.asList("DSTU2", "STU3", "R4");
    }

    public FhirIOWriteIT(String version) {
        this.version = version;
        this.fhirStoreName = "FHIR_store_" + version + "_write_it_" + this.testTime + "_" + new SecureRandom().nextInt(32);
    }

    @Before
    public void setup() throws Exception {
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
        PipelineOptionsFactory.register(FhirIOTestOptions.class);
        String project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
        this.healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", project);
        this.options = (FhirIOTestOptions)TestPipeline.testingPipelineOptions().as(FhirIOTestOptions.class);
        if (this.options.getGcsTempPath() == null) {
            this.options.setGcsTempPath(String.format("gs://%s/FhirIOWrite%sIT/%s/temp/", "temp-storage-for-healthcare-io-tests", this.version, this.testTime));
        }
        if (this.options.getGcsDeadLetterPath() == null) {
            this.options.setGcsDeadLetterPath(String.format("gs://%s/FhirIOWrite%sIT/%s/deadletter/", "temp-storage-for-healthcare-io-tests", this.version, this.testTime));
        }
        this.options.setFhirStore(this.healthcareDataset + "/fhirStores/" + this.fhirStoreName);
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        client.createFhirStore(this.healthcareDataset, this.fhirStoreName, this.version);
    }

    @After
    public void teardownFhirStore() throws IOException {
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        client.deleteFhirStore(this.healthcareDataset + "/fhirStores/" + this.fhirStoreName);
    }

    @AfterClass
    public static void teardownBucket() throws IOException {
        FhirIOTestUtil.tearDownTempBucket();
    }

    @Test
    public void testFhirIO_ExecuteBundle() throws IOException {
        FhirIO.Write.Result writeResult = (FhirIO.Write.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)FhirIOTestUtil.BUNDLES.get(this.version)))).apply((PTransform)FhirIO.Write.executeBundles((String)this.options.getFhirStore()));
        PAssert.that((PCollection)writeResult.getFailedBodies()).empty();
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testFhirIO_ExecuteBundle_parseResponse() {
        List<String> bundles = FhirIOTestUtil.BUNDLES.get("BUNDLE_PARSE_TEST");
        FhirIO.Write.Result writeResult = (FhirIO.Write.Result)((PCollection)this.pipeline.apply((PTransform)Create.of(bundles))).apply((PTransform)FhirIO.Write.executeBundles((String)this.options.getFhirStore()));
        PAssert.that((PCollection)writeResult.getSuccessfulBodies()).satisfies((SerializableFunction & Serializable)input -> {
            int counter = 0;
            for (String resp : input) {
                Assert.assertFalse((boolean)resp.isEmpty());
                ++counter;
            }
            Assert.assertEquals((long)2L, (long)counter);
            return null;
        });
        PAssert.that((PCollection)writeResult.getFailedBodies()).satisfies((SerializableFunction & Serializable)input -> {
            int counter = 0;
            for (HealthcareIOError resp : input) {
                Assert.assertEquals((long)400L, (long)resp.getStatusCode().intValue());
                ++counter;
            }
            Assert.assertEquals((long)2L, (long)counter);
            return null;
        });
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testFhirIO_Import() {
        Pipeline pipeline = Pipeline.create((PipelineOptions)this.options);
        if (this.options.getTempLocation() == null) {
            this.options.setTempLocation("gs://temp-storage-for-healthcare-io-tests");
        }
        FhirIO.Write.Result result = (FhirIO.Write.Result)((PCollection)pipeline.apply((PTransform)Create.of((Iterable)FhirIOTestUtil.BUNDLES.get(this.version)))).apply((PTransform)FhirIO.Write.fhirStoresImport((String)this.options.getFhirStore(), (String)this.options.getGcsDeadLetterPath(), (FhirIO.Import.ContentStructure)FhirIO.Import.ContentStructure.BUNDLE));
        PAssert.that((PCollection)result.getFailedBodies()).empty();
        PAssert.that((PCollection)result.getFailedFiles()).empty();
        pipeline.run().waitUntilFinish();
    }
}

