/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.healthcare.v1.model.HttpBody;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;

class FhirIOTestUtil {
    public static final String DEFAULT_TEMP_BUCKET = "temp-storage-for-healthcare-io-tests";
    static final List<String> DSTU2_PRETTY_BUNDLES = FhirIOTestUtil.readPrettyBundles("DSTU2").collect(Collectors.toList());
    static final List<String> STU3_PRETTY_BUNDLES = FhirIOTestUtil.readPrettyBundles("STU3").collect(Collectors.toList());
    static final List<String> R4_PRETTY_BUNDLES = FhirIOTestUtil.readPrettyBundles("R4").collect(Collectors.toList());
    static final List<String> BUNDLE_PARSE_TEST_PRETTY_BUNDLES = FhirIOTestUtil.readPrettyBundles("BUNDLE_PARSE_TEST").collect(Collectors.toList());
    static final Map<String, List<String>> BUNDLES;

    FhirIOTestUtil() {
    }

    private static Stream<String> readPrettyBundles(String resourcesPath) {
        Path resourceDir = Paths.get("build", "resources", "test", resourcesPath);
        String absolutePath = resourceDir.toFile().getAbsolutePath();
        File dir = new File(absolutePath);
        File[] fhirJsons = dir.listFiles();
        return Arrays.stream(fhirJsons).map(File::toPath).map(path -> {
            try {
                return Files.readAllBytes(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).map(String::new);
    }

    static List<String> executeFhirBundles(HealthcareApiClient client, String fhirStore, List<String> bundles) throws IOException, HttpHealthcareApiClient.HealthcareHttpException {
        ArrayList<String> resourceNames = new ArrayList<String>();
        for (String bundle : bundles) {
            HttpBody resp = client.executeFhirBundle(fhirStore, bundle);
            JsonObject jsonResponse = JsonParser.parseString((String)resp.getData()).getAsJsonObject();
            for (JsonElement entry : jsonResponse.getAsJsonArray("entry")) {
                String location = entry.getAsJsonObject().getAsJsonObject("response").getAsJsonPrimitive("location").getAsString();
                String resourceName = location.substring(location.indexOf("project"), location.indexOf("/_history"));
                resourceNames.add(resourceName);
            }
        }
        return resourceNames;
    }

    public static void tearDownTempBucket() throws IOException {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
        HttpRequestInitializer requestInitializer = request -> {
            Map credentialHeaders;
            HttpHeaders requestHeaders = request.getHeaders();
            if (!credentials.hasRequestMetadata()) {
                return;
            }
            URI uri = null;
            if (request.getUrl() != null) {
                uri = request.getUrl().toURI();
            }
            if ((credentialHeaders = credentials.getRequestMetadata(uri)) == null) {
                return;
            }
            for (Map.Entry entry : credentialHeaders.entrySet()) {
                String headerName = (String)entry.getKey();
                ArrayList requestValues = new ArrayList((Collection)entry.getValue());
                requestHeaders.put(headerName, requestValues);
            }
            request.setConnectTimeout(60000);
            request.setReadTimeout(60000);
        };
        Storage storage = new Storage.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), requestInitializer).build();
        List blobs = ((Objects)storage.objects().list(DEFAULT_TEMP_BUCKET).execute()).getItems();
        if (blobs != null) {
            for (StorageObject blob : blobs) {
                storage.objects().delete(DEFAULT_TEMP_BUCKET, blob.getId());
            }
        }
    }

    static {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        m.put("DSTU2", DSTU2_PRETTY_BUNDLES);
        m.put("STU3", STU3_PRETTY_BUNDLES);
        m.put("R4", R4_PRETTY_BUNDLES);
        m.put("BUNDLE_PARSE_TEST", BUNDLE_PARSE_TEST_PRETTY_BUNDLES);
        BUNDLES = Collections.unmodifiableMap(m);
    }
}

