/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.direct.DirectOptions;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.FhirSearchParameter;
import org.apache.beam.sdk.io.gcp.healthcare.FhirSearchParameterCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FhirIOSearchIT {
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();
    private final String project;
    private transient HealthcareApiClient client;
    private static String healthcareDataset;
    private static final String BASE_STORE_ID;
    private String fhirStoreId;
    private static final int MAX_NUM_OF_SEARCHES = 50;
    private List<FhirSearchParameter<String>> input = new ArrayList<FhirSearchParameter<String>>();
    private List<FhirSearchParameter<List<Integer>>> genericParametersInput = new ArrayList<FhirSearchParameter<List<Integer>>>();
    private static final String KEY = "key";
    public String version;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> versions() {
        return Arrays.asList("R4");
    }

    public FhirIOSearchIT(String version) {
        this.version = version;
        this.fhirStoreId = BASE_STORE_ID + version;
        this.project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
    }

    @Before
    public void setup() throws Exception {
        healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", this.project);
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
        this.client.createFhirStore(healthcareDataset, this.fhirStoreId, this.version, "");
        List<String> bundles = FhirIOTestUtil.BUNDLES.get(this.version);
        FhirIOTestUtil.executeFhirBundles(this.client, healthcareDataset + "/fhirStores/" + this.fhirStoreId, bundles);
        JsonArray fhirResources = JsonParser.parseString((String)bundles.get(0)).getAsJsonObject().getAsJsonArray("entry");
        HashMap<String, String> searchParameters = new HashMap<String, String>();
        searchParameters.put("_count", Integer.toString(50));
        HashMap<String, List<Integer>> genericSearchParameters = new HashMap<String, List<Integer>>();
        genericSearchParameters.put("_count", Arrays.asList(50));
        int searches = 0;
        for (JsonElement resource : fhirResources) {
            String resourceType = resource.getAsJsonObject().getAsJsonObject("resource").get("resourceType").getAsString();
            this.input.add((FhirSearchParameter<String>)FhirSearchParameter.of((String)resourceType, (String)KEY, searchParameters));
            this.genericParametersInput.add((FhirSearchParameter<List<Integer>>)FhirSearchParameter.of((String)resourceType, genericSearchParameters));
            if (++searches <= 50) continue;
            break;
        }
    }

    @After
    public void teardown() throws IOException {
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        for (String version : FhirIOSearchIT.versions()) {
            client.deleteFhirStore(healthcareDataset + "/fhirStores/" + BASE_STORE_ID + version);
        }
    }

    @Test
    public void testFhirIOSearch() {
        ((DirectOptions)this.pipeline.getOptions().as(DirectOptions.class)).setBlockOnRun(false);
        PCollection searchConfigs = (PCollection)this.pipeline.apply((PTransform)Create.of(this.input).withCoder((Coder)FhirSearchParameterCoder.of((Coder)StringUtf8Coder.of())));
        FhirIO.Search.Result result = (FhirIO.Search.Result)searchConfigs.apply((PTransform)FhirIO.searchResources((String)(healthcareDataset + "/fhirStores/" + this.fhirStoreId)));
        PAssert.that((PCollection)result.getFailedSearches()).empty();
        PCollection keyedResources = result.getKeyedResources();
        PAssert.that((PCollection)keyedResources).satisfies((SerializableFunction & Serializable)input -> {
            for (KV resource : input) {
                Assert.assertEquals((Object)KEY, (Object)resource.getKey());
                Assert.assertNotEquals((long)0L, (long)((JsonArray)resource.getValue()).size());
            }
            return null;
        });
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testFhirIOSearchWithGenericParameters() {
        ((DirectOptions)this.pipeline.getOptions().as(DirectOptions.class)).setBlockOnRun(false);
        PCollection searchConfigs = (PCollection)this.pipeline.apply((PTransform)Create.of(this.genericParametersInput).withCoder((Coder)FhirSearchParameterCoder.of((Coder)ListCoder.of((Coder)VarIntCoder.of()))));
        FhirIO.Search.Result result = (FhirIO.Search.Result)searchConfigs.apply((PTransform)FhirIO.searchResourcesWithGenericParameters((String)(healthcareDataset + "/fhirStores/" + this.fhirStoreId)));
        PAssert.that((PCollection)result.getFailedSearches()).empty();
        PCollection resources = result.getResources();
        PAssert.that((PCollection)resources).satisfies((SerializableFunction & Serializable)input -> {
            for (JsonArray resource : input) {
                Assert.assertNotEquals((long)0L, (long)resource.size());
            }
            return null;
        });
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testFhirIOSearch_emptyResult() {
        ((DirectOptions)this.pipeline.getOptions().as(DirectOptions.class)).setBlockOnRun(false);
        FhirSearchParameter emptySearch = FhirSearchParameter.of((String)"Patient", (String)KEY, (Map)ImmutableMap.of((Object)"name", (Object)"INVALID_NAME"));
        PCollection searchConfigs = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)emptySearch, (Object[])new FhirSearchParameter[0]).withCoder((Coder)FhirSearchParameterCoder.of((Coder)StringUtf8Coder.of())));
        FhirIO.Search.Result result = (FhirIO.Search.Result)searchConfigs.apply((PTransform)FhirIO.searchResources((String)(healthcareDataset + "/fhirStores/" + this.fhirStoreId)));
        PAssert.that((PCollection)result.getFailedSearches()).empty();
        PCollection keyedResources = result.getKeyedResources();
        PAssert.that((PCollection)keyedResources).satisfies((SerializableFunction & Serializable)input -> {
            for (KV resource : input) {
                Assert.assertEquals((Object)KEY, (Object)resource.getKey());
                Assert.assertEquals((long)0L, (long)((JsonArray)resource.getValue()).size());
            }
            return null;
        });
        this.pipeline.run().waitUntilFinish();
    }

    static {
        BASE_STORE_ID = "FHIR_store_search_it_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
    }
}

