/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore.it;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.firestore.WriteBatch;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.Write;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreIO;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreOptions;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.io.gcp.firestore.it.FirestoreTestingHelper;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;

abstract class BaseFirestoreIT {
    protected static final int NUM_ITEMS_TO_GENERATE = 768;
    private static final String ENV_GOOGLE_APPLICATION_CREDENTIALS = "GOOGLE_APPLICATION_CREDENTIALS";
    private static final String ENV_FIRESTORE_EMULATOR_HOST = "FIRESTORE_EMULATOR_HOST";
    private static final String ENV_GOOGLE_CLOUD_PROJECT = "GOOGLE_CLOUD_PROJECT";
    @Rule(order=1)
    public final TestName testName = new TestName();
    @Rule(order=2)
    public final FirestoreTestingHelper helper = new FirestoreTestingHelper(FirestoreTestingHelper.CleanupMode.ALWAYS);
    @Rule(order=3)
    public final Timeout timeout = new Timeout(5L, TimeUnit.MINUTES);
    @Rule(order=4)
    public final TestPipeline testPipeline = TestPipeline.create();
    protected static String project;
    protected static RpcQosOptions rpcQosOptions;
    protected GcpOptions options;

    BaseFirestoreIT() {
    }

    @BeforeClass
    public static void beforeClass() {
        try {
            FirestoreTestingHelper.assumeEnvVarSet(ENV_GOOGLE_APPLICATION_CREDENTIALS);
        }
        catch (AssumptionViolatedException e) {
            try {
                FirestoreTestingHelper.assumeEnvVarSet(ENV_FIRESTORE_EMULATOR_HOST);
            }
            catch (AssumptionViolatedException exception) {
                Assume.assumeThat((String)String.format("Either %s or %s must be set", ENV_GOOGLE_APPLICATION_CREDENTIALS, ENV_FIRESTORE_EMULATOR_HOST), (Object)false, (Matcher)Matchers.equalTo((Object)true));
            }
        }
        project = FirestoreTestingHelper.assumeEnvVarSet(ENV_GOOGLE_CLOUD_PROJECT);
        rpcQosOptions = RpcQosOptions.defaultOptions().toBuilder().withMaxAttempts(1).withHintMaxNumWorkers(1).build();
    }

    @Before
    public void setup() {
        this.options = (GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class);
        String emulatorHostPort = System.getenv(ENV_FIRESTORE_EMULATOR_HOST);
        if (emulatorHostPort != null) {
            ((FirestoreOptions)this.options.as(FirestoreOptions.class)).setEmulatorHost(emulatorHostPort);
        }
        this.options.setProject(project);
    }

    @Test
    @FirestoreTestingHelper.TestDataLayoutHint(value=FirestoreTestingHelper.DataLayout.Deep)
    public final void listCollections() throws Exception {
        List collectionIds = IntStream.rangeClosed(1, 20).mapToObj(i -> this.helper.colId()).collect(Collectors.toList());
        ApiFutures.transform((ApiFuture)ApiFutures.allAsList((Iterable)FirestoreTestingHelper.chunkUpDocIds(collectionIds).map(chunk -> {
            WriteBatch batch = this.helper.getFs().batch();
            chunk.stream().map(col -> this.helper.getBaseDocument().collection(col).document()).forEach(ref -> {
                WriteBatch cfr_ignored_0 = (WriteBatch)batch.set(ref, (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
            });
            return batch.commit();
        }).collect(Collectors.toList())), FirestoreTestingHelper.flattenListList(), (Executor)MoreExecutors.directExecutor()).get(10L, TimeUnit.SECONDS);
        PCollection actualCollectionIds = (PCollection)((PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)"", (Object[])new String[0]))).apply(this.getListCollectionIdsPTransform(this.testName.getMethodName()))).apply((PTransform)((FirestoreV1.ListCollectionIds.Builder)FirestoreIO.v1().read().listCollectionIds().withRpcQosOptions(rpcQosOptions)).build());
        PAssert.that((PCollection)actualCollectionIds).containsInAnyOrder(collectionIds);
        this.testPipeline.run((PipelineOptions)this.options);
    }

    @Test
    public final void listDocuments() throws Exception {
        FirestoreTestingHelper.DocumentGenerator documentGenerator = this.helper.documentGenerator(768, "a");
        documentGenerator.generateDocuments().get(10L, TimeUnit.SECONDS);
        PCollection listDocumentPaths = (PCollection)((PCollection)((PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)"a", (Object[])new String[0]))).apply(this.getListDocumentsPTransform(this.testName.getMethodName()))).apply((PTransform)((FirestoreV1.ListDocuments.Builder)FirestoreIO.v1().read().listDocuments().withRpcQosOptions(rpcQosOptions)).build())).apply((PTransform)ParDo.of((DoFn)new DocumentToName()));
        PAssert.that((PCollection)listDocumentPaths).containsInAnyOrder(documentGenerator.expectedDocumentPaths());
        this.testPipeline.run((PipelineOptions)this.options);
    }

    @Test
    public final void runQuery() throws Exception {
        String collectionId = "a";
        FirestoreTestingHelper.DocumentGenerator documentGenerator = this.helper.documentGenerator(768, collectionId, true);
        documentGenerator.generateDocuments().get(10L, TimeUnit.SECONDS);
        PCollection listDocumentPaths = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)collectionId, (Object[])new String[0]))).apply(this.getRunQueryPTransform(this.testName.getMethodName()))).apply((PTransform)((FirestoreV1.RunQuery.Builder)FirestoreIO.v1().read().runQuery().withRpcQosOptions(rpcQosOptions)).build())).apply((PTransform)ParDo.of((DoFn)new RunQueryResponseToDocument()))).apply((PTransform)ParDo.of((DoFn)new DocumentToName()));
        PAssert.that((PCollection)listDocumentPaths).containsInAnyOrder(documentGenerator.expectedDocumentPaths());
        this.testPipeline.run((PipelineOptions)this.options);
    }

    @Test
    public final void partitionQuery() throws Exception {
        String collectionGroupId = UUID.randomUUID().toString();
        int partitionCount = 3;
        int documentCount = partitionCount * 128 - 1;
        FirestoreTestingHelper.DocumentGenerator documentGenerator = this.helper.documentGenerator(documentCount, collectionGroupId);
        documentGenerator.generateDocuments().get(10L, TimeUnit.SECONDS);
        PCollection listDocumentPaths = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)collectionGroupId, (Object[])new String[0]))).apply(this.getPartitionQueryPTransform(this.testName.getMethodName(), partitionCount))).apply((PTransform)FirestoreIO.v1().read().partitionQuery().withNameOnlyQuery().build())).apply((PTransform)FirestoreIO.v1().read().runQuery().build())).apply((PTransform)ParDo.of((DoFn)new RunQueryResponseToDocument()))).apply((PTransform)ParDo.of((DoFn)new DocumentToName()));
        PAssert.that((PCollection)listDocumentPaths).containsInAnyOrder(documentGenerator.expectedDocumentPaths());
        this.testPipeline.run((PipelineOptions)this.options);
    }

    @Test
    public final void batchGet() throws Exception {
        String collectionId = "a";
        FirestoreTestingHelper.DocumentGenerator documentGenerator = this.helper.documentGenerator(768, collectionId);
        documentGenerator.generateDocuments().get(10L, TimeUnit.SECONDS);
        PCollection listDocumentPaths = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of(Collections.singletonList(documentGenerator.getDocumentIds())))).apply(this.getBatchGetDocumentsPTransform(this.testName.getMethodName(), collectionId))).apply((PTransform)((FirestoreV1.BatchGetDocuments.Builder)FirestoreIO.v1().read().batchGetDocuments().withRpcQosOptions(rpcQosOptions)).build())).apply((PTransform)Filter.by(BatchGetDocumentsResponse::hasFound))).apply((PTransform)ParDo.of((DoFn)new BatchGetDocumentsResponseToDocument()))).apply((PTransform)ParDo.of((DoFn)new DocumentToName()));
        PAssert.that((PCollection)listDocumentPaths).containsInAnyOrder(documentGenerator.expectedDocumentPaths());
        this.testPipeline.run((PipelineOptions)this.options);
    }

    @Test
    public final void write() {
        String collectionId = "a";
        this.runWriteTest(this.getWritePTransform(this.testName.getMethodName(), collectionId), collectionId);
    }

    protected abstract PTransform<PCollection<String>, PCollection<ListCollectionIdsRequest>> getListCollectionIdsPTransform(String var1);

    protected abstract PTransform<PCollection<String>, PCollection<ListDocumentsRequest>> getListDocumentsPTransform(String var1);

    protected abstract PTransform<PCollection<List<String>>, PCollection<BatchGetDocumentsRequest>> getBatchGetDocumentsPTransform(String var1, String var2);

    protected abstract PTransform<PCollection<String>, PCollection<RunQueryRequest>> getRunQueryPTransform(String var1);

    protected abstract PTransform<PCollection<String>, PCollection<PartitionQueryRequest>> getPartitionQueryPTransform(String var1, int var2);

    protected abstract PTransform<PCollection<List<String>>, PCollection<Write>> getWritePTransform(String var1, String var2);

    protected final void runWriteTest(PTransform<PCollection<List<String>>, PCollection<Write>> createWrite, String collectionId) {
        List documentIds = IntStream.rangeClosed(1, 1000).mapToObj(i -> this.helper.docId()).collect(Collectors.toList());
        ((PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of(Collections.singletonList(documentIds)))).apply(createWrite)).apply((PTransform)((FirestoreV1.BatchWriteWithSummary.Builder)FirestoreIO.v1().write().batchWrite().withRpcQosOptions(rpcQosOptions)).build());
        this.testPipeline.run((PipelineOptions)this.options);
        List actualDocumentIds = this.helper.listDocumentsViaQuery(String.format("%s/%s", this.helper.getBaseDocumentPath(), collectionId)).map(name -> name.substring(name.lastIndexOf("/") + 1)).collect(Collectors.toList());
        Assert.assertEquals(documentIds, actualDocumentIds);
    }

    private static final class DocumentToName
    extends DoFn<Document, String> {
        private DocumentToName() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((Document)c.element()).getName());
        }
    }

    private static final class BatchGetDocumentsResponseToDocument
    extends DoFn<BatchGetDocumentsResponse, Document> {
        private BatchGetDocumentsResponseToDocument() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((BatchGetDocumentsResponse)c.element()).getFound());
        }
    }

    private static final class RunQueryResponseToDocument
    extends DoFn<RunQueryResponse, Document> {
        private RunQueryResponseToDocument() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((RunQueryResponse)c.element()).getDocument());
        }
    }
}

