/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.model.MultipleFailureException;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public final class RpcQosOptionsTest {
    @Test
    public void ensureSerializable() {
        SerializableUtils.ensureSerializable((Serializable)RpcQosOptions.defaultOptions());
    }

    @Test
    public void builderBuildBuilder() {
        RpcQosOptions rpcQosOptions = RpcQosOptions.defaultOptions();
        int newMaxAttempts = rpcQosOptions.getMaxAttempts() - 1;
        RpcQosOptions.Builder builder = rpcQosOptions.toBuilder().withMaxAttempts(newMaxAttempts);
        RpcQosOptions build = builder.build();
        Assert.assertNotEquals((Object)rpcQosOptions, (Object)build);
        Assert.assertEquals((long)newMaxAttempts, (long)build.getMaxAttempts());
    }

    @Test
    public void populateDisplayData() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(DisplayData.ItemSpec.class);
        DisplayData.Builder builder = (DisplayData.Builder)Mockito.mock(DisplayData.Builder.class);
        Mockito.when((Object)builder.add((DisplayData.ItemSpec)captor.capture())).thenReturn((Object)builder);
        RpcQosOptions rpcQosOptions = RpcQosOptions.defaultOptions();
        rpcQosOptions.populateDisplayData(builder);
        List actualKeys = captor.getAllValues().stream().map(DisplayData.ItemSpec::getKey).sorted().collect(Collectors.toList());
        ArrayList expectedKeys = Lists.newArrayList((Object[])new String[]{"batchInitialCount", "batchMaxBytes", "batchMaxCount", "batchTargetLatency", "hintMaxNumWorkers", "initialBackoff", "maxAttempts", "overloadRatio", "samplePeriod", "samplePeriodBucketSize", "shouldReportDiagnosticMetrics", "throttleDuration"});
        Assert.assertEquals((Object)expectedKeys, actualKeys);
    }

    @Test
    public void defaultOptionsBuildSuccessfully() {
        Assert.assertNotNull((Object)RpcQosOptions.defaultOptions());
    }

    @Test
    public void argumentValidation_maxAttempts() throws Exception {
        BiFunction<RpcQosOptions.Builder, Integer, RpcQosOptions.Builder> f = RpcQosOptions.Builder::withMaxAttempts;
        RpcQosOptionsTest.testNullability(f);
        RpcQosOptionsTest.testIntRange(f, 1, 5);
    }

    @Test
    public void argumentValidation_withInitialBackoff() throws Exception {
        BiFunction<RpcQosOptions.Builder, Duration, RpcQosOptions.Builder> f = RpcQosOptions.Builder::withInitialBackoff;
        RpcQosOptionsTest.testNullability(f);
        RpcQosOptionsTest.testDurationRange(f, Duration.standardSeconds((long)5L), Duration.standardMinutes((long)2L));
    }

    @Test
    public void argumentValidation_withSamplePeriod() throws Exception {
        BiFunction<RpcQosOptions.Builder, Duration, RpcQosOptions.Builder> f = RpcQosOptions.Builder::withSamplePeriod;
        RpcQosOptionsTest.testNullability(f);
        RpcQosOptionsTest.testDurationRange(f, Duration.standardMinutes((long)2L), Duration.standardMinutes((long)20L));
    }

    @Test
    public void argumentValidation_withSampleUpdateFrequency() throws Exception {
        BiFunction<RpcQosOptions.Builder, Duration, RpcQosOptions.Builder> f = RpcQosOptions.Builder::withSamplePeriodBucketSize;
        RpcQosOptionsTest.testNullability(f);
        RpcQosOptionsTest.testDurationRange(f, Duration.standardSeconds((long)10L), Duration.standardMinutes((long)20L));
    }

    @Test
    public void argumentValidation_withSampleUpdateFrequency_lteqSamplePeriod() {
        RpcQosOptions.newBuilder().withSamplePeriod(Duration.millis((long)5L)).withSamplePeriodBucketSize(Duration.millis((long)5L)).validateRelatedFields();
        try {
            RpcQosOptions.newBuilder().withSamplePeriod(Duration.millis((long)5L)).withSamplePeriodBucketSize(Duration.millis((long)6L)).validateRelatedFields();
            Assert.fail((String)"expected validation failure for samplePeriodBucketSize > samplePeriod");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("samplePeriodBucketSize <= samplePeriod"));
        }
    }

    @Test
    public void argumentValidation_withOverloadRatio() throws Exception {
        BiFunction<RpcQosOptions.Builder, Double, RpcQosOptions.Builder> f = RpcQosOptions.Builder::withOverloadRatio;
        RpcQosOptionsTest.testNullability(f);
        RpcQosOptionsTest.testRange(1.0E-4, Double::sum, (a, b) -> a - b, f, 1.0, 1.5);
    }

    @Test
    public void argumentValidation_withThrottleDuration() throws Exception {
        BiFunction<RpcQosOptions.Builder, Duration, RpcQosOptions.Builder> f = RpcQosOptions.Builder::withThrottleDuration;
        RpcQosOptionsTest.testNullability(f);
        RpcQosOptionsTest.testDurationRange(f, Duration.standardSeconds((long)5L), Duration.standardMinutes((long)1L));
    }

    @Test
    public void argumentValidation_withBatchInitialCount() throws Exception {
        BiFunction<RpcQosOptions.Builder, Integer, RpcQosOptions.Builder> f = RpcQosOptions.Builder::withBatchInitialCount;
        RpcQosOptionsTest.testNullability(f);
        RpcQosOptionsTest.testIntRange(f, 1, 500);
    }

    @Test
    public void argumentValidation_withBatchMaxCount() throws Exception {
        BiFunction<RpcQosOptions.Builder, Integer, RpcQosOptions.Builder> f = RpcQosOptions.Builder::withBatchMaxCount;
        RpcQosOptionsTest.testNullability(f);
        RpcQosOptionsTest.testIntRange(f, 1, 500);
    }

    @Test
    public void argumentValidation_withBatchMaxBytes() throws Exception {
        BiFunction<RpcQosOptions.Builder, Long, RpcQosOptions.Builder> f = RpcQosOptions.Builder::withBatchMaxBytes;
        RpcQosOptionsTest.testNullability(f);
        RpcQosOptionsTest.testRange(1L, Math::addExact, Math::subtractExact, f, 1L, 0x980000L);
    }

    @Test
    public void argumentValidation_withBatchTargetLatency() throws Exception {
        BiFunction<RpcQosOptions.Builder, Duration, RpcQosOptions.Builder> f = RpcQosOptions.Builder::withBatchTargetLatency;
        RpcQosOptionsTest.testNullability(f);
        RpcQosOptionsTest.testDurationRange(f, Duration.standardSeconds((long)5L), Duration.standardMinutes((long)2L));
    }

    private static <T> void testNullability(BiFunction<RpcQosOptions.Builder, T, RpcQosOptions.Builder> f) {
        try {
            f.apply(RpcQosOptions.newBuilder(), null).build();
            Assert.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static void testIntRange(BiFunction<RpcQosOptions.Builder, Integer, RpcQosOptions.Builder> f, int min, int max) throws Exception {
        RpcQosOptionsTest.testRange(1, Math::addExact, Math::subtractExact, f, min, max);
    }

    private static void testDurationRange(BiFunction<RpcQosOptions.Builder, Duration, RpcQosOptions.Builder> f, Duration min, Duration max) throws Exception {
        RpcQosOptionsTest.testRange(Duration.millis((long)1L), Duration::plus, Duration::minus, f, min, max);
    }

    private static <T> void testRange(T epsilon, BiFunction<T, T, T> plus, BiFunction<T, T, T> minus, BiFunction<RpcQosOptions.Builder, T, RpcQosOptions.Builder> f, T min, T max) throws Exception {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        errors.addAll(RpcQosOptionsTest.testMinBoundary(epsilon, plus, minus, f, min));
        errors.addAll(RpcQosOptionsTest.testMaxBoundary(epsilon, plus, minus, f, max));
        MultipleFailureException.assertEmpty(errors);
    }

    private static <T> List<Throwable> testMaxBoundary(T epsilon, BiFunction<T, T, T> plus, BiFunction<T, T, T> minus, BiFunction<RpcQosOptions.Builder, T, RpcQosOptions.Builder> f, T max) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            f.apply(RpcQosOptions.newBuilder(), (RpcQosOptions.Builder)minus.apply(max, epsilon)).validateIndividualFields();
        }
        catch (Throwable t) {
            errors.add((Throwable)((Object)RpcQosOptionsTest.newError(t, "max - epsilon")));
        }
        try {
            f.apply(RpcQosOptions.newBuilder(), (RpcQosOptions.Builder)max).validateIndividualFields();
        }
        catch (Throwable t) {
            errors.add((Throwable)((Object)RpcQosOptionsTest.newError(t, "max")));
        }
        try {
            try {
                f.apply(RpcQosOptions.newBuilder(), (RpcQosOptions.Builder)plus.apply(max, epsilon)).validateIndividualFields();
                Assert.fail((String)"expected IllegalArgumentException");
            }
            catch (IllegalArgumentException t) {}
        }
        catch (Throwable t) {
            errors.add((Throwable)((Object)RpcQosOptionsTest.newError(t, "max + epsilon")));
        }
        return errors;
    }

    private static <T> List<Throwable> testMinBoundary(T epsilon, BiFunction<T, T, T> plus, BiFunction<T, T, T> minus, BiFunction<RpcQosOptions.Builder, T, RpcQosOptions.Builder> f, T min) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            try {
                f.apply(RpcQosOptions.newBuilder(), (RpcQosOptions.Builder)minus.apply(min, epsilon)).validateIndividualFields();
                Assert.fail((String)"expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (Throwable t) {
            errors.add((Throwable)((Object)RpcQosOptionsTest.newError(t, "min - epsilon")));
        }
        try {
            f.apply(RpcQosOptions.newBuilder(), (RpcQosOptions.Builder)min).validateIndividualFields();
        }
        catch (Throwable t) {
            errors.add((Throwable)((Object)RpcQosOptionsTest.newError(t, "min")));
        }
        try {
            f.apply(RpcQosOptions.newBuilder(), (RpcQosOptions.Builder)plus.apply(min, epsilon)).validateIndividualFields();
        }
        catch (Throwable t) {
            errors.add((Throwable)((Object)RpcQosOptionsTest.newError(t, "min + epsilon")));
        }
        return errors;
    }

    private static AssertionError newError(Throwable t, String conditionDescription) {
        return new AssertionError(String.format("error while testing boundary condition (%s)", conditionDescription), t);
    }
}

