/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1ReadFn;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public final class PartitionQueryResponseToRunQueryRequestTest {
    @Mock
    protected DoFn.ProcessContext processContext;

    @Test
    public void ensureSortingCorrectlyHandlesPathSegments() {
        ArrayList expected = Lists.newArrayList((Object[])new Cursor[]{PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p1/databases/d1/documents/c1/doc1"), PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p1/databases/d1/documents/c1/doc2"), PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p1/databases/d1/documents/c1/doc2/c2/doc1"), PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p1/databases/d1/documents/c1/doc2/c2/doc2"), PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p1/databases/d1/documents/c10/doc1"), PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p1/databases/d1/documents/c2/doc1"), PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p2/databases/d2/documents/c1/doc1"), PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p2/databases/d2/documents/c1-/doc1"), PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p2/databases/d3/documents/c1-/doc1"), PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p2/databases/d3/documents/c1-/doc1"), Cursor.newBuilder().build()});
        for (int i = 0; i < 1000; ++i) {
            ArrayList list = new ArrayList(expected);
            Collections.shuffle(list);
            list.sort(FirestoreV1.PartitionQuery.PartitionQueryResponseToRunQueryRequest.CURSOR_REFERENCE_VALUE_COMPARATOR);
            Assert.assertEquals((Object)expected, list);
        }
    }

    @Test
    public void ensureCursorPairingWorks() {
        StructuredQuery query = StructuredQuery.newBuilder().addFrom(StructuredQuery.CollectionSelector.newBuilder().setAllDescendants(true).setCollectionId("c1").build()).build();
        Cursor cursor1 = PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p1/databases/d1/documents/c1/doc1");
        Cursor cursor2 = PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p1/databases/d1/documents/c1/doc2");
        Cursor cursor3 = PartitionQueryResponseToRunQueryRequestTest.referenceValueCursor("projects/p1/databases/d1/documents/c1/doc2/c2/doc2");
        ArrayList expectedQueries = Lists.newArrayList((Object[])new StructuredQuery[]{PartitionQueryResponseToRunQueryRequestTest.newQueryWithCursors(query, null, cursor1), PartitionQueryResponseToRunQueryRequestTest.newQueryWithCursors(query, cursor1, cursor2), PartitionQueryResponseToRunQueryRequestTest.newQueryWithCursors(query, cursor2, cursor3), PartitionQueryResponseToRunQueryRequestTest.newQueryWithCursors(query, cursor3, null)});
        FirestoreV1ReadFn.PartitionQueryPair partitionQueryPair = new FirestoreV1ReadFn.PartitionQueryPair(PartitionQueryRequest.newBuilder().setStructuredQuery(query).build(), PartitionQueryResponse.newBuilder().addPartitions(cursor3).addPartitions(cursor1).addPartitions(cursor2).build());
        ArgumentCaptor captor = ArgumentCaptor.forClass(RunQueryRequest.class);
        Mockito.when((Object)((FirestoreV1ReadFn.PartitionQueryPair)this.processContext.element())).thenReturn((Object)partitionQueryPair);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((RunQueryRequest)captor.capture()));
        FirestoreV1.PartitionQuery.PartitionQueryResponseToRunQueryRequest fn = new FirestoreV1.PartitionQuery.PartitionQueryResponseToRunQueryRequest();
        fn.processElement(this.processContext);
        List actualQueries = captor.getAllValues().stream().map(RunQueryRequest::getStructuredQuery).collect(Collectors.toList());
        Assert.assertEquals((Object)expectedQueries, actualQueries);
    }

    @Test
    public void ensureCursorPairingWorks_emptyCursorsInResponse() {
        StructuredQuery query = StructuredQuery.newBuilder().addFrom(StructuredQuery.CollectionSelector.newBuilder().setAllDescendants(true).setCollectionId("c1").build()).build();
        ArrayList expectedQueries = Lists.newArrayList((Object[])new StructuredQuery[]{query});
        FirestoreV1ReadFn.PartitionQueryPair partitionQueryPair = new FirestoreV1ReadFn.PartitionQueryPair(PartitionQueryRequest.newBuilder().setStructuredQuery(query).build(), PartitionQueryResponse.newBuilder().build());
        ArgumentCaptor captor = ArgumentCaptor.forClass(RunQueryRequest.class);
        Mockito.when((Object)((FirestoreV1ReadFn.PartitionQueryPair)this.processContext.element())).thenReturn((Object)partitionQueryPair);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((RunQueryRequest)captor.capture()));
        FirestoreV1.PartitionQuery.PartitionQueryResponseToRunQueryRequest fn = new FirestoreV1.PartitionQuery.PartitionQueryResponseToRunQueryRequest();
        fn.processElement(this.processContext);
        List actualQueries = captor.getAllValues().stream().map(RunQueryRequest::getStructuredQuery).collect(Collectors.toList());
        Assert.assertEquals((Object)expectedQueries, actualQueries);
    }

    private static Cursor referenceValueCursor(String referenceValue) {
        return Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue(referenceValue).build()).build();
    }

    private static StructuredQuery newQueryWithCursors(StructuredQuery query, Cursor startAt, Cursor endAt) {
        StructuredQuery.Builder builder = query.toBuilder();
        if (startAt != null) {
            builder.setStartAt(startAt);
        }
        if (endAt != null) {
            builder.setEndAt(endAt);
        }
        return builder.build();
    }
}

