/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1FnTest;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1ReadFnTest;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1ReadFn;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public final class FirestoreV1FnListCollectionIdsTest
extends BaseFirestoreV1ReadFnTest<ListCollectionIdsRequest, ListCollectionIdsResponse> {
    @Mock
    private UnaryCallable<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse> callable;
    @Mock
    private FirestoreClient.ListCollectionIdsPagedResponse pagedResponse1;
    @Mock
    private FirestoreClient.ListCollectionIdsPage page1;
    @Mock
    private FirestoreClient.ListCollectionIdsPagedResponse pagedResponse2;
    @Mock
    private FirestoreClient.ListCollectionIdsPage page2;

    @Test
    public void endToEnd() throws Exception {
        ListCollectionIdsRequest request1 = ListCollectionIdsRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
        ListCollectionIdsResponse response1 = ListCollectionIdsResponse.newBuilder().addCollectionIds("col_1-1").addCollectionIds("col_1-2").addCollectionIds("col_1-3").setNextPageToken("page2").build();
        Mockito.when((Object)this.page1.getNextPageToken()).thenReturn((Object)response1.getNextPageToken());
        Mockito.when((Object)((ListCollectionIdsResponse)this.page1.getResponse())).thenReturn((Object)response1);
        Mockito.when((Object)this.page1.hasNextPage()).thenReturn((Object)true);
        ListCollectionIdsResponse response2 = ListCollectionIdsResponse.newBuilder().addCollectionIds("col_2-1").build();
        Mockito.when((Object)((ListCollectionIdsResponse)this.page2.getResponse())).thenReturn((Object)response2);
        Mockito.when((Object)this.page2.hasNextPage()).thenReturn((Object)false);
        Mockito.when((Object)this.pagedResponse1.iteratePages()).thenReturn((Object)ImmutableList.of((Object)this.page1, (Object)this.page2));
        Mockito.when((Object)((FirestoreClient.ListCollectionIdsPagedResponse)this.callable.call((Object)request1))).thenReturn((Object)this.pagedResponse1);
        Mockito.when((Object)this.stub.listCollectionIdsPagedCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        RpcQosOptions options = RpcQosOptions.defaultOptions();
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)FirestoreStatefulComponentFactory.INSTANCE.getRpcQos(options));
        ArgumentCaptor responses = ArgumentCaptor.forClass(ListCollectionIdsResponse.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((ListCollectionIdsResponse)responses.capture()));
        Mockito.when((Object)((ListCollectionIdsRequest)this.processContext.element())).thenReturn((Object)request1);
        FirestoreV1ReadFn.ListCollectionIdsFn fn = new FirestoreV1ReadFn.ListCollectionIdsFn(this.clock, this.ff, options);
        this.runFunction(fn);
        ArrayList expected = Lists.newArrayList((Object[])new ListCollectionIdsResponse[]{response1, response2});
        List allValues = responses.getAllValues();
        Assert.assertEquals((Object)expected, (Object)allValues);
    }

    @Override
    public void resumeFromLastReadValue() throws Exception {
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)this.rpcQos);
        Mockito.when((Object)this.rpcQos.newReadAttempt((RpcQos.RpcAttempt.Context)ArgumentMatchers.any())).thenReturn((Object)this.attempt);
        Mockito.when((Object)this.attempt.awaitSafeToProceed((Instant)ArgumentMatchers.any())).thenReturn((Object)true);
        ListCollectionIdsRequest request1 = ListCollectionIdsRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
        ListCollectionIdsResponse response1 = ListCollectionIdsResponse.newBuilder().addCollectionIds("col_1-1").addCollectionIds("col_1-2").addCollectionIds("col_1-3").setNextPageToken("page2").build();
        Mockito.when((Object)this.page1.getNextPageToken()).thenReturn((Object)response1.getNextPageToken());
        Mockito.when((Object)((ListCollectionIdsResponse)this.page1.getResponse())).thenReturn((Object)response1);
        Mockito.when((Object)this.page1.hasNextPage()).thenReturn((Object)true);
        Mockito.when((Object)((FirestoreClient.ListCollectionIdsPagedResponse)this.callable.call((Object)request1))).thenReturn((Object)this.pagedResponse1);
        ((RpcQos.RpcReadAttempt)Mockito.doNothing().when((Object)this.attempt)).checkCanRetry((Instant)ArgumentMatchers.any(), (RuntimeException)ArgumentMatchers.eq((Object)RETRYABLE_ERROR));
        Mockito.when((Object)this.pagedResponse1.iteratePages()).thenAnswer(invocation -> new Iterable<FirestoreClient.ListCollectionIdsPage>(){

            @Override
            public Iterator<FirestoreClient.ListCollectionIdsPage> iterator() {
                return new AbstractIterator<FirestoreClient.ListCollectionIdsPage>(){
                    private boolean first = true;

                    protected FirestoreClient.ListCollectionIdsPage computeNext() {
                        if (this.first) {
                            this.first = false;
                            return FirestoreV1FnListCollectionIdsTest.this.page1;
                        }
                        throw BaseFirestoreV1FnTest.RETRYABLE_ERROR;
                    }
                };
            }
        });
        ListCollectionIdsRequest request2 = ListCollectionIdsRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).setPageToken("page2").build();
        ListCollectionIdsResponse response2 = ListCollectionIdsResponse.newBuilder().addCollectionIds("col_2-1").build();
        Mockito.when((Object)((ListCollectionIdsResponse)this.page2.getResponse())).thenReturn((Object)response2);
        Mockito.when((Object)this.page2.hasNextPage()).thenReturn((Object)false);
        Mockito.when((Object)((FirestoreClient.ListCollectionIdsPagedResponse)this.callable.call((Object)request2))).thenReturn((Object)this.pagedResponse2);
        Mockito.when((Object)this.pagedResponse2.iteratePages()).thenReturn((Object)ImmutableList.of((Object)this.page2));
        Mockito.when((Object)this.stub.listCollectionIdsPagedCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        ArgumentCaptor responses = ArgumentCaptor.forClass(ListCollectionIdsResponse.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((ListCollectionIdsResponse)responses.capture()));
        Mockito.when((Object)((ListCollectionIdsRequest)this.processContext.element())).thenReturn((Object)request1);
        FirestoreV1ReadFn.ListCollectionIdsFn fn = new FirestoreV1ReadFn.ListCollectionIdsFn(this.clock, this.ff, this.rpcQosOptions);
        this.runFunction(fn);
        ArrayList expected = Lists.newArrayList((Object[])new ListCollectionIdsResponse[]{response1, response2});
        List allValues = responses.getAllValues();
        Assert.assertEquals((Object)expected, (Object)allValues);
    }

    @Override
    protected BaseFirestoreV1ReadFnTest.V1RpcFnTestCtx newCtx() {
        return new BaseFirestoreV1ReadFnTest.V1RpcFnTestCtx(){

            public ListCollectionIdsRequest getRequest() {
                return ListCollectionIdsRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
            }

            @Override
            public void mockRpcToCallable(FirestoreStub stub) {
                Mockito.when((Object)stub.listCollectionIdsPagedCallable()).thenReturn((Object)FirestoreV1FnListCollectionIdsTest.this.callable);
            }

            public void whenCallableCall(ListCollectionIdsRequest in, Throwable ... throwables) {
                Mockito.when((Object)((FirestoreClient.ListCollectionIdsPagedResponse)FirestoreV1FnListCollectionIdsTest.this.callable.call((Object)in))).thenThrow(throwables);
            }

            @Override
            public void verifyNoInteractionsWithCallable() {
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{FirestoreV1FnListCollectionIdsTest.this.callable});
            }
        };
    }

    protected FirestoreV1ReadFn.ListCollectionIdsFn getFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
        return new FirestoreV1ReadFn.ListCollectionIdsFn(clock, firestoreStatefulComponentFactory, rpcQosOptions);
    }
}

