/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Entity;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.client.DatastoreHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreIO;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreV1;
import org.apache.beam.sdk.io.gcp.datastore.V1TestOptions;
import org.apache.beam.sdk.io.gcp.datastore.V1TestUtil;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class V1WriteIT {
    private V1TestOptions options;
    private String project;
    private String ancestor;
    private final long numEntities = 1000L;

    @Before
    public void setup() {
        PipelineOptionsFactory.register(V1TestOptions.class);
        this.options = (V1TestOptions)TestPipeline.testingPipelineOptions().as(V1TestOptions.class);
        this.project = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
        this.ancestor = UUID.randomUUID().toString();
    }

    @Test
    public void testE2EV1Write() throws Exception {
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        ((PCollection)((PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).to(1000L))).apply((PTransform)ParDo.of((DoFn)new V1TestUtil.CreateEntityFn(this.options.getKind(), this.options.getNamespace(), this.ancestor, 0)))).apply((PTransform)DatastoreIO.v1().write().withProjectId(this.project));
        p.run();
        long numEntitiesWritten = V1TestUtil.countEntities(this.options, this.project, this.ancestor);
        Assert.assertEquals((long)1000L, (long)numEntitiesWritten);
    }

    @Test
    public void testDatastoreWriterFnWithDuplicatedEntities() throws Exception {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(200);
        V1TestOptions options = (V1TestOptions)TestPipeline.testingPipelineOptions().as(V1TestOptions.class);
        Pipeline pipeline = TestPipeline.create((PipelineOptions)options);
        for (int i = 1; i <= 200; ++i) {
            Key key = DatastoreHelper.makeKey((Object[])new Object[]{"key" + i, i + 1}).build();
            mutations.add(DatastoreHelper.makeUpsert((Entity)Entity.newBuilder().setKey(key).build()).build());
            if (i % 30 != 0) continue;
            mutations.add(DatastoreHelper.makeUpsert((Entity)Entity.newBuilder().setKey(key).build()).build());
        }
        DatastoreV1.DatastoreWriterFn datastoreWriter = new DatastoreV1.DatastoreWriterFn(((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject(), null);
        ParDo.SingleOutput datastoreWriterTransform = ParDo.of((DoFn)datastoreWriter);
        ArrayList newArrayList = new ArrayList(mutations);
        Create.Values mutationIterable = Create.of(Collections.singleton(newArrayList));
        PCollection input = (PCollection)pipeline.apply((PTransform)mutationIterable);
        ((PCollection)input.apply((PTransform)Flatten.iterables())).apply((PTransform)datastoreWriterTransform);
        PipelineResult pResult = pipeline.run();
        MetricQueryResults metricResults = pResult.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named(DatastoreV1.DatastoreWriterFn.class, (String)"batchSize")).build());
        AtomicLong timesCommitted = new AtomicLong();
        metricResults.getDistributions().forEach(distribution -> {
            if (distribution.getName().getName().equals("batchSize")) {
                timesCommitted.set(((DistributionResult)distribution.getCommitted()).getCount());
            }
        });
        Assert.assertEquals((long)7L, (long)timesCommitted.get());
    }

    @Test
    public void testE2EV1WriteWithLargeEntities() throws Exception {
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        int rawPropertySize = 900000;
        int numLargeEntities = 100;
        ((PCollection)((PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).to(100L))).apply((PTransform)ParDo.of((DoFn)new V1TestUtil.CreateEntityFn(this.options.getKind(), this.options.getNamespace(), this.ancestor, 900000)))).apply((PTransform)DatastoreIO.v1().write().withProjectId(this.project));
        p.run();
        long numEntitiesWritten = V1TestUtil.countEntities(this.options, this.project, this.ancestor);
        Assert.assertEquals((long)100L, (long)numEntitiesWritten);
    }

    @After
    public void tearDown() throws Exception {
        V1TestUtil.deleteAllEntities(this.options, this.project, this.ancestor);
    }
}

