/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import org.apache.beam.sdk.io.gcp.datastore.DataStoreV1SchemaIOProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataStoreV1SchemaIOProviderTest {
    static final String DEFAULT_KEY_FIELD = "__key__";
    public static final String KEY_FIELD_PROPERTY = "keyField";
    private DataStoreV1SchemaIOProvider provider = new DataStoreV1SchemaIOProvider();

    @Test
    public void testGetTableType() {
        Assert.assertEquals((Object)"datastoreV1", (Object)this.provider.identifier());
    }

    @Test
    public void testBuildBeamSqlTable() {
        String location = "projectId/batch_kind";
        Row configuration = Row.withSchema((Schema)this.provider.configurationSchema()).withFieldValue(KEY_FIELD_PROPERTY, null).build();
        DataStoreV1SchemaIOProvider.DataStoreV1SchemaIO schemaIO = this.provider.from("projectId/batch_kind", configuration, DataStoreV1SchemaIOProviderTest.generateDataSchema());
        Assert.assertNotNull((Object)schemaIO);
        Assert.assertTrue((boolean)(schemaIO instanceof DataStoreV1SchemaIOProvider.DataStoreV1SchemaIO));
        DataStoreV1SchemaIOProvider.DataStoreV1SchemaIO dataStoreV1SchemaIO = schemaIO;
        Assert.assertEquals((Object)"projectId", (Object)dataStoreV1SchemaIO.projectId);
        Assert.assertEquals((Object)"batch_kind", (Object)dataStoreV1SchemaIO.kind);
        Assert.assertEquals((Object)DEFAULT_KEY_FIELD, (Object)dataStoreV1SchemaIO.keyField);
    }

    @Test
    public void testTableProperty() {
        String location = "projectId/batch_kind";
        Row configuration = Row.withSchema((Schema)this.provider.configurationSchema()).withFieldValue(KEY_FIELD_PROPERTY, (Object)"field_name").build();
        DataStoreV1SchemaIOProvider.DataStoreV1SchemaIO schemaIO = this.provider.from("projectId/batch_kind", configuration, DataStoreV1SchemaIOProviderTest.generateDataSchema());
        Assert.assertNotNull((Object)schemaIO);
        Assert.assertTrue((boolean)(schemaIO instanceof DataStoreV1SchemaIOProvider.DataStoreV1SchemaIO));
        DataStoreV1SchemaIOProvider.DataStoreV1SchemaIO dataStoreV1SchemaIO = schemaIO;
        Assert.assertEquals((Object)"projectId", (Object)dataStoreV1SchemaIO.projectId);
        Assert.assertEquals((Object)"batch_kind", (Object)dataStoreV1SchemaIO.kind);
        Assert.assertEquals((Object)"field_name", (Object)dataStoreV1SchemaIO.keyField);
    }

    @Test
    public void testTableProperty_nullValue_throwsException() {
        String location = "projectId/batch_kind";
        Row configuration = Row.withSchema((Schema)this.provider.configurationSchema()).withFieldValue(KEY_FIELD_PROPERTY, (Object)"").build();
        Assert.assertThrows(IllegalArgumentException.class, () -> new DataStoreV1SchemaIOProvider().from("projectId/batch_kind", configuration, DataStoreV1SchemaIOProviderTest.generateDataSchema()));
    }

    private static Schema generateDataSchema() {
        return Schema.builder().addNullableField("id", Schema.FieldType.INT32).addNullableField("name", Schema.FieldType.STRING).build();
    }
}

