/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.Row;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.gcp.testing.BigtableUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Longs;

class BigtableTestUtils {
    static final String BOOL_COLUMN = "boolColumn";
    static final String LONG_COLUMN = "longColumn";
    static final String STRING_COLUMN = "stringColumn";
    static final String DOUBLE_COLUMN = "doubleColumn";
    static final String FAMILY_TEST = "familyTest";
    static final Schema LONG_COLUMN_SCHEMA = Schema.builder().addInt64Field("val").addInt64Field("timestampMicros").addArrayField("labels", Schema.FieldType.STRING).build();
    static final Schema TEST_FAMILY_SCHEMA = Schema.builder().addBooleanField("boolColumn").addRowField("longColumn", LONG_COLUMN_SCHEMA).addArrayField("stringColumn", Schema.FieldType.STRING).addDoubleField("doubleColumn").build();
    static final Schema TEST_SCHEMA = Schema.builder().addStringField("key").addRowField("familyTest", TEST_FAMILY_SCHEMA).build();
    static final Schema TEST_FLAT_SCHEMA = Schema.builder().addStringField("key").addBooleanField("boolColumn").addInt64Field("longColumn").addStringField("stringColumn").addDoubleField("doubleColumn").build();
    static final long NOW = 5000000000L;
    static final long LATER = 5000001000L;

    BigtableTestUtils() {
    }

    static Row bigtableRow(long i) {
        return Row.newBuilder().setKey(ByteString.copyFromUtf8((String)("key" + i))).addFamilies(BigtableTestUtils.bigtableFamily()).build();
    }

    static KV<ByteString, Iterable<Mutation>> rowMutation(long i) {
        ImmutableList mutations = ImmutableList.of((Object)BigtableTestUtils.mutation(BOOL_COLUMN, ByteString.copyFrom((byte[])BigtableUtils.booleanToByteArray((boolean)false))), (Object)BigtableTestUtils.mutation(DOUBLE_COLUMN, ByteString.copyFrom((byte[])BigtableUtils.doubleToByteArray((double)5.5))), (Object)BigtableTestUtils.mutation(LONG_COLUMN, ByteString.copyFrom((byte[])Longs.toByteArray((long)2L))), (Object)BigtableTestUtils.mutation(STRING_COLUMN, ByteString.copyFromUtf8((String)"value1")));
        return KV.of((Object)ByteString.copyFrom((byte[])("key" + i).getBytes(StandardCharsets.UTF_8)), (Object)mutations);
    }

    private static Mutation mutation(String column, ByteString value) {
        return Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setFamilyName(FAMILY_TEST).setColumnQualifier(ByteString.copyFromUtf8((String)column)).setValue(value).build()).build();
    }

    private static Family bigtableFamily() {
        return Family.newBuilder().setName(FAMILY_TEST).addColumns(Column.newBuilder().setQualifier(ByteString.copyFromUtf8((String)BOOL_COLUMN)).addCells(BigtableTestUtils.createCell(ByteString.copyFrom((byte[])BigtableUtils.booleanToByteArray((boolean)true)), 5000000000L, new String[0])).addCells(BigtableTestUtils.createCell(ByteString.copyFrom((byte[])BigtableUtils.booleanToByteArray((boolean)false)), 5000001000L, new String[0]))).addColumns(Column.newBuilder().setQualifier(ByteString.copyFromUtf8((String)LONG_COLUMN)).addCells(BigtableTestUtils.createCell(ByteString.copyFrom((byte[])Longs.toByteArray((long)5L)), 5000000000L, "label1")).addCells(BigtableTestUtils.createCell(ByteString.copyFrom((byte[])Longs.toByteArray((long)2L)), 5000001000L, "label1")).build()).addColumns(Column.newBuilder().setQualifier(ByteString.copyFromUtf8((String)STRING_COLUMN)).addCells(BigtableTestUtils.createCell(ByteString.copyFromUtf8((String)"value2"), 5000000000L, "label1")).addCells(BigtableTestUtils.createCell(ByteString.copyFromUtf8((String)"value1"), 5000001000L, "label1")).build()).addColumns(Column.newBuilder().setQualifier(ByteString.copyFromUtf8((String)DOUBLE_COLUMN)).addCells(BigtableTestUtils.createCell(ByteString.copyFrom((byte[])BigtableUtils.doubleToByteArray((double)0.66)), 5000000000L, "label1")).addCells(BigtableTestUtils.createCell(ByteString.copyFrom((byte[])BigtableUtils.doubleToByteArray((double)5.5)), 5000001000L, "label1")).build()).addColumns(Column.newBuilder().setQualifier(ByteString.copyFromUtf8((String)"binaryColumn")).addCells(BigtableTestUtils.createCell(ByteString.copyFrom((byte[])new byte[]{0, 1, 2}), 5000000000L, "label1")).addCells(BigtableTestUtils.createCell(ByteString.copyFrom((byte[])new byte[]{2, 1, 0}), 5000001000L, "label2")).build()).build();
    }

    private static Cell createCell(ByteString value, long timestamp, String ... labels) {
        Cell.Builder builder = Cell.newBuilder().setValue(value).setTimestampMicros(timestamp);
        if (labels.length > 0) {
            builder.addAllLabels((Iterable)ImmutableList.copyOf((Object[])labels));
        }
        return builder.build();
    }
}

