/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Row;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableRowToBeamRow;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableTestUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Rule;
import org.junit.Test;

public class BigtableRowToBeamRowTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testBigtableRowToBeamRow() {
        PCollection rows = ((PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)BigtableTestUtils.bigtableRow(1L), (Object[])new Row[]{BigtableTestUtils.bigtableRow(2L)}))).setCoder((Coder)ProtoCoder.of((TypeDescriptor)TypeDescriptor.of(Row.class))).apply((PTransform)new BigtableRowToBeamRow(BigtableTestUtils.TEST_SCHEMA))).setRowSchema(BigtableTestUtils.TEST_SCHEMA).apply((PTransform)MapElements.via((SimpleFunction)new SortStringColumn()))).setRowSchema(BigtableTestUtils.TEST_SCHEMA);
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new org.apache.beam.sdk.values.Row[]{this.row(1L), this.row(2L)});
        this.pipeline.run().waitUntilFinish();
    }

    private org.apache.beam.sdk.values.Row row(long i) {
        return org.apache.beam.sdk.values.Row.withSchema((Schema)BigtableTestUtils.TEST_SCHEMA).attachValues(new Object[]{"key" + i, this.familyRow()});
    }

    private org.apache.beam.sdk.values.Row familyRow() {
        return org.apache.beam.sdk.values.Row.withSchema((Schema)BigtableTestUtils.TEST_FAMILY_SCHEMA).attachValues(new Object[]{false, org.apache.beam.sdk.values.Row.withSchema((Schema)BigtableTestUtils.LONG_COLUMN_SCHEMA).attachValues(new Object[]{2L, 5000001000L, ImmutableList.of((Object)"label1")}), ImmutableList.of((Object)"value1", (Object)"value2"), 5.5});
    }

    private static class SortStringColumn
    extends SimpleFunction<org.apache.beam.sdk.values.Row, org.apache.beam.sdk.values.Row> {
        private SortStringColumn() {
        }

        public org.apache.beam.sdk.values.Row apply(org.apache.beam.sdk.values.Row row) {
            org.apache.beam.sdk.values.Row familyRow = row.getRow("familyTest");
            return org.apache.beam.sdk.values.Row.fromRow((org.apache.beam.sdk.values.Row)row).withFieldValue("familyTest", (Object)org.apache.beam.sdk.values.Row.fromRow((org.apache.beam.sdk.values.Row)familyRow).withFieldValue("stringColumn", familyRow.getArray("stringColumn").stream().sorted().collect(Collectors.toList())).build()).build();
        }
    }
}

