/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.core.ApiFutures;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.beam.sdk.io.gcp.bigquery.RetryManager;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RetryManagerTest {
    @Test
    public void testNoFailures() throws Exception {
        ArrayList contexts = Lists.newArrayList();
        RetryManager retryManager = new RetryManager(Duration.millis((long)1L), Duration.millis((long)1L), 5);
        for (int i = 0; i < 5; ++i) {
            Context context = new Context();
            contexts.add(context);
            retryManager.addOperation(c -> {
                ++c.numStarted;
                return ApiFutures.immediateFuture((Object)"yes");
            }, cs -> {
                cs.forEach(c -> ++c.numFailed);
                return RetryManager.RetryType.DONT_RETRY;
            }, c -> ++c.numSucceeded, (RetryManager.Operation.Context)context);
        }
        contexts.forEach(c -> {
            Assert.assertEquals((long)0L, (long)c.numStarted);
            Assert.assertEquals((long)0L, (long)c.numSucceeded);
            Assert.assertEquals((long)0L, (long)c.numFailed);
        });
        retryManager.run(true);
        contexts.forEach(c -> {
            Assert.assertEquals((long)1L, (long)c.numStarted);
            Assert.assertEquals((long)1L, (long)c.numSucceeded);
            Assert.assertEquals((long)0L, (long)c.numFailed);
        });
    }

    @Test
    public void testRetryInOrder() throws Exception {
        HashMap contexts = Maps.newHashMap();
        HashMap expectedStarts = Maps.newHashMap();
        HashMap expectedFailures = Maps.newHashMap();
        RetryManager retryManager = new RetryManager(Duration.millis((long)1L), Duration.millis((long)1L), 50);
        for (int i = 0; i < 5; ++i) {
            int index = i;
            String value = "yes " + i;
            Context context = new Context();
            contexts.put(value, context);
            expectedStarts.put(value, i + 2);
            expectedFailures.put(value, i + 1);
            retryManager.addOperation(c -> {
                if (c.numStarted <= index) {
                    ++c.numStarted;
                    RuntimeException e = new RuntimeException("foo");
                    return ApiFutures.immediateFailedFuture((Throwable)e);
                }
                ++c.numStarted;
                return ApiFutures.immediateFuture((Object)value);
            }, cs -> {
                cs.forEach(c -> ++c.numFailed);
                return RetryManager.RetryType.RETRY_ALL_OPERATIONS;
            }, c -> ++c.numSucceeded, (RetryManager.Operation.Context)context);
        }
        contexts.values().forEach(c -> {
            Assert.assertEquals((long)0L, (long)c.numStarted);
            Assert.assertEquals((long)0L, (long)c.numSucceeded);
            Assert.assertEquals((long)0L, (long)c.numFailed);
        });
        retryManager.run(true);
        contexts.entrySet().forEach(e -> {
            Assert.assertEquals((long)((Integer)expectedStarts.get(e.getKey())).intValue(), (long)((Context)((Object)((Object)e.getValue()))).numStarted);
            Assert.assertEquals((long)1L, (long)((Context)((Object)((Object)e.getValue()))).numSucceeded);
            Assert.assertEquals((long)((Integer)expectedFailures.get(e.getKey())).intValue(), (long)((Context)((Object)((Object)e.getValue()))).numFailed);
        });
    }

    @Test
    public void testDontRetry() throws Exception {
        ArrayList contexts = Lists.newArrayList();
        RetryManager retryManager = new RetryManager(Duration.millis((long)1L), Duration.millis((long)1L), 50);
        for (int i = 0; i < 5; ++i) {
            Context context = new Context();
            contexts.add(context);
            String value = "yes " + i;
            retryManager.addOperation(c -> {
                if (c.numStarted == 0) {
                    ++c.numStarted;
                    RuntimeException e = new RuntimeException("foo");
                    return ApiFutures.immediateFailedFuture((Throwable)e);
                }
                ++c.numStarted;
                return ApiFutures.immediateFuture((Object)value);
            }, cs -> {
                cs.forEach(c -> ++c.numFailed);
                return RetryManager.RetryType.DONT_RETRY;
            }, c -> ++c.numSucceeded, (RetryManager.Operation.Context)context);
        }
        contexts.forEach(c -> {
            Assert.assertEquals((long)0L, (long)c.numStarted);
            Assert.assertEquals((long)0L, (long)c.numSucceeded);
            Assert.assertEquals((long)0L, (long)c.numFailed);
        });
        retryManager.run(true);
        contexts.forEach(c -> {
            Assert.assertEquals((long)1L, (long)c.numStarted);
            Assert.assertEquals((long)0L, (long)c.numSucceeded);
            Assert.assertEquals((long)1L, (long)c.numFailed);
        });
    }

    @Test
    public void testHasSucceeded() throws Exception {
        ArrayList contexts = Lists.newArrayList();
        RetryManager retryManager = new RetryManager(Duration.millis((long)1L), Duration.millis((long)1L), 5);
        for (int i = 0; i < 5; ++i) {
            Context context = new Context();
            contexts.add(context);
            retryManager.addOperation(c -> {
                ++c.numStarted;
                return ApiFutures.immediateFuture((Object)"yes");
            }, cs -> {
                cs.forEach(c -> ++c.numFailed);
                return RetryManager.RetryType.DONT_RETRY;
            }, c -> ++c.numSucceeded, c -> false, (RetryManager.Operation.Context)context);
        }
        contexts.forEach(c -> {
            Assert.assertEquals((long)0L, (long)c.numStarted);
            Assert.assertEquals((long)0L, (long)c.numSucceeded);
            Assert.assertEquals((long)0L, (long)c.numFailed);
        });
        retryManager.run(true);
        contexts.forEach(c -> {
            Assert.assertEquals((long)1L, (long)c.numStarted);
            Assert.assertEquals((long)0L, (long)c.numSucceeded);
            Assert.assertEquals((long)1L, (long)c.numFailed);
        });
    }

    static class Context
    extends RetryManager.Operation.Context<String> {
        int numStarted = 0;
        int numSucceeded = 0;
        int numFailed = 0;

        Context() {
        }
    }
}

