/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.Mode;
import org.apache.beam.sdk.io.gcp.bigquery.StandardSQLTypeName;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryUtilsTest {
    private static final Schema FLAT_TYPE = Schema.builder().addNullableField("id", Schema.FieldType.INT64).addNullableField("value", Schema.FieldType.DOUBLE).addNullableField("name", Schema.FieldType.STRING).addNullableField("timestamp_variant1", Schema.FieldType.DATETIME).addNullableField("timestamp_variant2", Schema.FieldType.DATETIME).addNullableField("timestamp_variant3", Schema.FieldType.DATETIME).addNullableField("timestamp_variant4", Schema.FieldType.DATETIME).addNullableField("datetime", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME)).addNullableField("datetime0ms", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME)).addNullableField("datetime0s_ns", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME)).addNullableField("datetime0s_0ns", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME)).addNullableField("date", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATE)).addNullableField("time", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME)).addNullableField("time0ms", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME)).addNullableField("time0s_ns", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME)).addNullableField("time0s_0ns", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME)).addNullableField("valid", Schema.FieldType.BOOLEAN).addNullableField("binary", Schema.FieldType.BYTES).addNullableField("numeric", Schema.FieldType.DECIMAL).addNullableField("boolean", Schema.FieldType.BOOLEAN).addNullableField("long", Schema.FieldType.INT64).addNullableField("double", Schema.FieldType.DOUBLE).build();
    private static final Schema ENUM_TYPE = Schema.builder().addNullableField("color", Schema.FieldType.logicalType((Schema.LogicalType)EnumerationType.create((String[])new String[]{"RED", "GREEN", "BLUE"}))).build();
    private static final Schema ENUM_STRING_TYPE = Schema.builder().addNullableField("color", Schema.FieldType.STRING).build();
    private static final Schema MAP_TYPE = Schema.builder().addStringField("key").addDoubleField("value").build();
    private static final Schema ARRAY_TYPE = Schema.builder().addArrayField("ids", Schema.FieldType.INT64).build();
    private static final Schema ROW_TYPE = Schema.builder().addNullableField("row", Schema.FieldType.row((Schema)FLAT_TYPE)).build();
    private static final Schema ARRAY_ROW_TYPE = Schema.builder().addArrayField("rows", Schema.FieldType.row((Schema)FLAT_TYPE)).build();
    private static final Schema MAP_ARRAY_TYPE = Schema.builder().addArrayField("map", Schema.FieldType.row((Schema)MAP_TYPE)).build();
    private static final Schema MAP_MAP_TYPE = Schema.builder().addMapField("map", Schema.FieldType.STRING, Schema.FieldType.DOUBLE).build();
    private static final TableFieldSchema ID = new TableFieldSchema().setName("id").setType(StandardSQLTypeName.INT64.toString());
    private static final TableFieldSchema VALUE = new TableFieldSchema().setName("value").setType(StandardSQLTypeName.FLOAT64.toString());
    private static final TableFieldSchema NAME = new TableFieldSchema().setName("name").setType(StandardSQLTypeName.STRING.toString());
    private static final TableFieldSchema TIMESTAMP_VARIANT1 = new TableFieldSchema().setName("timestamp_variant1").setType(StandardSQLTypeName.TIMESTAMP.toString());
    private static final TableFieldSchema TIMESTAMP_VARIANT2 = new TableFieldSchema().setName("timestamp_variant2").setType(StandardSQLTypeName.TIMESTAMP.toString());
    private static final TableFieldSchema TIMESTAMP_VARIANT3 = new TableFieldSchema().setName("timestamp_variant3").setType(StandardSQLTypeName.TIMESTAMP.toString());
    private static final TableFieldSchema TIMESTAMP_VARIANT4 = new TableFieldSchema().setName("timestamp_variant4").setType(StandardSQLTypeName.TIMESTAMP.toString());
    private static final TableFieldSchema DATETIME = new TableFieldSchema().setName("datetime").setType(StandardSQLTypeName.DATETIME.toString());
    private static final TableFieldSchema DATETIME_0MS = new TableFieldSchema().setName("datetime0ms").setType(StandardSQLTypeName.DATETIME.toString());
    private static final TableFieldSchema DATETIME_0S_NS = new TableFieldSchema().setName("datetime0s_ns").setType(StandardSQLTypeName.DATETIME.toString());
    private static final TableFieldSchema DATETIME_0S_0NS = new TableFieldSchema().setName("datetime0s_0ns").setType(StandardSQLTypeName.DATETIME.toString());
    private static final TableFieldSchema DATE = new TableFieldSchema().setName("date").setType(StandardSQLTypeName.DATE.toString());
    private static final TableFieldSchema TIME = new TableFieldSchema().setName("time").setType(StandardSQLTypeName.TIME.toString());
    private static final TableFieldSchema TIME_0MS = new TableFieldSchema().setName("time0ms").setType(StandardSQLTypeName.TIME.toString());
    private static final TableFieldSchema TIME_0S_NS = new TableFieldSchema().setName("time0s_ns").setType(StandardSQLTypeName.TIME.toString());
    private static final TableFieldSchema TIME_0S_0NS = new TableFieldSchema().setName("time0s_0ns").setType(StandardSQLTypeName.TIME.toString());
    private static final TableFieldSchema VALID = new TableFieldSchema().setName("valid").setType(StandardSQLTypeName.BOOL.toString());
    private static final TableFieldSchema BINARY = new TableFieldSchema().setName("binary").setType(StandardSQLTypeName.BYTES.toString());
    private static final TableFieldSchema NUMERIC = new TableFieldSchema().setName("numeric").setType(StandardSQLTypeName.NUMERIC.toString());
    private static final TableFieldSchema BOOLEAN = new TableFieldSchema().setName("boolean").setType(StandardSQLTypeName.BOOL.toString());
    private static final TableFieldSchema LONG = new TableFieldSchema().setName("long").setType(StandardSQLTypeName.INT64.toString());
    private static final TableFieldSchema DOUBLE = new TableFieldSchema().setName("double").setType(StandardSQLTypeName.FLOAT64.toString());
    private static final TableFieldSchema COLOR = new TableFieldSchema().setName("color").setType(StandardSQLTypeName.STRING.toString());
    private static final TableFieldSchema IDS = new TableFieldSchema().setName("ids").setType(StandardSQLTypeName.INT64.toString()).setMode(Mode.REPEATED.toString());
    private static final TableFieldSchema MAP_KEY = new TableFieldSchema().setName("key").setType(StandardSQLTypeName.STRING.toString()).setMode(Mode.REQUIRED.toString());
    private static final TableFieldSchema MAP_VALUE = new TableFieldSchema().setName("value").setType(StandardSQLTypeName.FLOAT64.toString()).setMode(Mode.REQUIRED.toString());
    private static final TableFieldSchema ROW = new TableFieldSchema().setName("row").setType(StandardSQLTypeName.STRUCT.toString()).setMode(Mode.NULLABLE.toString()).setFields(Arrays.asList(ID, VALUE, NAME, TIMESTAMP_VARIANT1, TIMESTAMP_VARIANT2, TIMESTAMP_VARIANT3, TIMESTAMP_VARIANT4, DATETIME, DATETIME_0MS, DATETIME_0S_NS, DATETIME_0S_0NS, DATE, TIME, TIME_0MS, TIME_0S_NS, TIME_0S_0NS, VALID, BINARY, NUMERIC, BOOLEAN, LONG, DOUBLE));
    private static final TableFieldSchema ROWS = new TableFieldSchema().setName("rows").setType(StandardSQLTypeName.STRUCT.toString()).setMode(Mode.REPEATED.toString()).setFields(Arrays.asList(ID, VALUE, NAME, TIMESTAMP_VARIANT1, TIMESTAMP_VARIANT2, TIMESTAMP_VARIANT3, TIMESTAMP_VARIANT4, DATETIME, DATETIME_0MS, DATETIME_0S_NS, DATETIME_0S_0NS, DATE, TIME, TIME_0MS, TIME_0S_NS, TIME_0S_0NS, VALID, BINARY, NUMERIC, BOOLEAN, LONG, DOUBLE));
    private static final TableFieldSchema MAP = new TableFieldSchema().setName("map").setType(StandardSQLTypeName.STRUCT.toString()).setMode(Mode.REPEATED.toString()).setFields(Arrays.asList(MAP_KEY, MAP_VALUE));
    private static final Row FLAT_ROW = Row.withSchema((Schema)FLAT_TYPE).addValues(new Object[]{123L, 123.456, "test", ISODateTimeFormat.dateHourMinuteSecondFraction().withZoneUTC().parseDateTime("2019-08-16T13:52:07.000"), ISODateTimeFormat.dateHourMinuteSecondFraction().withZoneUTC().parseDateTime("2019-08-17T14:52:07.123"), ISODateTimeFormat.dateHourMinuteSecondFraction().withZoneUTC().parseDateTime("2019-08-18T15:52:07.123"), new DateTime(123456L), LocalDateTime.parse("2020-11-02T12:34:56.789876"), LocalDateTime.parse("2020-11-02T12:34:56"), LocalDateTime.parse("2020-11-02T12:34:00.789876"), LocalDateTime.parse("2020-11-02T12:34"), LocalDate.parse("2020-11-02"), LocalTime.parse("12:34:56.789876"), LocalTime.parse("12:34:56"), LocalTime.parse("12:34:00.789876"), LocalTime.parse("12:34"), false, Base64.getDecoder().decode("ABCD1234"), new BigDecimal("123.456").setScale(3, RoundingMode.HALF_UP), true, 123L, 123.456}).build();
    private static final TableRow BQ_FLAT_ROW = new TableRow().set("id", (Object)"123").set("value", (Object)"123.456").set("name", (Object)"test").set("timestamp_variant1", (Object)"2019-08-16 13:52:07 UTC").set("timestamp_variant2", (Object)"2019-08-17 14:52:07.123 UTC").set("timestamp_variant3", (Object)"2019-08-18 15:52:07.123456 UTC").set("timestamp_variant4", (Object)String.valueOf((double)new DateTime(123456L, (Chronology)ISOChronology.getInstanceUTC()).getMillis() / 1000.0)).set("datetime", (Object)"2020-11-02T12:34:56.789876").set("datetime0ms", (Object)"2020-11-02T12:34:56").set("datetime0s_ns", (Object)"2020-11-02T12:34:00.789876").set("datetime0s_0ns", (Object)"2020-11-02T12:34:00").set("date", (Object)"2020-11-02").set("time", (Object)"12:34:56.789876").set("time0ms", (Object)"12:34:56").set("time0s_ns", (Object)"12:34:00.789876").set("time0s_0ns", (Object)"12:34:00").set("valid", (Object)"false").set("binary", (Object)"ABCD1234").set("numeric", (Object)"123.456").set("boolean", (Object)true).set("long", (Object)123L).set("double", (Object)123.456);
    private static final Row NULL_FLAT_ROW = Row.withSchema((Schema)FLAT_TYPE).addValues(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}).build();
    private static final TableRow BQ_NULL_FLAT_ROW = new TableRow().set("id", null).set("value", null).set("name", null).set("timestamp_variant1", null).set("timestamp_variant2", null).set("timestamp_variant3", null).set("timestamp_variant4", null).set("datetime", null).set("datetime0ms", null).set("datetime0s_ns", null).set("datetime0s_0ns", null).set("date", null).set("time", null).set("time0ms", null).set("time0s_ns", null).set("time0s_0ns", null).set("valid", null).set("binary", null).set("numeric", null).set("boolean", null).set("long", null).set("double", null);
    private static final Row ENUM_ROW = Row.withSchema((Schema)ENUM_TYPE).addValues(new Object[]{new EnumerationType.Value(1)}).build();
    private static final Row ENUM_STRING_ROW = Row.withSchema((Schema)ENUM_STRING_TYPE).addValues(new Object[]{"GREEN"}).build();
    private static final TableRow BQ_ENUM_ROW = new TableRow().set("color", (Object)"GREEN");
    private static final Row ARRAY_ROW = Row.withSchema((Schema)ARRAY_TYPE).addValues(new Object[]{Arrays.asList(123L, 124L)}).build();
    private static final Row MAP_ROW = Row.withSchema((Schema)MAP_MAP_TYPE).addValues(new Object[]{ImmutableMap.of((Object)"test", (Object)123.456)}).build();
    private static final TableRow BQ_ARRAY_ROW = new TableRow().set("ids", Arrays.asList(Collections.singletonMap("v", "123"), Collections.singletonMap("v", "124")));
    private static final Row ROW_ROW = Row.withSchema((Schema)ROW_TYPE).addValues(new Object[]{FLAT_ROW}).build();
    private static final TableRow BQ_ROW_ROW = new TableRow().set("row", (Object)BQ_FLAT_ROW);
    private static final Row ARRAY_ROW_ROW = Row.withSchema((Schema)ARRAY_ROW_TYPE).addValues(new Object[]{Arrays.asList(FLAT_ROW)}).build();
    private static final TableRow BQ_ARRAY_ROW_ROW = new TableRow().set("rows", Collections.singletonList(Collections.singletonMap("v", BQ_FLAT_ROW)));
    private static final TableSchema BQ_FLAT_TYPE = new TableSchema().setFields(Arrays.asList(ID, VALUE, NAME, TIMESTAMP_VARIANT1, TIMESTAMP_VARIANT2, TIMESTAMP_VARIANT3, TIMESTAMP_VARIANT4, DATETIME, DATETIME_0MS, DATETIME_0S_NS, DATETIME_0S_0NS, DATE, TIME, TIME_0MS, TIME_0S_NS, TIME_0S_0NS, VALID, BINARY, NUMERIC, BOOLEAN, LONG, DOUBLE));
    private static final TableSchema BQ_ENUM_TYPE = new TableSchema().setFields(Arrays.asList(COLOR));
    private static final TableSchema BQ_ARRAY_TYPE = new TableSchema().setFields(Arrays.asList(IDS));
    private static final TableSchema BQ_ROW_TYPE = new TableSchema().setFields(Arrays.asList(ROW));
    private static final TableSchema BQ_ARRAY_ROW_TYPE = new TableSchema().setFields(Arrays.asList(ROWS));
    private static final TableSchema BQ_MAP_TYPE = new TableSchema().setFields(Arrays.asList(MAP));
    private static final Schema AVRO_FLAT_TYPE = Schema.builder().addNullableField("id", Schema.FieldType.INT64).addNullableField("value", Schema.FieldType.DOUBLE).addNullableField("name", Schema.FieldType.STRING).addNullableField("valid", Schema.FieldType.BOOLEAN).build();
    private static final Schema AVRO_ARRAY_TYPE = Schema.builder().addArrayField("rows", Schema.FieldType.row((Schema)AVRO_FLAT_TYPE)).build();
    private static final Schema AVRO_ARRAY_ARRAY_TYPE = Schema.builder().addArrayField("array_rows", Schema.FieldType.row((Schema)AVRO_ARRAY_TYPE)).build();
    private static final BigQueryUtils.ConversionOptions TRUNCATE_OPTIONS = BigQueryUtils.ConversionOptions.builder().setTruncateTimestamps(BigQueryUtils.ConversionOptions.TruncateTimestamps.TRUNCATE).build();
    private static final BigQueryUtils.ConversionOptions REJECT_OPTIONS = BigQueryUtils.ConversionOptions.builder().setTruncateTimestamps(BigQueryUtils.ConversionOptions.TruncateTimestamps.REJECT).build();
    private static final BigQueryUtils.SchemaConversionOptions INFER_MAPS_OPTIONS = BigQueryUtils.SchemaConversionOptions.builder().setInferMaps(true).build();

    @Test
    public void testToTableSchema_flat() {
        TableSchema schema = BigQueryUtils.toTableSchema((Schema)FLAT_TYPE);
        MatcherAssert.assertThat((Object)schema.getFields(), (Matcher)Matchers.containsInAnyOrder((Object[])new TableFieldSchema[]{ID, VALUE, NAME, TIMESTAMP_VARIANT1, TIMESTAMP_VARIANT2, TIMESTAMP_VARIANT3, TIMESTAMP_VARIANT4, DATETIME, DATETIME_0MS, DATETIME_0S_NS, DATETIME_0S_0NS, DATE, TIME, TIME_0MS, TIME_0S_NS, TIME_0S_0NS, VALID, BINARY, NUMERIC, BOOLEAN, LONG, DOUBLE}));
    }

    @Test
    public void testToTableSchema_enum() {
        TableSchema schema = BigQueryUtils.toTableSchema((Schema)ENUM_TYPE);
        MatcherAssert.assertThat((Object)schema.getFields(), (Matcher)Matchers.containsInAnyOrder((Object[])new TableFieldSchema[]{COLOR}));
    }

    @Test
    public void testToTableSchema_array() {
        TableSchema schema = BigQueryUtils.toTableSchema((Schema)ARRAY_TYPE);
        MatcherAssert.assertThat((Object)schema.getFields(), (Matcher)Matchers.contains((Object[])new TableFieldSchema[]{IDS}));
    }

    @Test
    public void testToTableSchema_row() {
        TableSchema schema = BigQueryUtils.toTableSchema((Schema)ROW_TYPE);
        MatcherAssert.assertThat((Object)schema.getFields().size(), (Matcher)Matchers.equalTo((Object)1));
        TableFieldSchema field = (TableFieldSchema)schema.getFields().get(0);
        MatcherAssert.assertThat((Object)field.getName(), (Matcher)Matchers.equalTo((Object)"row"));
        MatcherAssert.assertThat((Object)field.getType(), (Matcher)Matchers.equalTo((Object)StandardSQLTypeName.STRUCT.toString()));
        MatcherAssert.assertThat((Object)field.getMode(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)field.getFields(), (Matcher)Matchers.containsInAnyOrder((Object[])new TableFieldSchema[]{ID, VALUE, NAME, TIMESTAMP_VARIANT1, TIMESTAMP_VARIANT2, TIMESTAMP_VARIANT3, TIMESTAMP_VARIANT4, DATETIME, DATETIME_0MS, DATETIME_0S_NS, DATETIME_0S_0NS, DATE, TIME, TIME_0MS, TIME_0S_NS, TIME_0S_0NS, VALID, BINARY, NUMERIC, BOOLEAN, LONG, DOUBLE}));
    }

    @Test
    public void testToTableSchema_array_row() {
        TableSchema schema = BigQueryUtils.toTableSchema((Schema)ARRAY_ROW_TYPE);
        MatcherAssert.assertThat((Object)schema.getFields().size(), (Matcher)Matchers.equalTo((Object)1));
        TableFieldSchema field = (TableFieldSchema)schema.getFields().get(0);
        MatcherAssert.assertThat((Object)field.getName(), (Matcher)Matchers.equalTo((Object)"rows"));
        MatcherAssert.assertThat((Object)field.getType(), (Matcher)Matchers.equalTo((Object)StandardSQLTypeName.STRUCT.toString()));
        MatcherAssert.assertThat((Object)field.getMode(), (Matcher)Matchers.equalTo((Object)Mode.REPEATED.toString()));
        MatcherAssert.assertThat((Object)field.getFields(), (Matcher)Matchers.containsInAnyOrder((Object[])new TableFieldSchema[]{ID, VALUE, NAME, TIMESTAMP_VARIANT1, TIMESTAMP_VARIANT2, TIMESTAMP_VARIANT3, TIMESTAMP_VARIANT4, DATETIME, DATETIME_0MS, DATETIME_0S_NS, DATETIME_0S_0NS, DATE, TIME, TIME_0MS, TIME_0S_NS, TIME_0S_0NS, VALID, BINARY, NUMERIC, BOOLEAN, LONG, DOUBLE}));
    }

    @Test
    public void testToTableSchema_map() {
        TableSchema schema = BigQueryUtils.toTableSchema((Schema)MAP_MAP_TYPE);
        MatcherAssert.assertThat((Object)schema.getFields().size(), (Matcher)Matchers.equalTo((Object)1));
        TableFieldSchema field = (TableFieldSchema)schema.getFields().get(0);
        MatcherAssert.assertThat((Object)field.getName(), (Matcher)Matchers.equalTo((Object)"map"));
        MatcherAssert.assertThat((Object)field.getType(), (Matcher)Matchers.equalTo((Object)StandardSQLTypeName.STRUCT.toString()));
        MatcherAssert.assertThat((Object)field.getMode(), (Matcher)Matchers.equalTo((Object)Mode.REPEATED.toString()));
        MatcherAssert.assertThat((Object)field.getFields(), (Matcher)Matchers.containsInAnyOrder((Object[])new TableFieldSchema[]{MAP_KEY, MAP_VALUE}));
    }

    @Test
    public void testToTableRow_flat() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)FLAT_ROW);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)22));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"id", (Object)"123"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"value", (Object)"123.456"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime", (Object)"2020-11-02T12:34:56.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0ms", (Object)"2020-11-02T12:34:56"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0s_ns", (Object)"2020-11-02T12:34:00.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0s_0ns", (Object)"2020-11-02T12:34:00"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"date", (Object)"2020-11-02"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time", (Object)"12:34:56.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0ms", (Object)"12:34:56"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0s_ns", (Object)"12:34:00.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0s_0ns", (Object)"12:34:00"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"name", (Object)"test"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"valid", (Object)"false"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"binary", (Object)"ABCD1234"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"numeric", (Object)"123.456"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"boolean", (Object)"true"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"long", (Object)"123"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"double", (Object)"123.456"));
    }

    @Test
    public void testToTableRow_enum() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)ENUM_ROW);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"color", (Object)"GREEN"));
    }

    @Test
    public void testToTableRow_array() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)ARRAY_ROW);
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"ids", Arrays.asList("123", "124")));
        MatcherAssert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testToTableRow_map() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)MAP_ROW);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)1));
        row = (TableRow)((List)row.get((Object)"map")).get(0);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"key", (Object)"test"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"value", (Object)"123.456"));
    }

    @Test
    public void testToTableRow_row() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)ROW_ROW);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)1));
        row = (TableRow)row.get((Object)"row");
        MatcherAssert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)22));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"id", (Object)"123"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"value", (Object)"123.456"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime", (Object)"2020-11-02T12:34:56.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0ms", (Object)"2020-11-02T12:34:56"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0s_ns", (Object)"2020-11-02T12:34:00.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0s_0ns", (Object)"2020-11-02T12:34:00"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"date", (Object)"2020-11-02"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time", (Object)"12:34:56.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0ms", (Object)"12:34:56"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0s_ns", (Object)"12:34:00.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0s_0ns", (Object)"12:34:00"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"name", (Object)"test"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"valid", (Object)"false"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"binary", (Object)"ABCD1234"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"numeric", (Object)"123.456"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"boolean", (Object)"true"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"long", (Object)"123"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"double", (Object)"123.456"));
    }

    @Test
    public void testToTableRow_array_row() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)ARRAY_ROW_ROW);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)1));
        row = (TableRow)((List)row.get((Object)"rows")).get(0);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)22));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"id", (Object)"123"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"value", (Object)"123.456"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime", (Object)"2020-11-02T12:34:56.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0ms", (Object)"2020-11-02T12:34:56"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0s_ns", (Object)"2020-11-02T12:34:00.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0s_0ns", (Object)"2020-11-02T12:34:00"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"date", (Object)"2020-11-02"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time", (Object)"12:34:56.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0ms", (Object)"12:34:56"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0s_ns", (Object)"12:34:00.789876"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0s_0ns", (Object)"12:34:00"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"name", (Object)"test"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"valid", (Object)"false"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"binary", (Object)"ABCD1234"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"numeric", (Object)"123.456"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"boolean", (Object)"true"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"long", (Object)"123"));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"double", (Object)"123.456"));
    }

    @Test
    public void testToTableRow_null_row() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)NULL_FLAT_ROW);
        MatcherAssert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)22));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"id", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"value", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"name", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"timestamp_variant1", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"timestamp_variant2", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"timestamp_variant3", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"timestamp_variant4", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0ms", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0s_ns", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"datetime0s_0ns", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"date", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0ms", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0s_ns", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"time0s_0ns", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"valid", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"binary", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"numeric", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"boolean", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"long", null));
        MatcherAssert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"double", null));
    }

    @Test
    public void testSubMilliPrecisionRejected() {
        Assert.assertThrows((String)"precision", IllegalArgumentException.class, () -> BigQueryUtils.convertAvroFormat((Schema.FieldType)Schema.FieldType.DATETIME, (Object)1000000001L, (BigQueryUtils.ConversionOptions)REJECT_OPTIONS));
    }

    @Test
    public void testMilliPrecisionOk() {
        long millis = 123456789L;
        MatcherAssert.assertThat((Object)BigQueryUtils.convertAvroFormat((Schema.FieldType)Schema.FieldType.DATETIME, (Object)(millis * 1000L), (BigQueryUtils.ConversionOptions)REJECT_OPTIONS), (Matcher)Matchers.equalTo((Object)new Instant(millis)));
    }

    @Test
    public void testSubMilliPrecisionTruncated() {
        long millis = 123456789L;
        MatcherAssert.assertThat((Object)BigQueryUtils.convertAvroFormat((Schema.FieldType)Schema.FieldType.DATETIME, (Object)(millis * 1000L + 123L), (BigQueryUtils.ConversionOptions)TRUNCATE_OPTIONS), (Matcher)Matchers.equalTo((Object)new Instant(millis)));
    }

    @Test
    public void testDateType() {
        LocalDate d = LocalDate.parse("2020-06-04");
        MatcherAssert.assertThat((Object)BigQueryUtils.convertAvroFormat((Schema.FieldType)Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATE), (Object)((int)d.toEpochDay()), (BigQueryUtils.ConversionOptions)REJECT_OPTIONS), (Matcher)Matchers.equalTo((Object)d));
    }

    @Test
    public void testMicroPrecisionTimeType() {
        LocalTime t = LocalTime.parse("12:34:56.789876");
        MatcherAssert.assertThat((Object)BigQueryUtils.convertAvroFormat((Schema.FieldType)Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME), (Object)(t.toNanoOfDay() / 1000L), (BigQueryUtils.ConversionOptions)REJECT_OPTIONS), (Matcher)Matchers.equalTo((Object)t));
    }

    @Test
    public void testMicroPrecisionDateTimeType() {
        LocalDateTime dt = LocalDateTime.parse("2020-06-04T12:34:56.789876");
        MatcherAssert.assertThat((Object)BigQueryUtils.convertAvroFormat((Schema.FieldType)Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME), (Object)new Utf8(dt.toString()), (BigQueryUtils.ConversionOptions)REJECT_OPTIONS), (Matcher)Matchers.equalTo((Object)dt));
    }

    @Test
    public void testNumericType() {
        BigDecimal n = new BigDecimal("123456789.987654321").setScale(9);
        MatcherAssert.assertThat((Object)BigQueryUtils.convertAvroFormat((Schema.FieldType)Schema.FieldType.DECIMAL, (Object)new Conversions.DecimalConversion().toBytes(n, null, (LogicalType)LogicalTypes.decimal((int)38, (int)9)), (BigQueryUtils.ConversionOptions)REJECT_OPTIONS), (Matcher)Matchers.equalTo((Object)n));
    }

    @Test
    public void testBytesType() {
        byte[] bytes = "hello".getBytes(StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)BigQueryUtils.convertAvroFormat((Schema.FieldType)Schema.FieldType.BYTES, (Object)ByteBuffer.wrap(bytes), (BigQueryUtils.ConversionOptions)REJECT_OPTIONS), (Matcher)Matchers.equalTo((Object)bytes));
    }

    @Test
    public void testFromTableSchema_flat() {
        Schema beamSchema = BigQueryUtils.fromTableSchema((TableSchema)BQ_FLAT_TYPE);
        Assert.assertEquals((Object)FLAT_TYPE, (Object)beamSchema);
    }

    @Test
    public void testFromTableSchema_enum() {
        Schema beamSchema = BigQueryUtils.fromTableSchema((TableSchema)BQ_ENUM_TYPE);
        Assert.assertEquals((Object)ENUM_STRING_TYPE, (Object)beamSchema);
    }

    @Test
    public void testFromTableSchema_array() {
        Schema beamSchema = BigQueryUtils.fromTableSchema((TableSchema)BQ_ARRAY_TYPE);
        Assert.assertEquals((Object)ARRAY_TYPE, (Object)beamSchema);
    }

    @Test
    public void testFromTableSchema_row() {
        Schema beamSchema = BigQueryUtils.fromTableSchema((TableSchema)BQ_ROW_TYPE);
        Assert.assertEquals((Object)ROW_TYPE, (Object)beamSchema);
    }

    @Test
    public void testFromTableSchema_array_row() {
        Schema beamSchema = BigQueryUtils.fromTableSchema((TableSchema)BQ_ARRAY_ROW_TYPE);
        Assert.assertEquals((Object)ARRAY_ROW_TYPE, (Object)beamSchema);
    }

    @Test
    public void testFromTableSchema_map_array() {
        Schema beamSchema = BigQueryUtils.fromTableSchema((TableSchema)BQ_MAP_TYPE);
        Assert.assertEquals((Object)MAP_ARRAY_TYPE, (Object)beamSchema);
    }

    @Test
    public void testFromTableSchema_map_map() {
        Schema beamSchema = BigQueryUtils.fromTableSchema((TableSchema)BQ_MAP_TYPE, (BigQueryUtils.SchemaConversionOptions)INFER_MAPS_OPTIONS);
        Assert.assertEquals((Object)MAP_MAP_TYPE, (Object)beamSchema);
    }

    @Test
    public void testToBeamRow_flat() {
        Row beamRow = BigQueryUtils.toBeamRow((Schema)FLAT_TYPE, (TableRow)BQ_FLAT_ROW);
        Assert.assertEquals((Object)FLAT_ROW, (Object)beamRow);
    }

    @Test
    public void testToBeamRow_null() {
        Row beamRow = BigQueryUtils.toBeamRow((Schema)FLAT_TYPE, (TableRow)BQ_NULL_FLAT_ROW);
        Assert.assertEquals((Object)NULL_FLAT_ROW, (Object)beamRow);
    }

    @Test
    public void testToBeamRow_enum() {
        Row beamRow = BigQueryUtils.toBeamRow((Schema)ENUM_STRING_TYPE, (TableRow)BQ_ENUM_ROW);
        Assert.assertEquals((Object)ENUM_STRING_ROW, (Object)beamRow);
    }

    @Test
    public void testToBeamRow_array() {
        Row beamRow = BigQueryUtils.toBeamRow((Schema)ARRAY_TYPE, (TableRow)BQ_ARRAY_ROW);
        Assert.assertEquals((Object)ARRAY_ROW, (Object)beamRow);
    }

    @Test
    public void testToBeamRow_row() {
        Row beamRow = BigQueryUtils.toBeamRow((Schema)ROW_TYPE, (TableRow)BQ_ROW_ROW);
        Assert.assertEquals((Object)ROW_ROW, (Object)beamRow);
    }

    @Test
    public void testToBeamRow_array_row() {
        Row beamRow = BigQueryUtils.toBeamRow((Schema)ARRAY_ROW_TYPE, (TableRow)BQ_ARRAY_ROW_ROW);
        Assert.assertEquals((Object)ARRAY_ROW_ROW, (Object)beamRow);
    }

    @Test
    public void testToBeamRow_avro_array_row() {
        Row flatRowExpected = Row.withSchema((Schema)AVRO_FLAT_TYPE).addValues(new Object[]{123L, 123.456, "test", false}).build();
        Row expected = Row.withSchema((Schema)AVRO_ARRAY_TYPE).addValues(new Object[]{Arrays.asList(flatRowExpected)}).build();
        GenericData.Record record = new GenericData.Record(AvroUtils.toAvroSchema((Schema)AVRO_ARRAY_TYPE));
        GenericData.Record flat = new GenericData.Record(AvroUtils.toAvroSchema((Schema)AVRO_FLAT_TYPE));
        flat.put("id", (Object)123L);
        flat.put("value", (Object)123.456);
        flat.put("name", (Object)"test");
        flat.put("valid", (Object)false);
        record.put("rows", Arrays.asList(flat));
        Row beamRow = BigQueryUtils.toBeamRow((GenericRecord)record, (Schema)AVRO_ARRAY_TYPE, (BigQueryUtils.ConversionOptions)BigQueryUtils.ConversionOptions.builder().build());
        Assert.assertEquals((Object)expected, (Object)beamRow);
    }

    @Test
    public void testToBeamRow_avro_array_array_row() {
        Row flatRowExpected = Row.withSchema((Schema)AVRO_FLAT_TYPE).addValues(new Object[]{123L, 123.456, "test", false}).build();
        Row arrayRowExpected = Row.withSchema((Schema)AVRO_ARRAY_TYPE).addValues(new Object[]{Arrays.asList(flatRowExpected)}).build();
        Row expected = Row.withSchema((Schema)AVRO_ARRAY_ARRAY_TYPE).addValues(new Object[]{Arrays.asList(arrayRowExpected)}).build();
        GenericData.Record arrayRecord = new GenericData.Record(AvroUtils.toAvroSchema((Schema)AVRO_ARRAY_TYPE));
        GenericData.Record flat = new GenericData.Record(AvroUtils.toAvroSchema((Schema)AVRO_FLAT_TYPE));
        GenericData.Record record = new GenericData.Record(AvroUtils.toAvroSchema((Schema)AVRO_ARRAY_ARRAY_TYPE));
        flat.put("id", (Object)123L);
        flat.put("value", (Object)123.456);
        flat.put("name", (Object)"test");
        flat.put("valid", (Object)false);
        arrayRecord.put("rows", Arrays.asList(flat));
        record.put("array_rows", Arrays.asList(arrayRecord));
        Row beamRow = BigQueryUtils.toBeamRow((GenericRecord)record, (Schema)AVRO_ARRAY_ARRAY_TYPE, (BigQueryUtils.ConversionOptions)BigQueryUtils.ConversionOptions.builder().build());
        Assert.assertEquals((Object)expected, (Object)beamRow);
    }

    @Test
    public void testToTableReference() {
        TableReference tr = BigQueryUtils.toTableReference((String)"projects/myproject/datasets/mydataset/tables/mytable");
        Assert.assertEquals((Object)"myproject", (Object)tr.getProjectId());
        Assert.assertEquals((Object)"mydataset", (Object)tr.getDatasetId());
        Assert.assertEquals((Object)"mytable", (Object)tr.getTableId());
        tr = BigQueryUtils.toTableReference((String)"myprojectwithcolon:mydataset.mytable");
        Assert.assertEquals((Object)"myprojectwithcolon", (Object)tr.getProjectId());
        Assert.assertEquals((Object)"mydataset", (Object)tr.getDatasetId());
        Assert.assertEquals((Object)"mytable", (Object)tr.getTableId());
        tr = BigQueryUtils.toTableReference((String)"myprojectwithdot.mydataset.mytable");
        Assert.assertEquals((Object)"myprojectwithdot", (Object)tr.getProjectId());
        Assert.assertEquals((Object)"mydataset", (Object)tr.getDatasetId());
        Assert.assertEquals((Object)"mytable", (Object)tr.getTableId());
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)""));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)":."));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)".."));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"myproject"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"myproject:"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"myproject."));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"myproject:mydataset"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"myproject:mydataset."));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"myproject:mydataset.mytable."));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"myproject:mydataset:mytable:"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)".invalidleadingdot.mydataset.mytable"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"invalidtrailingdot.mydataset.mytable."));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)":invalidleadingcolon.mydataset.mytable"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"invalidtrailingcolon.mydataset.mytable:"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"myproject.mydataset.mytable.myinvalidpart"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"myproject:mydataset.mytable.myinvalidpart"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"/projects/extraslash/datasets/mydataset/tables/mytable"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects//extraslash/datasets/mydataset/tables/mytable"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/extraslash//datasets/mydataset/tables/mytable"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/extraslash/datasets//mydataset/tables/mytable"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/extraslash/datasets/mydataset//tables/mytable"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/extraslash/datasets/mydataset/tables//mytable"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/extraslash/datasets/mydataset/tables/mytable/"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject/datasets/mydataset/tables//"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject/datasets//tables/mytable/"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects//datasets/mydataset/tables/mytable/"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects//datasets//tables//"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject/datasets/mydataset/tables/mytable/"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject/datasets/mydataset/tables/"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject/datasets/mydataset/tables"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject/datasets/mydataset/"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject/datasets/mydataset"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject/datasets/"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject/datasets"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject/"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/myproject"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects/"));
        Assert.assertNull((Object)BigQueryUtils.toTableReference((String)"projects"));
    }
}

