/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.FailsafeValueInSingleWindow;
import org.joda.time.Instant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigQueryUtilTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    private Bigquery mockClient;
    @Mock
    private Bigquery.Tables mockTables;
    @Mock
    private Bigquery.Tables.Get mockTablesGet;
    @Mock
    private Bigquery.Tabledata mockTabledata;
    @Mock
    private Bigquery.Tabledata.List mockTabledataList;
    private PipelineOptions options;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.options = PipelineOptionsFactory.create();
    }

    @After
    public void tearDown() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClient});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockTables});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockTablesGet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockTabledata});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockTabledataList});
    }

    private void onInsertAll(List<List<Long>> errorIndicesSequence) throws Exception {
        Mockito.when((Object)this.mockClient.tabledata()).thenReturn((Object)this.mockTabledata);
        ArrayList<TableDataInsertAllResponse> responses = new ArrayList<TableDataInsertAllResponse>();
        for (List<Long> errorIndices : errorIndicesSequence) {
            ArrayList errors = new ArrayList();
            for (long i : errorIndices) {
                TableDataInsertAllResponse.InsertErrors error = new TableDataInsertAllResponse.InsertErrors();
                error.setIndex(Long.valueOf(i));
            }
            TableDataInsertAllResponse response = new TableDataInsertAllResponse();
            response.setInsertErrors(errors);
            responses.add(response);
        }
        Bigquery.Tabledata.InsertAll mockInsertAll = (Bigquery.Tabledata.InsertAll)Mockito.mock(Bigquery.Tabledata.InsertAll.class);
        Mockito.when((Object)this.mockTabledata.insertAll(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (TableDataInsertAllRequest)Matchers.any(TableDataInsertAllRequest.class))).thenReturn((Object)mockInsertAll);
        Mockito.when((Object)mockInsertAll.setPrettyPrint((Boolean)Matchers.any())).thenReturn((Object)mockInsertAll);
        Mockito.when((Object)((TableDataInsertAllResponse)mockInsertAll.execute())).thenReturn((Object)((TableDataInsertAllResponse)responses.get(0)), (Object[])responses.subList(1, responses.size()).toArray(new TableDataInsertAllResponse[responses.size() - 1]));
    }

    private void verifyInsertAll(int expectedRetries) throws IOException {
        ((Bigquery)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)expectedRetries))).tabledata();
        ((Bigquery.Tabledata)Mockito.verify((Object)this.mockTabledata, (VerificationMode)Mockito.times((int)expectedRetries))).insertAll(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (TableDataInsertAllRequest)Matchers.any(TableDataInsertAllRequest.class));
    }

    private void onTableGet(Table table) throws IOException {
        Mockito.when((Object)this.mockClient.tables()).thenReturn((Object)this.mockTables);
        Mockito.when((Object)this.mockTables.get(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockTablesGet);
        Mockito.when((Object)this.mockTablesGet.setPrettyPrint(Boolean.valueOf(false))).thenReturn((Object)this.mockTablesGet);
        Mockito.when((Object)((Table)this.mockTablesGet.execute())).thenReturn((Object)table);
    }

    private void verifyTableGet() throws IOException {
        ((Bigquery)Mockito.verify((Object)this.mockClient)).tables();
        ((Bigquery.Tables)Mockito.verify((Object)this.mockTables)).get("project", "dataset", "table");
        ((Bigquery.Tables.Get)Mockito.verify((Object)this.mockTablesGet, (VerificationMode)Mockito.atLeastOnce())).setPrettyPrint(Boolean.valueOf(false));
        ((Bigquery.Tables.Get)Mockito.verify((Object)this.mockTablesGet, (VerificationMode)Mockito.atLeastOnce())).execute();
    }

    private void onTableList(TableDataList result) throws IOException {
        Mockito.when((Object)this.mockClient.tabledata()).thenReturn((Object)this.mockTabledata);
        Mockito.when((Object)this.mockTabledata.list(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockTabledataList);
        Mockito.when((Object)this.mockTabledataList.setPrettyPrint(Boolean.valueOf(false))).thenReturn((Object)this.mockTabledataList);
        Mockito.when((Object)((TableDataList)this.mockTabledataList.execute())).thenReturn((Object)result);
    }

    private Table basicTableSchema() {
        return new Table().setSchema(new TableSchema().setFields(Arrays.asList(new TableFieldSchema().setName("name").setType("STRING"), new TableFieldSchema().setName("answer").setType("INTEGER"))));
    }

    private TableRow rawRow(Object ... args) {
        ArrayList<TableCell> cells = new ArrayList<TableCell>();
        for (Object a : args) {
            cells.add(new TableCell().setV(a));
        }
        return new TableRow().setF(cells);
    }

    @Test
    public void testTableGet() throws InterruptedException, IOException {
        this.onTableGet(this.basicTableSchema());
        TableDataList dataList = new TableDataList().setTotalRows(Long.valueOf(0L));
        this.onTableList(dataList);
        BigQueryServicesImpl.DatasetServiceImpl services = new BigQueryServicesImpl.DatasetServiceImpl(this.mockClient, null, this.options);
        services.getTable(new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table"));
        this.verifyTableGet();
    }

    @Test
    public void testInsertAll() throws Exception {
        ArrayList<List<Long>> errorsIndices = new ArrayList<List<Long>>();
        errorsIndices.add(Arrays.asList(0L, 5L, 10L, 15L, 20L));
        errorsIndices.add(Arrays.asList(0L, 2L, 4L));
        errorsIndices.add(Arrays.asList(0L, 2L));
        errorsIndices.add(new ArrayList());
        this.onInsertAll(errorsIndices);
        TableReference ref = BigQueryHelpers.parseTableSpec((String)"project:dataset.table");
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.mockClient, null, this.options, 5L);
        ArrayList<FailsafeValueInSingleWindow> rows = new ArrayList<FailsafeValueInSingleWindow>();
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < 25; ++i) {
            rows.add(FailsafeValueInSingleWindow.of((Object)this.rawRow("foo", 1234), (Instant)GlobalWindow.TIMESTAMP_MAX_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING, (Object)this.rawRow("foo", 1234)));
            ids.add("");
        }
        long totalBytes = datasetService.insertAll(ref, rows, ids, InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null);
        this.verifyInsertAll(5);
        Assert.assertEquals((String)"Incorrect byte count", (long)775L, (long)totalBytes);
    }
}

