/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV3;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryTimePartitioningClusteringIT {
    private static final String WEATHER_SAMPLES_TABLE = "clouddataflow-readonly:samples.weather_stations";
    private static final String DATASET_NAME = "BigQueryTimePartitioningIT";
    private static final TimePartitioning TIME_PARTITIONING = new TimePartitioning().setField("date").setType("DAY");
    private static final Clustering CLUSTERING = new Clustering().setFields(Arrays.asList("station_number"));
    private static final TableSchema SCHEMA = new TableSchema().setFields(Arrays.asList(new TableFieldSchema().setName("station_number").setType("INTEGER"), new TableFieldSchema().setName("date").setType("DATE")));
    private Bigquery bqClient;
    private BigQueryClusteringITOptions options;

    @Before
    public void setUp() {
        PipelineOptionsFactory.register(BigQueryClusteringITOptions.class);
        this.options = (BigQueryClusteringITOptions)TestPipeline.testingPipelineOptions().as(BigQueryClusteringITOptions.class);
        this.options.setTempLocation(this.options.getTempRoot() + "/temp-it/");
        this.bqClient = BigqueryClient.getNewBigqueryClient((String)this.options.getAppName());
    }

    @Test
    public void testE2EBigQueryTimePartitioning() throws Exception {
        String tableName = "weather_stations_time_partitioned_" + System.currentTimeMillis();
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        ((PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(this.options.getBqcInput()))).apply((PTransform)ParDo.of((DoFn)new KeepStationNumberAndConvertDate()))).apply((PTransform)BigQueryIO.writeTableRows().to(String.format("%s.%s", DATASET_NAME, tableName)).withTimePartitioning(TIME_PARTITIONING).withSchema(SCHEMA).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        p.run().waitUntilFinish();
        this.bqClient = BigqueryClient.getNewBigqueryClient((String)this.options.getAppName());
        Table table = (Table)this.bqClient.tables().get(this.options.getProject(), DATASET_NAME, tableName).execute();
        Assert.assertEquals((Object)table.getTimePartitioning(), (Object)TIME_PARTITIONING);
    }

    @Test
    public void testE2EBigQueryClustering() throws Exception {
        String tableName = "weather_stations_clustered_" + System.currentTimeMillis();
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        ((PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(this.options.getBqcInput()))).apply((PTransform)ParDo.of((DoFn)new KeepStationNumberAndConvertDate()))).apply((PTransform)BigQueryIO.writeTableRows().to(String.format("%s.%s", DATASET_NAME, tableName)).withTimePartitioning(TIME_PARTITIONING).withClustering(CLUSTERING).withSchema(SCHEMA).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        p.run().waitUntilFinish();
        Table table = (Table)this.bqClient.tables().get(this.options.getProject(), DATASET_NAME, tableName).execute();
        Assert.assertEquals((Object)table.getClustering(), (Object)CLUSTERING);
    }

    @Test
    public void testE2EBigQueryClusteringTableFunction() throws Exception {
        String tableName = "weather_stations_clustered_table_function_" + System.currentTimeMillis();
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        ((PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(this.options.getBqcInput()))).apply((PTransform)ParDo.of((DoFn)new KeepStationNumberAndConvertDate()))).apply((PTransform)BigQueryIO.writeTableRows().to((SerializableFunction & Serializable)vsw -> new TableDestination(String.format("%s.%s", DATASET_NAME, tableName), null, TIME_PARTITIONING, CLUSTERING)).withClustering().withSchema(SCHEMA).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        p.run().waitUntilFinish();
        Table table = (Table)this.bqClient.tables().get(this.options.getProject(), DATASET_NAME, tableName).execute();
        Assert.assertEquals((Object)table.getClustering(), (Object)CLUSTERING);
    }

    @Test
    public void testE2EBigQueryClusteringDynamicDestinations() throws Exception {
        String tableName = "weather_stations_clustered_dynamic_destinations_" + System.currentTimeMillis();
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        ((PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(this.options.getBqcInput()))).apply((PTransform)ParDo.of((DoFn)new KeepStationNumberAndConvertDate()))).apply((PTransform)BigQueryIO.writeTableRows().to((DynamicDestinations)new ClusteredDestinations(tableName)).withClustering().withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        p.run().waitUntilFinish();
        Table table = (Table)this.bqClient.tables().get(this.options.getProject(), DATASET_NAME, tableName).execute();
        Assert.assertEquals((Object)table.getClustering(), (Object)CLUSTERING);
    }

    static class ClusteredDestinations
    extends DynamicDestinations<TableRow, TableDestination> {
        private final String tableName;

        public ClusteredDestinations(String tableName) {
            this.tableName = tableName;
        }

        public @Nullable Coder<TableDestination> getDestinationCoder() {
            return TableDestinationCoderV3.of();
        }

        public TableDestination getDestination(ValueInSingleWindow<TableRow> element) {
            return new TableDestination(String.format("%s.%s", BigQueryTimePartitioningClusteringIT.DATASET_NAME, this.tableName), null, TIME_PARTITIONING, CLUSTERING);
        }

        public TableDestination getTable(TableDestination destination) {
            return destination;
        }

        public TableSchema getSchema(TableDestination destination) {
            return SCHEMA;
        }
    }

    static class KeepStationNumberAndConvertDate
    extends DoFn<TableRow, TableRow> {
        KeepStationNumberAndConvertDate() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            String day = (String)((TableRow)c.element()).get((Object)"day");
            String month = (String)((TableRow)c.element()).get((Object)"month");
            String year = (String)((TableRow)c.element()).get((Object)"year");
            TableRow row = new TableRow();
            row.set("station_number", ((TableRow)c.element()).get((Object)"station_number"));
            row.set("date", (Object)String.format("%s-%s-%s", year, month, day));
            c.output((Object)row);
        }
    }

    public static interface BigQueryClusteringITOptions
    extends TestPipelineOptions,
    ExperimentalOptions,
    BigQueryOptions {
        @Description(value="Table to read from, specified as <project_id>:<dataset_id>.<table_id>")
        @Default.String(value="clouddataflow-readonly:samples.weather_stations")
        public String getBqcInput();

        public void setBqcInput(String var1);
    }
}

