/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import com.google.cloud.bigquery.storage.v1.AvroSchema;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.Arrays;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIOStorageReadTest;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageArrowReader;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageAvroReader;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReader;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReaderFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryStorageReaderTest {
    private static final Schema ARROW_SCHEMA = new Schema(Arrays.asList(BigQueryIOStorageReadTest.field("name", (ArrowType)new ArrowType.Utf8(), new Field[0]), BigQueryIOStorageReadTest.field("number", (ArrowType)new ArrowType.Int(64, true), new Field[0])));
    private static final ReadSession ARROW_READ_SESSION = ReadSession.newBuilder().setName("readSession").setArrowSchema(ArrowSchema.newBuilder().setSerializedSchema(BigQueryStorageReaderTest.serializeArrowSchema(ARROW_SCHEMA)).build()).build();
    private static final String AVRO_SCHEMA_STRING = "{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"RowRecord\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"number\", \"type\": \"long\"}\n ]\n}";
    private static final ReadSession AVRO_READ_SESSION = ReadSession.newBuilder().setName("readSession").setAvroSchema(AvroSchema.newBuilder().setSchema("{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"RowRecord\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"number\", \"type\": \"long\"}\n ]\n}")).build();

    @Test
    public void bigQueryStorageReaderFactory_arrowReader() throws Exception {
        BigQueryStorageReader reader = BigQueryStorageReaderFactory.getReader((ReadSession)ARROW_READ_SESSION);
        MatcherAssert.assertThat((Object)reader, (Matcher)CoreMatchers.instanceOf(BigQueryStorageArrowReader.class));
    }

    @Test
    public void bigQueryStorageReaderFactory_avroReader() throws Exception {
        BigQueryStorageReader reader = BigQueryStorageReaderFactory.getReader((ReadSession)AVRO_READ_SESSION);
        MatcherAssert.assertThat((Object)reader, (Matcher)CoreMatchers.instanceOf(BigQueryStorageAvroReader.class));
    }

    private static ByteString serializeArrowSchema(Schema arrowSchema) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try {
            MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(byteOutputStream)), (Schema)arrowSchema);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to serialize arrow schema.", ex);
        }
        return ByteString.copyFrom((byte[])byteOutputStream.toByteArray());
    }
}

