/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonErrorContainer;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.util.MockSleeper;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.RetryBoundedBackOff;
import com.google.protobuf.Duration;
import com.google.protobuf.Parser;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.extensions.gcp.util.FastNanoClockAndSleeper;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.values.FailsafeValueInSingleWindow;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigQueryServicesImplTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public ExpectedLogs expectedLogs = ExpectedLogs.none(BigQueryServicesImpl.class);
    private LowLevelHttpResponse[] responses;
    private MockLowLevelHttpRequest request;
    private Bigquery bigquery;
    private static final FluentBackoff TEST_BACKOFF = FluentBackoff.DEFAULT.withInitialBackoff(org.joda.time.Duration.millis((long)1L)).withExponent(1.0).withMaxRetries(3);

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.request = new MockLowLevelHttpRequest(){
            int index = 0;

            public LowLevelHttpResponse execute() throws IOException {
                Verify.verify((this.index < BigQueryServicesImplTest.this.responses.length ? 1 : 0) != 0, (String)"The number of HttpRequest invocation exceeded the number of prepared mock requests. Index: %d", (int)this.index);
                return BigQueryServicesImplTest.this.responses[this.index++];
            }
        };
        MockHttpTransport transport = new MockHttpTransport.Builder().setLowLevelHttpRequest(this.request).build();
        this.bigquery = new Bigquery.Builder((HttpTransport)transport, Transport.getJsonFactory(), (HttpRequestInitializer)new RetryHttpRequestInitializer()).build();
        MetricsContainerImpl container = new MetricsContainerImpl(null);
        MetricsEnvironment.setProcessWideContainer((MetricsContainer)container);
        MetricsEnvironment.setCurrentContainer((MetricsContainer)container);
    }

    private void setupMockResponses(MockSetupFunction ... mockPreparations) throws IOException {
        this.responses = new LowLevelHttpResponse[mockPreparations.length];
        for (int i = 0; i < mockPreparations.length; ++i) {
            MockSetupFunction setupFunction = mockPreparations[i];
            LowLevelHttpResponse response = (LowLevelHttpResponse)Mockito.mock(LowLevelHttpResponse.class);
            setupFunction.apply(response);
            this.responses[i] = response;
        }
    }

    private void verifyAllResponsesAreRead() throws IOException {
        Verify.verify((this.responses != null ? 1 : 0) != 0, (String)"The test setup is incorrect. Responses are not setup", (Object[])new Object[0]);
        for (LowLevelHttpResponse response : this.responses) {
            ((LowLevelHttpResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.atLeastOnce())).getStatusCode();
            ((LowLevelHttpResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).getContent();
            ((LowLevelHttpResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).getContentType();
        }
    }

    private void verifyRequestMetricWasSet(String method, String projectId, String dataset, String table, String status, long count) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("PTRANSFORM", "");
        labels.put("SERVICE", "BigQuery");
        labels.put("METHOD", method);
        labels.put("RESOURCE", GcpResourceIdentifiers.bigQueryTable((String)projectId, (String)dataset, (String)table));
        labels.put("BIGQUERY_PROJECT_ID", projectId);
        labels.put("BIGQUERY_DATASET", dataset);
        labels.put("BIGQUERY_TABLE", table);
        labels.put("STATUS", status);
        MonitoringInfoMetricName name = MonitoringInfoMetricName.named((String)MonitoringInfoConstants.Urns.API_REQUEST_COUNT, labels);
        MetricsContainerImpl container = (MetricsContainerImpl)MetricsEnvironment.getProcessWideContainer();
        Assert.assertEquals((long)count, (long)container.getCounter((MetricName)name).getCumulative());
    }

    private void verifyWriteMetricWasSet(String projectId, String dataset, String table, String status, long count) {
        this.verifyRequestMetricWasSet("BigQueryBatchWrite", projectId, dataset, table, status, count);
    }

    private void verifyReadMetricWasSet(String projectId, String dataset, String table, String status, long count) {
        this.verifyRequestMetricWasSet("BigQueryBatchRead", projectId, dataset, table, status, count);
    }

    @Test
    public void testStartLoadJobSucceeds() throws IOException, InterruptedException {
        Job testJob = new Job();
        JobReference jobRef = new JobReference();
        jobRef.setJobId("jobId");
        jobRef.setProjectId("projectId");
        testJob.setJobReference(jobRef);
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        });
        FastNanoClockAndSleeper sleeper = new FastNanoClockAndSleeper();
        BigQueryServicesImpl.JobServiceImpl.startJob((Job)testJob, (ApiErrorExtractor)new ApiErrorExtractor(), (Bigquery)this.bigquery, (Sleeper)sleeper, (BackOff)BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.backoff()));
        this.verifyAllResponsesAreRead();
        this.expectedLogs.verifyInfo(String.format("Started BigQuery job: %s", jobRef));
    }

    @Test
    public void testStartLoadJobSucceedsAlreadyExists() throws IOException, InterruptedException {
        Job testJob = new Job();
        JobReference jobRef = new JobReference();
        jobRef.setJobId("jobId");
        jobRef.setProjectId("projectId");
        testJob.setJobReference(jobRef);
        this.setupMockResponses(response -> Mockito.when((Object)response.getStatusCode()).thenReturn((Object)409));
        FastNanoClockAndSleeper sleeper = new FastNanoClockAndSleeper();
        BigQueryServicesImpl.JobServiceImpl.startJob((Job)testJob, (ApiErrorExtractor)new ApiErrorExtractor(), (Bigquery)this.bigquery, (Sleeper)sleeper, (BackOff)BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.backoff()));
        this.verifyAllResponsesAreRead();
        this.expectedLogs.verifyNotLogged("Started BigQuery job");
    }

    @Test
    public void testStartLoadJobRetry() throws IOException, InterruptedException {
        Job testJob = new Job();
        JobReference jobRef = new JobReference();
        jobRef.setJobId("jobId");
        jobRef.setProjectId("projectId");
        testJob.setJobReference(jobRef);
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)403);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("rateLimitExceeded", 403)));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        });
        FastNanoClockAndSleeper sleeper = new FastNanoClockAndSleeper();
        BigQueryServicesImpl.JobServiceImpl.startJob((Job)testJob, (ApiErrorExtractor)new ApiErrorExtractor(), (Bigquery)this.bigquery, (Sleeper)sleeper, (BackOff)BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.backoff()));
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testPollJobSucceeds() throws IOException, InterruptedException {
        Job testJob = new Job();
        testJob.setStatus(new JobStatus().setState("DONE"));
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        });
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        Job job = jobService.pollJob(jobRef, Sleeper.DEFAULT, BackOff.ZERO_BACKOFF);
        Assert.assertEquals((Object)testJob, (Object)job);
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testPollJobFailed() throws IOException, InterruptedException {
        Job testJob = new Job();
        testJob.setStatus(new JobStatus().setState("DONE").setErrorResult(new ErrorProto()));
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        });
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        Job job = jobService.pollJob(jobRef, Sleeper.DEFAULT, BackOff.ZERO_BACKOFF);
        Assert.assertEquals((Object)testJob, (Object)job);
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testPollJobUnknown() throws IOException, InterruptedException {
        Job testJob = new Job();
        testJob.setStatus(new JobStatus());
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        });
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        Job job = jobService.pollJob(jobRef, Sleeper.DEFAULT, BackOff.STOP_BACKOFF);
        Assert.assertEquals(null, (Object)job);
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testGetJobSucceeds() throws Exception {
        Job testJob = new Job();
        testJob.setStatus(new JobStatus());
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testJob));
        });
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        Job job = jobService.getJob(jobRef, Sleeper.DEFAULT, BackOff.ZERO_BACKOFF);
        Assert.assertEquals((Object)testJob, (Object)job);
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testGetJobNotFound() throws Exception {
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)404);
        });
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        Job job = jobService.getJob(jobRef, Sleeper.DEFAULT, BackOff.ZERO_BACKOFF);
        Assert.assertEquals(null, (Object)job);
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testGetJobThrows() throws Exception {
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)401);
        });
        BigQueryServicesImpl.JobServiceImpl jobService = new BigQueryServicesImpl.JobServiceImpl(this.bigquery);
        JobReference jobRef = new JobReference().setProjectId("projectId").setJobId("jobId");
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(String.format("Unable to find BigQuery job: %s", jobRef));
        jobService.getJob(jobRef, Sleeper.DEFAULT, BackOff.STOP_BACKOFF);
    }

    @Test
    public void testGetTableSucceeds() throws Exception {
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        Table testTable = new Table();
        testTable.setTableReference(tableRef);
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)403);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("rateLimitExceeded", 403)));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testTable));
        });
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        Table table = datasetService.getTable(tableRef, null, BackOff.ZERO_BACKOFF, Sleeper.DEFAULT);
        Assert.assertEquals((Object)testTable, (Object)table);
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testGetTableNotFound() throws IOException, InterruptedException {
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)404);
        });
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        Table table = datasetService.getTable(tableRef, null, BackOff.ZERO_BACKOFF, Sleeper.DEFAULT);
        Assert.assertNull((Object)table);
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testGetTableThrows() throws Exception {
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)401);
        });
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(String.format("Unable to get table: %s", tableRef.getTableId()));
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        datasetService.getTable(tableRef, null, BackOff.STOP_BACKOFF, Sleeper.DEFAULT);
    }

    @Test
    public void testIsTableEmptySucceeds() throws Exception {
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        TableDataList testDataList = new TableDataList().setRows((List)ImmutableList.of((Object)new TableRow()));
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)403);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("rateLimitExceeded", 403)));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testDataList));
        });
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        Assert.assertFalse((boolean)datasetService.isTableEmpty(tableRef, BackOff.ZERO_BACKOFF, Sleeper.DEFAULT));
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testIsTableEmptyNoRetryForNotFound() throws IOException, InterruptedException {
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)404);
        });
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(String.format("Unable to list table data: %s", tableRef.getTableId()));
        try {
            datasetService.isTableEmpty(tableRef, BackOff.ZERO_BACKOFF, Sleeper.DEFAULT);
        }
        finally {
            this.verifyAllResponsesAreRead();
        }
    }

    @Test
    public void testIsTableEmptyThrows() throws Exception {
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)401);
        });
        TableReference tableRef = new TableReference().setProjectId("projectId").setDatasetId("datasetId").setTableId("tableId");
        BigQueryServicesImpl.DatasetServiceImpl datasetService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(String.format("Unable to list table data: %s", tableRef.getTableId()));
        datasetService.isTableEmpty(tableRef, BackOff.STOP_BACKOFF, Sleeper.DEFAULT);
    }

    @Test
    public void testExecuteWithRetries() throws IOException, InterruptedException {
        Table testTable = new Table();
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testTable));
        });
        Table table = (Table)BigQueryServicesImpl.executeWithRetries((AbstractGoogleClientRequest)this.bigquery.tables().get("projectId", "datasetId", "tableId"), (String)"Failed to get table.", (Sleeper)Sleeper.DEFAULT, (BackOff)BackOff.STOP_BACKOFF, (SerializableFunction)BigQueryServicesImpl.ALWAYS_RETRY);
        Assert.assertEquals((Object)testTable, (Object)table);
        this.verifyAllResponsesAreRead();
    }

    private <T> FailsafeValueInSingleWindow<T, T> wrapValue(T value) {
        return FailsafeValueInSingleWindow.of(value, (Instant)GlobalWindow.TIMESTAMP_MAX_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING, value);
    }

    private <T> ValueInSingleWindow<T> wrapErrorValue(T value) {
        return ValueInSingleWindow.of(value, (Instant)GlobalWindow.TIMESTAMP_MAX_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING);
    }

    @Test
    public void testInsertRateLimitRetry() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>> rows = new ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>>();
        rows.add(this.wrapValue(new TableRow()));
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)403);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("rateLimitExceeded", 403)));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)new TableDataInsertAllResponse()));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        dataService.insertAll(ref, rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null);
        this.verifyAllResponsesAreRead();
        this.expectedLogs.verifyInfo("BigQuery insertAll error, retrying:");
        this.verifyWriteMetricWasSet("project", "dataset", "table", "ratelimitexceeded", 1L);
    }

    @Test
    public void testInsertQuotaExceededRetry() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>> rows = new ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>>();
        rows.add(this.wrapValue(new TableRow()));
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)403);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("quotaExceeded", 403)));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)new TableDataInsertAllResponse()));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        dataService.insertAll(ref, rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null);
        this.verifyAllResponsesAreRead();
        this.expectedLogs.verifyInfo("BigQuery insertAll error, retrying:");
        this.verifyWriteMetricWasSet("project", "dataset", "table", "quotaexceeded", 1L);
    }

    @Test
    public void testInsertStoppedRetry() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>> rows = new ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>>();
        rows.add(this.wrapValue(new TableRow()));
        MockSetupFunction quotaExceededResponse = response -> {
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)403);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("quotaExceeded", 403)));
        };
        this.setupMockResponses(quotaExceededResponse, quotaExceededResponse, quotaExceededResponse, quotaExceededResponse, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)new TableDataInsertAllResponse()));
        });
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("quotaExceeded");
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        dataService.insertAll(ref, rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null);
        this.verifyAllResponsesAreRead();
        this.verifyWriteMetricWasSet("project", "dataset", "table", "quotaexceeded", 1L);
    }

    @Test
    public void testInsertRetrySelectRows() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow().set("row", (Object)"a")), this.wrapValue(new TableRow().set("row", (Object)"b")));
        ImmutableList insertIds = ImmutableList.of((Object)"a", (Object)"b");
        TableDataInsertAllResponse bFailed = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(1L)).setErrors((List)ImmutableList.of((Object)new ErrorProto()))));
        TableDataInsertAllResponse allRowsSucceeded = new TableDataInsertAllResponse();
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)bFailed));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        dataService.insertAll(ref, (List)rows, (List)insertIds, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null);
        this.verifyAllResponsesAreRead();
        this.verifyWriteMetricWasSet("project", "dataset", "table", "unknown", 1L);
        this.verifyWriteMetricWasSet("project", "dataset", "table", "ok", 1L);
    }

    @Test
    public void testInsertWithinRowCountLimits() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow().set("row", (Object)"a")), this.wrapValue(new TableRow().set("row", (Object)"b")), this.wrapValue(new TableRow().set("row", (Object)"c")));
        ImmutableList insertIds = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        TableDataInsertAllResponse allRowsSucceeded = new TableDataInsertAllResponse();
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.fromArgs((String[])new String[]{"--maxStreamingRowsToBatch=1"}).create());
        dataService.insertAll(ref, (List)rows, (List)insertIds, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null);
        this.verifyAllResponsesAreRead();
        this.verifyWriteMetricWasSet("project", "dataset", "table", "ok", 3L);
    }

    @Test
    public void testInsertWithinRequestByteSizeLimitsErrorsOut() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow().set("row", (Object)Strings.repeat((String)"abcdefghi", (int)0x100400))), this.wrapValue(new TableRow().set("row", (Object)"a")), this.wrapValue(new TableRow().set("row", (Object)"b")));
        ImmutableList insertIds = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        TableDataInsertAllResponse allRowsSucceeded = new TableDataInsertAllResponse();
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.fromArgs((String[])new String[]{"--maxStreamingBatchSize=15"}).create());
        ArrayList failedInserts = Lists.newArrayList();
        ArrayList successfulRows = Lists.newArrayList();
        RuntimeException e = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> BigQueryServicesImplTest.lambda$testInsertWithinRequestByteSizeLimitsErrorsOut$32(dataService, ref, (List)rows, (List)insertIds, failedInserts, successfulRows));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"this row is too large."));
    }

    @Test
    public void testInsertRetryTransientsAboveRequestByteSizeLimits() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow().set("row", (Object)Strings.repeat((String)"abcdefghi", (int)0x100400))), this.wrapValue(new TableRow().set("row", (Object)"a")), this.wrapValue(new TableRow().set("row", (Object)"b")));
        ImmutableList insertIds = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        TableDataInsertAllResponse allRowsSucceeded = new TableDataInsertAllResponse();
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.fromArgs((String[])new String[]{"--maxStreamingBatchSize=15"}).create());
        ArrayList failedInserts = Lists.newArrayList();
        ArrayList successfulRows = Lists.newArrayList();
        dataService.insertAll(ref, (List)rows, (List)insertIds, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.retryTransientErrors(), (List)failedInserts, ErrorContainer.TABLE_ROW_ERROR_CONTAINER, false, false, false, (List)successfulRows);
        Assert.assertEquals((long)1L, (long)failedInserts.size());
        Assert.assertEquals((long)2L, (long)successfulRows.size());
        this.verifyAllResponsesAreRead();
        this.verifyWriteMetricWasSet("project", "dataset", "table", "ok", 1L);
    }

    @Test
    public void testInsertWithinRequestByteSizeLimits() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow().set("row", (Object)"a")), this.wrapValue(new TableRow().set("row", (Object)"b")), this.wrapValue(new TableRow().set("row", (Object)"cdefghijklmnopqrstuvwxyz")));
        ImmutableList insertIds = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        TableDataInsertAllResponse allRowsSucceeded = new TableDataInsertAllResponse();
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.fromArgs((String[])new String[]{"--maxStreamingBatchSize=15"}).create());
        dataService.insertAll(ref, (List)rows, (List)insertIds, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.retryTransientErrors(), new ArrayList(), ErrorContainer.TABLE_ROW_ERROR_CONTAINER, false, false, false, null);
        this.verifyAllResponsesAreRead();
        this.verifyWriteMetricWasSet("project", "dataset", "table", "ok", 2L);
    }

    @Test
    public void testInsertFailsGracefully() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow()), this.wrapValue(new TableRow()));
        ErrorProto errorProto = new ErrorProto().setReason("schemaMismatch");
        TableDataInsertAllResponse row1Failed = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(1L)).setErrors((List)ImmutableList.of((Object)errorProto))));
        TableDataInsertAllResponse row0Failed = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)errorProto))));
        MockSetupFunction row0FailureResponseFunction = response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenAnswer(invocation -> BigQueryServicesImplTest.toStream((GenericJson)row0Failed));
        };
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)row1Failed));
        }, row0FailureResponseFunction, row0FailureResponseFunction, row0FailureResponseFunction);
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        try {
            dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null);
            Assert.fail();
        }
        catch (IOException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IOException.class));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Insert failed:"));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"[{\"errors\":[{\"reason\":\"schemaMismatch\"}]"));
        }
        this.verifyAllResponsesAreRead();
        this.expectedLogs.verifyInfo("Retrying 1 failed inserts to BigQuery");
        this.verifyWriteMetricWasSet("project", "dataset", "table", "schemamismatch", 4L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailInsertOtherRetry() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>> rows = new ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>>();
        rows.add(this.wrapValue(new TableRow()));
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)403);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("actually forbidden", 403)));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)new TableDataInsertAllResponse()));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("actually forbidden");
        try {
            dataService.insertAll(ref, rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null);
        }
        finally {
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[0], (VerificationMode)Mockito.atLeastOnce())).getStatusCode();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[0])).getContent();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[0])).getContentType();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[1], (VerificationMode)Mockito.never())).getStatusCode();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[1], (VerificationMode)Mockito.never())).getContent();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[1], (VerificationMode)Mockito.never())).getContentType();
        }
        this.verifyWriteMetricWasSet("project", "dataset", "table", "actually forbidden", 1L);
    }

    @Test
    public void testInsertTimeoutLog() throws Exception {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>> rows = new ArrayList<FailsafeValueInSingleWindow<TableRow, TableRow>>();
        rows.add(this.wrapValue(new TableRow()));
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)400);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus(" No rows present in the request. ", 400)));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        RuntimeException e = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> dataService.insertAll(ref, rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null));
        MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)"No rows present in the request."));
        this.verifyAllResponsesAreRead();
        this.expectedLogs.verifyError("No rows present in the request error likely caused by");
        this.verifyWriteMetricWasSet("project", "dataset", "table", " no rows present in the request. ", 1L);
    }

    @Test
    public void testInsertRetryPolicy() throws InterruptedException, IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow()), this.wrapValue(new TableRow()));
        TableDataInsertAllResponse firstFailure = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout"))), (Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(1L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("invalid")))));
        TableDataInsertAllResponse secondFialure = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout")))));
        TableDataInsertAllResponse allRowsSucceeded = new TableDataInsertAllResponse();
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)firstFailure));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)secondFialure));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        ArrayList failedInserts = Lists.newArrayList();
        dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.retryTransientErrors(), (List)failedInserts, ErrorContainer.TABLE_ROW_ERROR_CONTAINER, false, false, false, null);
        Assert.assertEquals((long)1L, (long)failedInserts.size());
        this.expectedLogs.verifyInfo("Retrying 1 failed inserts to BigQuery");
        this.verifyWriteMetricWasSet("project", "dataset", "table", "timeout", 2L);
    }

    @Test
    public void testSkipInvalidRowsIgnoreUnknownIgnoreInsertIdsValuesStreaming() throws InterruptedException, IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow()), this.wrapValue(new TableRow()));
        TableDataInsertAllResponse allRowsSucceeded = new TableDataInsertAllResponse();
        MockSetupFunction allRowsSucceededResponseFunction = response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)allRowsSucceeded));
        };
        this.setupMockResponses(allRowsSucceededResponseFunction, allRowsSucceededResponseFunction);
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.neverRetry(), (List)Lists.newArrayList(), ErrorContainer.TABLE_ROW_ERROR_CONTAINER, false, false, false, null);
        TableDataInsertAllRequest parsedRequest = BigQueryServicesImplTest.fromString(this.request.getContentAsString(), TableDataInsertAllRequest.class);
        Assert.assertFalse((boolean)parsedRequest.getSkipInvalidRows());
        Assert.assertFalse((boolean)parsedRequest.getIgnoreUnknownValues());
        dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.neverRetry(), (List)Lists.newArrayList(), ErrorContainer.TABLE_ROW_ERROR_CONTAINER, true, true, true, null);
        parsedRequest = BigQueryServicesImplTest.fromString(this.request.getContentAsString(), TableDataInsertAllRequest.class);
        Assert.assertTrue((boolean)parsedRequest.getSkipInvalidRows());
        Assert.assertTrue((boolean)parsedRequest.getIgnoreUnknownValues());
        Assert.assertNull((Object)((TableDataInsertAllRequest.Rows)parsedRequest.getRows().get(0)).getInsertId());
        Assert.assertNull((Object)((TableDataInsertAllRequest.Rows)parsedRequest.getRows().get(1)).getInsertId());
        this.verifyWriteMetricWasSet("project", "dataset", "table", "ok", 2L);
    }

    private static <T extends GenericJson> T fromString(String content, Class<T> clazz) throws IOException {
        return (T)((GenericJson)JacksonFactory.getDefaultInstance().fromString(content, clazz));
    }

    private static InputStream toStream(GenericJson content) throws IOException {
        return new ByteArrayInputStream(JacksonFactory.getDefaultInstance().toByteArray((Object)content));
    }

    private static GoogleJsonErrorContainer errorWithReasonAndStatus(String reason, int status) {
        GoogleJsonError.ErrorInfo info = new GoogleJsonError.ErrorInfo();
        info.setReason(reason);
        info.setDomain("global");
        GoogleJsonError error = new GoogleJsonError();
        error.setErrors((List)ImmutableList.of((Object)info));
        error.setCode(status);
        error.setMessage(reason);
        GoogleJsonErrorContainer container = new GoogleJsonErrorContainer();
        container.setError(error);
        return container;
    }

    @Test
    public void testGetErrorInfo() throws IOException {
        GoogleJsonError.ErrorInfo info = new GoogleJsonError.ErrorInfo();
        ArrayList<GoogleJsonError.ErrorInfo> infoList = new ArrayList<GoogleJsonError.ErrorInfo>();
        infoList.add(info);
        info.setReason("QuotaExceeded");
        GoogleJsonError error = new GoogleJsonError();
        error.setErrors(infoList);
        HttpResponseException.Builder builder = (HttpResponseException.Builder)Mockito.mock(HttpResponseException.Builder.class);
        GoogleJsonResponseException validException = new GoogleJsonResponseException(builder, error);
        IOException invalidException = new IOException();
        Assert.assertEquals((Object)info.getReason(), (Object)BigQueryServicesImpl.DatasetServiceImpl.getErrorInfo((IOException)validException).getReason());
        Assert.assertNull((Object)BigQueryServicesImpl.DatasetServiceImpl.getErrorInfo((IOException)invalidException));
    }

    @Test
    public void testCreateTableSucceeds() throws IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        Table testTable = new Table().setTableReference(ref);
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testTable));
        });
        BigQueryServicesImpl.DatasetServiceImpl services = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        Table ret = services.tryCreateTable(testTable, (BackOff)new RetryBoundedBackOff(BackOff.ZERO_BACKOFF, 0), Sleeper.DEFAULT);
        Assert.assertEquals((Object)testTable, (Object)ret);
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testCreateTableDoesNotRetry() throws IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        Table testTable = new Table().setTableReference(ref);
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)403);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("actually forbidden", 403)));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testTable));
        });
        this.thrown.expect(GoogleJsonResponseException.class);
        this.thrown.expectMessage("actually forbidden");
        BigQueryServicesImpl.DatasetServiceImpl services = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        try {
            services.tryCreateTable(testTable, (BackOff)new RetryBoundedBackOff(BackOff.ZERO_BACKOFF, 3), Sleeper.DEFAULT);
            Assert.fail();
        }
        catch (IOException e) {
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[0], (VerificationMode)Mockito.atLeastOnce())).getStatusCode();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[0])).getContent();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[0])).getContentType();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[1], (VerificationMode)Mockito.never())).getStatusCode();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[1], (VerificationMode)Mockito.never())).getContent();
            ((LowLevelHttpResponse)Mockito.verify((Object)this.responses[1], (VerificationMode)Mockito.never())).getContentType();
            throw e;
        }
    }

    @Test
    public void testCreateTableSucceedsAlreadyExists() throws IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        TableSchema schema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("column1").setType("String"), (Object)new TableFieldSchema().setName("column2").setType("Integer")));
        Table testTable = new Table().setTableReference(ref).setSchema(schema);
        this.setupMockResponses(response -> Mockito.when((Object)response.getStatusCode()).thenReturn((Object)409));
        BigQueryServicesImpl.DatasetServiceImpl services = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        Table ret = services.tryCreateTable(testTable, (BackOff)new RetryBoundedBackOff(BackOff.ZERO_BACKOFF, 0), Sleeper.DEFAULT);
        Assert.assertNull((Object)ret);
        this.verifyAllResponsesAreRead();
    }

    @Test
    public void testCreateTableRetry() throws IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        Table testTable = new Table().setTableReference(ref);
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)403);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)BigQueryServicesImplTest.errorWithReasonAndStatus("rateLimitExceeded", 403)));
        }, response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)testTable));
        });
        BigQueryServicesImpl.DatasetServiceImpl services = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        Table ret = services.tryCreateTable(testTable, (BackOff)new RetryBoundedBackOff(BackOff.ZERO_BACKOFF, 3), Sleeper.DEFAULT);
        Assert.assertEquals((Object)testTable, (Object)ret);
        this.verifyAllResponsesAreRead();
        Assert.assertNotNull((Object)ret.getTableReference());
        this.expectedLogs.verifyInfo("Quota limit reached when creating table project:dataset.table, retrying up to 5 minutes");
    }

    @Test
    public void testSimpleErrorRetrieval() throws InterruptedException, IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow().set("a", (Object)1)), this.wrapValue(new TableRow().set("b", (Object)2)));
        ImmutableList expected = ImmutableList.of(this.wrapErrorValue(new TableRow().set("a", (Object)1)), this.wrapErrorValue(new TableRow().set("b", (Object)2)));
        TableDataInsertAllResponse failures = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout"))), (Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(1L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("invalid")))));
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)failures));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        ArrayList failedInserts = Lists.newArrayList();
        dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.neverRetry(), (List)failedInserts, ErrorContainer.TABLE_ROW_ERROR_CONTAINER, false, false, false, null);
        MatcherAssert.assertThat((Object)failedInserts, (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testExtendedErrorRetrieval() throws InterruptedException, IOException {
        TableReference ref = new TableReference().setProjectId("project").setDatasetId("dataset").setTableId("table");
        ImmutableList rows = ImmutableList.of(this.wrapValue(new TableRow().set("a", (Object)1)), this.wrapValue(new TableRow().set("b", (Object)2)));
        TableDataInsertAllResponse failures = new TableDataInsertAllResponse().setInsertErrors((List)ImmutableList.of((Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(0L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("timeout"))), (Object)new TableDataInsertAllResponse.InsertErrors().setIndex(Long.valueOf(1L)).setErrors((List)ImmutableList.of((Object)new ErrorProto().setReason("invalid")))));
        ImmutableList expected = ImmutableList.of(this.wrapErrorValue(new BigQueryInsertError((TableRow)((FailsafeValueInSingleWindow)rows.get(0)).getValue(), (TableDataInsertAllResponse.InsertErrors)failures.getInsertErrors().get(0), ref)), this.wrapErrorValue(new BigQueryInsertError((TableRow)((FailsafeValueInSingleWindow)rows.get(1)).getValue(), (TableDataInsertAllResponse.InsertErrors)failures.getInsertErrors().get(1), ref)));
        this.setupMockResponses(response -> {
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
            Mockito.when((Object)response.getContentType()).thenReturn((Object)"application/json; charset=UTF-8");
            Mockito.when((Object)response.getContent()).thenReturn((Object)BigQueryServicesImplTest.toStream((GenericJson)failures));
        });
        BigQueryServicesImpl.DatasetServiceImpl dataService = new BigQueryServicesImpl.DatasetServiceImpl(this.bigquery, null, PipelineOptionsFactory.create());
        ArrayList failedInserts = Lists.newArrayList();
        dataService.insertAll(ref, (List)rows, null, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.neverRetry(), (List)failedInserts, ErrorContainer.BIG_QUERY_INSERT_ERROR_ERROR_CONTAINER, false, false, false, null);
        MatcherAssert.assertThat((Object)failedInserts, (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testCreateReadSessionSetsRequestCountMetric() throws InterruptedException, IOException {
        BigQueryServicesImpl.StorageClientImpl client = (BigQueryServicesImpl.StorageClientImpl)Mockito.mock(BigQueryServicesImpl.StorageClientImpl.class);
        CreateReadSessionRequest.Builder builder = CreateReadSessionRequest.newBuilder();
        builder.getReadSessionBuilder().setTable("myproject:mydataset.mytable");
        CreateReadSessionRequest request = builder.build();
        Mockito.when((Object)client.callCreateReadSession(request)).thenReturn((Object)ReadSession.newBuilder().build());
        Mockito.when((Object)client.createReadSession((CreateReadSessionRequest)ArgumentMatchers.any())).thenCallRealMethod();
        client.createReadSession(request);
        this.verifyReadMetricWasSet("myproject", "mydataset", "mytable", "ok", 1L);
    }

    @Test
    public void testCreateReadSessionSetsRequestCountMetricOnError() throws InterruptedException, IOException {
        BigQueryServicesImpl.StorageClientImpl client = (BigQueryServicesImpl.StorageClientImpl)Mockito.mock(BigQueryServicesImpl.StorageClientImpl.class);
        CreateReadSessionRequest.Builder builder = CreateReadSessionRequest.newBuilder();
        builder.getReadSessionBuilder().setTable("myproject:mydataset.mytable");
        CreateReadSessionRequest request = builder.build();
        StatusCode statusCode = new StatusCode(){

            public StatusCode.Code getCode() {
                return StatusCode.Code.NOT_FOUND;
            }

            public Object getTransportCode() {
                return null;
            }
        };
        Mockito.when((Object)client.callCreateReadSession(request)).thenThrow(new Throwable[]{new ApiException("Not Found", null, statusCode, false)});
        Mockito.when((Object)client.createReadSession((CreateReadSessionRequest)ArgumentMatchers.any())).thenCallRealMethod();
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("Not Found");
        client.createReadSession(request);
        this.verifyReadMetricWasSet("myproject", "mydataset", "mytable", "not_found", 1L);
    }

    @Test
    public void testReadRowsSetsRequestCountMetric() throws InterruptedException, IOException {
        BigQueryServices.StorageClient client = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServicesImpl.StorageClientImpl.class);
        ReadRowsRequest request = null;
        BigQueryServices.BigQueryServerStream<ReadRowsResponse> response = new BigQueryServices.BigQueryServerStream<ReadRowsResponse>(){

            public Iterator<ReadRowsResponse> iterator() {
                return null;
            }

            public void cancel() {
            }
        };
        Mockito.when((Object)client.readRows(request)).thenReturn((Object)response);
        Mockito.when((Object)client.readRows((ReadRowsRequest)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenCallRealMethod();
        client.readRows(request, "myproject:mydataset.mytable");
        this.verifyReadMetricWasSet("myproject", "mydataset", "mytable", "ok", 1L);
    }

    @Test
    public void testReadRowsSetsRequestCountMetricOnError() throws InterruptedException, IOException {
        BigQueryServices.StorageClient client = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServicesImpl.StorageClientImpl.class);
        ReadRowsRequest request = null;
        StatusCode statusCode = new StatusCode(){

            public StatusCode.Code getCode() {
                return StatusCode.Code.INTERNAL;
            }

            public Object getTransportCode() {
                return null;
            }
        };
        Mockito.when((Object)client.readRows(request)).thenThrow(new Throwable[]{new ApiException("Internal", null, statusCode, false)});
        Mockito.when((Object)client.readRows((ReadRowsRequest)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenCallRealMethod();
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("Internal");
        client.readRows(request, "myproject:mydataset.mytable");
        this.verifyReadMetricWasSet("myproject", "mydataset", "mytable", "internal", 1L);
    }

    @Test
    public void testSplitReadStreamSetsRequestCountMetric() throws InterruptedException, IOException {
        BigQueryServices.StorageClient client = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServicesImpl.StorageClientImpl.class);
        SplitReadStreamRequest request = null;
        Mockito.when((Object)client.splitReadStream(request)).thenReturn((Object)SplitReadStreamResponse.newBuilder().build());
        Mockito.when((Object)client.splitReadStream((SplitReadStreamRequest)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenCallRealMethod();
        client.splitReadStream(request, "myproject:mydataset.mytable");
        this.verifyReadMetricWasSet("myproject", "mydataset", "mytable", "ok", 1L);
    }

    @Test
    public void testSplitReadStreamSetsRequestCountMetricOnError() throws InterruptedException, IOException {
        BigQueryServices.StorageClient client = (BigQueryServices.StorageClient)Mockito.mock(BigQueryServicesImpl.StorageClientImpl.class);
        SplitReadStreamRequest request = null;
        StatusCode statusCode = new StatusCode(){

            public StatusCode.Code getCode() {
                return StatusCode.Code.RESOURCE_EXHAUSTED;
            }

            public Object getTransportCode() {
                return null;
            }
        };
        Mockito.when((Object)client.splitReadStream(request)).thenThrow(new Throwable[]{new ApiException("Resource Exhausted", null, statusCode, false)});
        Mockito.when((Object)client.splitReadStream((SplitReadStreamRequest)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenCallRealMethod();
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("Resource Exhausted");
        client.splitReadStream(request, "myproject:mydataset.mytable");
        this.verifyReadMetricWasSet("myproject", "mydataset", "mytable", "resource_exhausted", 1L);
    }

    @Test
    public void testRetryAttemptCounter() {
        BigQueryServicesImpl.StorageClientImpl.RetryAttemptCounter counter = new BigQueryServicesImpl.StorageClientImpl.RetryAttemptCounter();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setSeconds(123L).setNanos(456000000).build()).build();
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)"google.rpc.retryinfo-bin", (Metadata.BinaryMarshaller)new Metadata.BinaryMarshaller<RetryInfo>(){

            public byte[] toBytes(RetryInfo value) {
                return value.toByteArray();
            }

            public RetryInfo parseBytes(byte[] serialized) {
                try {
                    Parser parser = RetryInfo.newBuilder().build().getParserForType();
                    return (RetryInfo)parser.parseFrom(serialized);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }), (Object)retryInfo);
        MetricName metricName = MetricName.named((String)"org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl$StorageClientImpl", (String)"throttling-msecs");
        MetricsContainerImpl container = (MetricsContainerImpl)MetricsEnvironment.getCurrentContainer();
        counter.onRetryAttempt(null, null);
        Assert.assertEquals((long)0L, (long)container.getCounter(metricName).getCumulative());
        counter.onRetryAttempt(Status.RESOURCE_EXHAUSTED.withDescription("You have consumed some quota"), new Metadata());
        Assert.assertEquals((long)0L, (long)container.getCounter(metricName).getCumulative());
        counter.onRetryAttempt(Status.RESOURCE_EXHAUSTED.withDescription("Stop for a while"), metadata);
        Assert.assertEquals((long)123456L, (long)container.getCounter(metricName).getCumulative());
        counter.onRetryAttempt(Status.UNAVAILABLE.withDescription("Server is gone"), metadata);
        Assert.assertEquals((long)123456L, (long)container.getCounter(metricName).getCumulative());
    }

    private static /* synthetic */ void lambda$testInsertWithinRequestByteSizeLimitsErrorsOut$32(BigQueryServicesImpl.DatasetServiceImpl dataService, TableReference ref, List rows, List insertIds, List failedInserts, List successfulRows) throws Throwable {
        dataService.insertAll(ref, rows, insertIds, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)TEST_BACKOFF.backoff()), TEST_BACKOFF, (Sleeper)new MockSleeper(), InsertRetryPolicy.alwaysRetry(), failedInserts, ErrorContainer.TABLE_ROW_ERROR_CONTAINER, false, false, false, successfulRows);
    }

    @FunctionalInterface
    private static interface MockSetupFunction {
        public void apply(LowLevelHttpResponse var1) throws IOException;
    }
}

