/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryResourceNamingTest {
    public static final String BQ_JOB_PATTERN_REGEXP = "beam_bq_job_[A-Z]+_[a-z0-9-]+_[a-z0-9-]+(_[A-Za-z0-9-]+)?";

    @Test
    public void testJobTypesInNames() {
        Assert.assertEquals((Object)"beam_bq_job_EXPORT_beamappjobtest_abcd", (Object)BigQueryResourceNaming.createJobIdPrefix((String)"beamapp-job-test", (String)"abcd", (BigQueryResourceNaming.JobType)BigQueryResourceNaming.JobType.EXPORT));
        Assert.assertEquals((Object)"beam_bq_job_LOAD_beamappjobtest_abcd", (Object)BigQueryResourceNaming.createJobIdPrefix((String)"beamapp-job-test", (String)"abcd", (BigQueryResourceNaming.JobType)BigQueryResourceNaming.JobType.LOAD));
        Assert.assertEquals((Object)"beam_bq_job_QUERY_beamappjobtest_abcd", (Object)BigQueryResourceNaming.createJobIdPrefix((String)"beamapp-job-test", (String)"abcd", (BigQueryResourceNaming.JobType)BigQueryResourceNaming.JobType.QUERY));
        Assert.assertEquals((Object)"beam_bq_job_COPY_beamappjobtest_abcd", (Object)BigQueryResourceNaming.createJobIdPrefix((String)"beamapp-job-test", (String)"abcd", (BigQueryResourceNaming.JobType)BigQueryResourceNaming.JobType.COPY));
    }

    @Test
    public void testJobRandomInNames() {
        Assert.assertEquals((Object)"beam_bq_job_EXPORT_beamappjobtest_abcd_RANDOME", (Object)BigQueryResourceNaming.createJobIdPrefix((String)"beamapp-job-test", (String)"abcd", (BigQueryResourceNaming.JobType)BigQueryResourceNaming.JobType.EXPORT, (String)"RANDOME"));
    }

    @Test
    public void testMatchesBigQueryJobTemplate() {
        MatcherAssert.assertThat((Object)BigQueryResourceNaming.createJobIdPrefix((String)"beamapp-job-test", (String)"abcd", (BigQueryResourceNaming.JobType)BigQueryResourceNaming.JobType.EXPORT, (String)"RANDOME"), (Matcher)Matchers.matchesPattern((String)BQ_JOB_PATTERN_REGEXP));
        MatcherAssert.assertThat((Object)BigQueryResourceNaming.createJobIdPrefix((String)"beamapp-job-test", (String)"abcd", (BigQueryResourceNaming.JobType)BigQueryResourceNaming.JobType.COPY), (Matcher)Matchers.matchesPattern((String)BQ_JOB_PATTERN_REGEXP));
    }
}

