/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatistics2;
import com.google.api.services.bigquery.model.Streamingbuffer;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.bigtable.v2.Mutation;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.extensions.protobuf.ByteStringCoder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.PassThroughThenCleanup;
import org.apache.beam.sdk.io.gcp.bigquery.ProjectOverride;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.testing.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.testing.FakeDatasetService;
import org.apache.beam.sdk.io.gcp.testing.FakeJobService;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Select;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.model.Statement;

@RunWith(value=JUnit4.class)
public class BigQueryIOReadTest
implements Serializable {
    private transient PipelineOptions options;
    private transient TemporaryFolder testFolder = new TemporaryFolder();
    private transient TestPipeline p;
    @Rule
    public final transient TestRule folderThenPipeline = new TestRule(){

        public Statement apply(final Statement base, final Description description) {
            Statement withPipeline = new Statement(){

                public void evaluate() throws Throwable {
                    BigQueryIOReadTest.this.options = TestPipeline.testingPipelineOptions();
                    ((BigQueryOptions)BigQueryIOReadTest.this.options.as(BigQueryOptions.class)).setProject("project-id");
                    if (description.getAnnotations().stream().anyMatch(a -> a.annotationType().equals(ProjectOverride.class))) {
                        ((BigQueryOptions)BigQueryIOReadTest.this.options.as(BigQueryOptions.class)).setBigQueryProject("bigquery-project-id");
                    }
                    ((BigQueryOptions)BigQueryIOReadTest.this.options.as(BigQueryOptions.class)).setTempLocation(BigQueryIOReadTest.this.testFolder.getRoot().getAbsolutePath());
                    BigQueryIOReadTest.this.p = TestPipeline.fromOptions((PipelineOptions)BigQueryIOReadTest.this.options);
                    BigQueryIOReadTest.this.p.apply(base, description).evaluate();
                }
            };
            return BigQueryIOReadTest.this.testFolder.apply(withPipeline, description);
        }
    };
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private FakeDatasetService fakeDatasetService = new FakeDatasetService();
    private FakeJobService fakeJobService = new FakeJobService();
    private FakeBigQueryServices fakeBqServices = new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withJobService((BigQueryServices.JobService)this.fakeJobService);

    private void checkSetsProject(String projectId) throws Exception {
        this.fakeDatasetService.createDataset(projectId, "dataset-id", "", "", null);
        String tableId = "sometable";
        TableReference tableReference = new TableReference().setProjectId(projectId).setDatasetId("dataset-id").setTableId(tableId);
        this.fakeDatasetService.createTable(new Table().setTableReference(tableReference).setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))));
        FakeBigQueryServices fakeBqServices = new FakeBigQueryServices().withJobService((BigQueryServices.JobService)new FakeJobService()).withDatasetService(this.fakeDatasetService);
        ImmutableList expected = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        this.fakeDatasetService.insertAll(tableReference, (List)expected, null);
        TableReference tableRef = new TableReference().setDatasetId("dataset-id").setTableId(tableId);
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)BigQueryIO.read().from(tableRef).withTestServices((BigQueryServices)fakeBqServices))).apply((PTransform)ParDo.of((DoFn)new DoFn<TableRow, KV<String, Long>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output((Object)KV.of((Object)((String)((TableRow)c.element()).get((Object)"name")), (Object)Long.valueOf((String)((TableRow)c.element()).get((Object)"number"))));
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)"a", (Object)1L), (Object)KV.of((Object)"b", (Object)2L), (Object)KV.of((Object)"c", (Object)3L), (Object)KV.of((Object)"d", (Object)4L), (Object)KV.of((Object)"e", (Object)5L), (Object)KV.of((Object)"f", (Object)6L)));
        this.p.run();
    }

    private void checkReadTableObject(BigQueryIO.Read read, String project, String dataset, String table) {
        this.checkReadTableObjectWithValidate(read, project, dataset, table, true);
    }

    private void checkReadQueryObject(BigQueryIO.Read read, String query) {
        this.checkReadQueryObjectWithValidate(read, query, true);
    }

    private void checkTypedReadQueryObject(BigQueryIO.TypedRead<?> read, String query, String kmsKey, String tempDataset) {
        this.checkTypedReadQueryObjectWithValidate(read, query, kmsKey, tempDataset, true);
    }

    private void checkReadTableObjectWithValidate(BigQueryIO.Read read, String project, String dataset, String table, boolean validate) {
        Assert.assertEquals((Object)project, (Object)read.getTable().getProjectId());
        Assert.assertEquals((Object)dataset, (Object)read.getTable().getDatasetId());
        Assert.assertEquals((Object)table, (Object)read.getTable().getTableId());
        Assert.assertNull((Object)read.getQuery());
        Assert.assertEquals((Object)validate, (Object)read.getValidate());
    }

    private void checkReadQueryObjectWithValidate(BigQueryIO.Read read, String query, boolean validate) {
        Assert.assertNull((Object)read.getTable());
        Assert.assertEquals((Object)query, (Object)read.getQuery().get());
        Assert.assertEquals((Object)validate, (Object)read.getValidate());
    }

    private void checkTypedReadQueryObjectWithValidate(BigQueryIO.TypedRead<?> read, String query, String kmsKey, String tempDataset, boolean validate) {
        Assert.assertNull((Object)read.getTable());
        Assert.assertEquals((Object)query, (Object)read.getQuery().get());
        Assert.assertEquals((Object)kmsKey, (Object)read.getKmsKey());
        Assert.assertEquals((Object)tempDataset, (Object)read.getQueryTempDataset());
        Assert.assertEquals((Object)validate, (Object)read.getValidate());
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        FakeDatasetService.setUp();
        BigQueryIO.clearCreatedTables();
        this.fakeDatasetService.createDataset("project-id", "dataset-id", "", "", null);
    }

    @Test
    public void testBuildTableBasedSource() {
        BigQueryIO.Read read = BigQueryIO.read().from("foo.com:project:somedataset.sometable");
        this.checkReadTableObject(read, "foo.com:project", "somedataset", "sometable");
    }

    @Test
    public void testBuildQueryBasedSource() {
        BigQueryIO.Read read = BigQueryIO.read().fromQuery("foo_query");
        this.checkReadQueryObject(read, "foo_query");
    }

    @Test
    public void testBuildTableBasedSourceWithoutValidation() {
        BigQueryIO.Read read = BigQueryIO.read().from("foo.com:project:somedataset.sometable").withoutValidation();
        this.checkReadTableObjectWithValidate(read, "foo.com:project", "somedataset", "sometable", false);
    }

    @Test
    public void testBuildQueryBasedSourceWithoutValidation() {
        BigQueryIO.Read read = BigQueryIO.read().fromQuery("some_query").withoutValidation();
        this.checkReadQueryObjectWithValidate(read, "some_query", false);
    }

    @Test
    public void testBuildTableBasedSourceWithDefaultProject() {
        BigQueryIO.Read read = BigQueryIO.read().from("somedataset.sometable");
        this.checkReadTableObject(read, null, "somedataset", "sometable");
    }

    @Test
    public void testBuildSourceWithTableReference() {
        TableReference table = new TableReference().setProjectId("foo.com:project").setDatasetId("somedataset").setTableId("sometable");
        BigQueryIO.Read read = BigQueryIO.read().from(table);
        this.checkReadTableObject(read, "foo.com:project", "somedataset", "sometable");
    }

    @Test
    public void testBuildQueryBasedTypedReadSource() {
        BigQueryIO.TypedRead read = BigQueryIO.readTableRows().fromQuery("foo_query").withKmsKey("kms_key").withQueryTempDataset("temp_dataset");
        this.checkTypedReadQueryObject(read, "foo_query", "kms_key", "temp_dataset");
    }

    @Test
    @ProjectOverride
    public void testValidateReadSetsBigQueryProject() throws Exception {
        this.checkSetsProject("bigquery-project-id");
    }

    @Test
    public void testValidateReadSetsDefaultProject() throws Exception {
        this.checkSetsProject("project-id");
    }

    @Test
    public void testBuildSourceWithTableAndFlatten() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid BigQueryIO.Read: Specifies a table with a result flattening preference, which only applies to queries");
        this.p.apply("ReadMyTable", (PTransform)BigQueryIO.read().from("foo.com:project:somedataset.sometable").withoutResultFlattening());
        this.p.run();
    }

    @Test
    public void testBuildSourceWithTableAndFlattenWithoutValidation() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid BigQueryIO.Read: Specifies a table with a result flattening preference, which only applies to queries");
        this.p.apply((PTransform)BigQueryIO.read().from("foo.com:project:somedataset.sometable").withoutValidation().withoutResultFlattening());
        this.p.run();
    }

    @Test
    public void testBuildSourceWithTableAndSqlDialect() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid BigQueryIO.Read: Specifies a table with a SQL dialect preference, which only applies to queries");
        this.p.apply((PTransform)BigQueryIO.read().from("foo.com:project:somedataset.sometable").usingStandardSql());
        this.p.run();
    }

    @Test
    public void testReadFromTableWithoutTemplateCompatibility() throws IOException, InterruptedException {
        this.testReadFromTable(false, false);
    }

    @Test
    public void testReadFromTableWithTemplateCompatibility() throws IOException, InterruptedException {
        this.testReadFromTable(true, false);
    }

    @Test
    public void testReadTableRowsFromTableWithoutTemplateCompatibility() throws IOException, InterruptedException {
        this.testReadFromTable(false, true);
    }

    @Test
    public void testReadTableRowsFromTableWithTemplateCompatibility() throws IOException, InterruptedException {
        this.testReadFromTable(true, true);
    }

    private void testReadFromTable(boolean useTemplateCompatibility, boolean useReadTableRows) throws IOException, InterruptedException {
        BigQueryIO.Read readTransform;
        BigQueryIO.Read read;
        Table sometable = new Table();
        sometable.setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER"))));
        sometable.setTableReference(new TableReference().setProjectId("non-executing-project").setDatasetId("somedataset").setTableId("sometable"));
        sometable.setNumBytes(Long.valueOf(0x100000L));
        FakeDatasetService fakeDatasetService = new FakeDatasetService();
        fakeDatasetService.createDataset("non-executing-project", "somedataset", "", "", null);
        fakeDatasetService.createTable(sometable);
        ArrayList records = Lists.newArrayList((Object[])new TableRow[]{new TableRow().set("name", (Object)"a").set("number", (Object)1L), new TableRow().set("name", (Object)"b").set("number", (Object)2L), new TableRow().set("name", (Object)"c").set("number", (Object)3L)});
        fakeDatasetService.insertAll(sometable.getTableReference(), (List)records, null);
        FakeBigQueryServices fakeBqServices = new FakeBigQueryServices().withJobService((BigQueryServices.JobService)new FakeJobService()).withDatasetService(fakeDatasetService);
        if (useReadTableRows) {
            read = BigQueryIO.read().from("non-executing-project:somedataset.sometable").withTestServices((BigQueryServices)fakeBqServices).withoutValidation();
            readTransform = useTemplateCompatibility ? read.withTemplateCompatibility() : read;
        } else {
            read = BigQueryIO.readTableRows().from("non-executing-project:somedataset.sometable").withTestServices((BigQueryServices)fakeBqServices).withoutValidation();
            readTransform = useTemplateCompatibility ? read.withTemplateCompatibility() : read;
        }
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)readTransform)).apply((PTransform)ParDo.of((DoFn)new DoFn<TableRow, KV<String, Long>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output((Object)KV.of((Object)((String)((TableRow)c.element()).get((Object)"name")), (Object)Long.valueOf((String)((TableRow)c.element()).get((Object)"number"))));
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)"a", (Object)1L), (Object)KV.of((Object)"b", (Object)2L), (Object)KV.of((Object)"c", (Object)3L)));
        this.p.run();
    }

    @Test
    public void testReadTableWithSchema() throws IOException, InterruptedException {
        Table someTable = new Table();
        someTable.setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER"))));
        someTable.setTableReference(new TableReference().setProjectId("non-executing-project").setDatasetId("schema_dataset").setTableId("schema_table"));
        someTable.setNumBytes(Long.valueOf(0x100000L));
        FakeDatasetService fakeDatasetService = new FakeDatasetService();
        fakeDatasetService.createDataset("non-executing-project", "schema_dataset", "", "", null);
        fakeDatasetService.createTable(someTable);
        ArrayList records = Lists.newArrayList((Object[])new TableRow[]{new TableRow().set("name", (Object)"a").set("number", (Object)1L), new TableRow().set("name", (Object)"b").set("number", (Object)2L), new TableRow().set("name", (Object)"c").set("number", (Object)3L)});
        fakeDatasetService.insertAll(someTable.getTableReference(), (List)records, null);
        FakeBigQueryServices fakeBqServices = new FakeBigQueryServices().withJobService((BigQueryServices.JobService)new FakeJobService()).withDatasetService(fakeDatasetService);
        BigQueryIO.TypedRead read = BigQueryIO.readTableRowsWithSchema().from("non-executing-project:schema_dataset.schema_table").withTestServices((BigQueryServices)fakeBqServices).withoutValidation();
        PCollection bqRows = (PCollection)this.p.apply((PTransform)read);
        Schema expectedSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING).withNullable(true), Schema.Field.of((String)"number", (Schema.FieldType)Schema.FieldType.INT64).withNullable(true)});
        Assert.assertEquals((Object)expectedSchema, (Object)bqRows.getSchema());
        PCollection output = (PCollection)bqRows.apply((PTransform)Select.fieldNames((String[])new String[]{"name", "number"}));
        PAssert.that((PCollection)output).containsInAnyOrder((Iterable)ImmutableList.of((Object)Row.withSchema((Schema)expectedSchema).addValues(new Object[]{"a", 1L}).build(), (Object)Row.withSchema((Schema)expectedSchema).addValues(new Object[]{"b", 2L}).build(), (Object)Row.withSchema((Schema)expectedSchema).addValues(new Object[]{"c", 3L}).build()));
        this.p.run();
    }

    @Test
    public void testBuildSourceDisplayDataTable() {
        String tableSpec = "project:dataset.tableid";
        BigQueryIO.Read read = BigQueryIO.read().from(tableSpec).withoutResultFlattening().usingStandardSql().withoutValidation();
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"table", (String)tableSpec));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"flattenResults", (Boolean)false));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"useLegacySql", (Boolean)false));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"validation", (Boolean)false));
    }

    @Test
    public void testBuildSourceDisplayDataQuery() {
        BigQueryIO.Read read = BigQueryIO.read().fromQuery("myQuery").withoutResultFlattening().usingStandardSql().withoutValidation();
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"query", (String)"myQuery"));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"flattenResults", (Boolean)false));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"useLegacySql", (Boolean)false));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"validation", (Boolean)false));
    }

    @Test
    public void testBigQueryIOGetName() {
        Assert.assertEquals((Object)"BigQueryIO.Read", (Object)BigQueryIO.read().from("somedataset.sometable").getName());
    }

    @Test
    public void testBigQueryTableSourceInitSplit() throws Exception {
        ImmutableList expected = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        TableReference table = BigQueryHelpers.parseTableSpec((String)"project:data_set.table_name");
        this.fakeDatasetService.createDataset("project", "data_set", "", "", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(table).setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))));
        this.fakeDatasetService.insertAll(table, (List)expected, null);
        String stepUuid = "testStepUuid";
        BigQuerySourceBase bqSource = BigQueryTableSourceDef.create((BigQueryServices)this.fakeBqServices, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)table)).toSource(stepUuid, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE, false);
        PipelineOptions options = PipelineOptionsFactory.create();
        options.setTempLocation(this.testFolder.getRoot().getAbsolutePath());
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        bqOptions.setProject("project");
        List<TableRow> read = this.convertStringsToLong(SourceTestUtils.readFromSplitsOfSource((BoundedSource)bqSource, (long)0L, (PipelineOptions)options));
        MatcherAssert.assertThat(read, (Matcher)Matchers.containsInAnyOrder((Object[])((TableRow[])Iterables.toArray((Iterable)expected, TableRow.class))));
        List sources = bqSource.split(100L, options);
        Assert.assertEquals((long)2L, (long)sources.size());
        sources = bqSource.split(200L, options);
        Assert.assertEquals((long)2L, (long)sources.size());
        Assert.assertEquals((long)1L, (long)this.fakeJobService.getNumExtractJobCalls());
    }

    @Test
    public void testEstimatedSizeWithoutStreamingBuffer() throws Exception {
        ImmutableList data = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        TableReference table = BigQueryHelpers.parseTableSpec((String)"project:data_set.table_name");
        this.fakeDatasetService.createDataset("project", "data_set", "", "", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(table).setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))));
        this.fakeDatasetService.insertAll(table, (List)data, null);
        String stepUuid = "testStepUuid";
        BigQuerySourceBase bqSource = BigQueryTableSourceDef.create((BigQueryServices)this.fakeBqServices, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)table)).toSource(stepUuid, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE, false);
        PipelineOptions options = PipelineOptionsFactory.create();
        long expectedSize = 24L * (long)data.size();
        Assert.assertEquals((long)expectedSize, (long)bqSource.getEstimatedSizeBytes(options));
    }

    @Test
    public void testEstimatedSizeWithStreamingBuffer() throws Exception {
        ImmutableList data = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        TableReference table = BigQueryHelpers.parseTableSpec((String)"project:data_set.table_name");
        this.fakeDatasetService.createDataset("project", "data_set", "", "", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(table).setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).setStreamingBuffer(new Streamingbuffer().setEstimatedBytes(BigInteger.valueOf(10L))));
        this.fakeDatasetService.insertAll(table, (List)data, null);
        String stepUuid = "testStepUuid";
        BigQuerySourceBase bqSource = BigQueryTableSourceDef.create((BigQueryServices)this.fakeBqServices, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)table)).toSource(stepUuid, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE, false);
        PipelineOptions options = PipelineOptionsFactory.create();
        long expectedSize = 24L * (long)data.size() + 10L;
        Assert.assertEquals((long)expectedSize, (long)bqSource.getEstimatedSizeBytes(options));
    }

    @Test
    public void testBigQueryQuerySourceEstimatedSize() throws Exception {
        String queryString = "fake query string";
        PipelineOptions options = PipelineOptionsFactory.create();
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        bqOptions.setProject("project");
        String stepUuid = "testStepUuid";
        BigQuerySourceBase bqSource = BigQueryQuerySourceDef.create((BigQueryServices)this.fakeBqServices, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)queryString), (Boolean)true, (Boolean)true, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.BATCH, null, null, null).toSource(stepUuid, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE, false);
        this.fakeJobService.expectDryRunQuery(bqOptions.getProject(), queryString, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(100L))));
        Assert.assertEquals((long)100L, (long)bqSource.getEstimatedSizeBytes((PipelineOptions)bqOptions));
    }

    @Test
    public void testBigQueryQuerySourceInitSplit() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        bqOptions.setProject("project");
        TableReference sourceTableRef = BigQueryHelpers.parseTableSpec((String)"project:dataset.table");
        this.fakeDatasetService.createDataset(sourceTableRef.getProjectId(), sourceTableRef.getDatasetId(), "asia-northeast1", "Fake plastic tree^H^H^H^Htables", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(sourceTableRef).setLocation("asia-northeast1"));
        Table queryResultTable = new Table().setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER"))));
        ImmutableList expected = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        String encodedQuery = FakeBigQueryServices.encodeQueryResult((Table)queryResultTable, (List)expected);
        String stepUuid = "testStepUuid";
        TableReference tempTableReference = BigQueryResourceNaming.createTempTableReference((String)bqOptions.getProject(), (String)BigQueryResourceNaming.createJobIdPrefix((String)options.getJobName(), (String)stepUuid, (BigQueryResourceNaming.JobType)BigQueryResourceNaming.JobType.QUERY), Optional.empty());
        this.fakeJobService.expectDryRunQuery(bqOptions.getProject(), encodedQuery, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(100L)).setReferencedTables((List)ImmutableList.of((Object)sourceTableRef, (Object)tempTableReference))));
        BigQuerySourceBase bqSource = BigQueryQuerySourceDef.create((BigQueryServices)this.fakeBqServices, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)encodedQuery), (Boolean)true, (Boolean)true, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.BATCH, null, null, null).toSource(stepUuid, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE, false);
        options.setTempLocation(this.testFolder.getRoot().getAbsolutePath());
        List<TableRow> read = this.convertStringsToLong(SourceTestUtils.readFromSplitsOfSource((BoundedSource)bqSource, (long)0L, (PipelineOptions)options));
        MatcherAssert.assertThat(read, (Matcher)Matchers.containsInAnyOrder((Object[])((TableRow[])Iterables.toArray((Iterable)expected, TableRow.class))));
        List sources = bqSource.split(100L, options);
        Assert.assertEquals((long)2L, (long)sources.size());
    }

    @Test
    public void testBigQueryQuerySourceInitSplit_NoReferencedTables() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        bqOptions.setProject("project");
        Table queryResultTable = new Table().setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER"))));
        ImmutableList expected = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        String encodedQuery = FakeBigQueryServices.encodeQueryResult((Table)queryResultTable, (List)expected);
        String stepUuid = "testStepUuid";
        this.fakeJobService.expectDryRunQuery(bqOptions.getProject(), encodedQuery, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(100L)).setReferencedTables((List)ImmutableList.of())));
        BigQuerySourceBase bqSource = BigQueryQuerySourceDef.create((BigQueryServices)this.fakeBqServices, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)encodedQuery), (Boolean)true, (Boolean)true, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.BATCH, null, null, null).toSource(stepUuid, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE, false);
        options.setTempLocation(this.testFolder.getRoot().getAbsolutePath());
        List<TableRow> read = this.convertStringsToLong(SourceTestUtils.readFromSplitsOfSource((BoundedSource)bqSource, (long)0L, (PipelineOptions)options));
        MatcherAssert.assertThat(read, (Matcher)Matchers.containsInAnyOrder((Object[])((TableRow[])Iterables.toArray((Iterable)expected, TableRow.class))));
        List sources = bqSource.split(100L, options);
        Assert.assertEquals((long)2L, (long)sources.size());
    }

    @Test
    public void testPassThroughThenCleanup() throws Exception {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)new PassThroughThenCleanup(new PassThroughThenCleanup.CleanupOperation(){

            void cleanup(PassThroughThenCleanup.ContextContainer c) throws Exception {
            }
        }, (PCollectionView)((PCollection)this.p.apply("Create1", (PTransform)Create.of((Object)"", (Object[])new String[0]))).apply((PTransform)View.asSingleton())));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, 2, 3});
        this.p.run();
    }

    @Test
    public void testPassThroughThenCleanupExecuted() throws Exception {
        ((PCollection)this.p.apply((PTransform)Create.empty((Coder)VarIntCoder.of()))).apply((PTransform)new PassThroughThenCleanup(new PassThroughThenCleanup.CleanupOperation(){

            void cleanup(PassThroughThenCleanup.ContextContainer c) throws Exception {
                throw new RuntimeException("cleanup executed");
            }
        }, (PCollectionView)((PCollection)this.p.apply("Create1", (PTransform)Create.of((Object)"", (Object[])new String[0]))).apply((PTransform)View.asSingleton())));
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("cleanup executed");
        this.p.run();
    }

    @Test
    public void testRuntimeOptionsNotCalledInApplyInputTable() {
        BigQueryIO.Read read = BigQueryIO.read().from(this.p.newProvider((Object)"")).withoutValidation();
        DisplayData.from((HasDisplayData)read);
    }

    @Test
    public void testRuntimeOptionsNotCalledInApplyInputQuery() {
        BigQueryIO.Read read = BigQueryIO.read().fromQuery(this.p.newProvider((Object)"")).withoutValidation();
        DisplayData.from((HasDisplayData)read);
    }

    List<TableRow> convertStringsToLong(List<TableRow> toConvert) {
        ArrayList converted = Lists.newArrayList();
        for (TableRow entry : toConvert) {
            TableRow convertedEntry = entry.clone();
            convertedEntry.set("number", (Object)Long.parseLong((String)convertedEntry.get((Object)"number")));
            converted.add(convertedEntry);
        }
        return converted;
    }

    @Test
    public void testCoderInference() {
        SerializableFunction<SchemaAndRecord, KV<ByteString, Mutation>> parseFn = new SerializableFunction<SchemaAndRecord, KV<ByteString, Mutation>>(){

            public KV<ByteString, Mutation> apply(SchemaAndRecord input) {
                return null;
            }
        };
        Assert.assertEquals((Object)KvCoder.of((Coder)ByteStringCoder.of(), (Coder)ProtoCoder.of(Mutation.class)), (Object)BigQueryIO.read((SerializableFunction)parseFn).inferCoder(CoderRegistry.createDefault()));
    }
}

