/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;
import org.apache.commons.lang3.tuple.Pair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryAvroUtilsTest {
    private List<TableFieldSchema> subFields = Lists.newArrayList((Object[])new TableFieldSchema[]{new TableFieldSchema().setName("species").setType("STRING").setMode("NULLABLE")});
    private List<TableFieldSchema> fields = Lists.newArrayList((Object[])new TableFieldSchema[]{new TableFieldSchema().setName("number").setType("INTEGER").setMode("REQUIRED"), new TableFieldSchema().setName("species").setType("STRING").setMode("NULLABLE"), new TableFieldSchema().setName("quality").setType("FLOAT"), new TableFieldSchema().setName("quantity").setType("INTEGER"), new TableFieldSchema().setName("birthday").setType("TIMESTAMP").setMode("NULLABLE"), new TableFieldSchema().setName("birthdayMoney").setType("NUMERIC").setMode("NULLABLE"), new TableFieldSchema().setName("lotteryWinnings").setType("BIGNUMERIC").setMode("NULLABLE"), new TableFieldSchema().setName("flighted").setType("BOOLEAN").setMode("NULLABLE"), new TableFieldSchema().setName("sound").setType("BYTES").setMode("NULLABLE"), new TableFieldSchema().setName("anniversaryDate").setType("DATE").setMode("NULLABLE"), new TableFieldSchema().setName("anniversaryDatetime").setType("DATETIME").setMode("NULLABLE"), new TableFieldSchema().setName("anniversaryTime").setType("TIME").setMode("NULLABLE"), new TableFieldSchema().setName("scion").setType("RECORD").setMode("NULLABLE").setFields(this.subFields), new TableFieldSchema().setName("associates").setType("RECORD").setMode("REPEATED").setFields(this.subFields), new TableFieldSchema().setName("geoPositions").setType("GEOGRAPHY").setMode("NULLABLE")});

    private Pair<LogicalType, byte[]> convertToByteBuffer(BigDecimal bigDecimal, Schema schema) {
        LogicalTypes.Decimal bigDecimalLogicalType = LogicalTypes.decimal((int)bigDecimal.precision(), (int)bigDecimal.scale());
        byte[] bigDecimalBytes = new Conversions.DecimalConversion().toBytes(bigDecimal, schema, (LogicalType)bigDecimalLogicalType).array();
        return Pair.of((Object)bigDecimalLogicalType, (Object)bigDecimalBytes);
    }

    @Test
    public void testConvertGenericRecordToTableRow() throws Exception {
        TableSchema tableSchema = new TableSchema();
        tableSchema.setFields(this.fields);
        Schema numericSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        BigDecimal numeric = new BigDecimal("123456789.123456789");
        Pair<LogicalType, byte[]> numericPair = this.convertToByteBuffer(numeric, numericSchema);
        Schema bigNumericSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        BigDecimal bigNumeric = new BigDecimal("578960446186580977117854925043439539266.34992332820282019728792003956564819967");
        Pair<LogicalType, byte[]> bigNumericPair = this.convertToByteBuffer(bigNumeric, bigNumericSchema);
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (Schema.Field field : AvroCoder.of(Bird.class).getSchema().getFields()) {
            Schema schema = field.schema();
            if ("birthdayMoney".equals(field.name())) {
                schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), ((LogicalType)numericPair.getLeft()).addToSchema(numericSchema)});
            } else if ("lotteryWinnings".equals(field.name())) {
                schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), ((LogicalType)bigNumericPair.getLeft()).addToSchema(bigNumericSchema)});
            }
            avroFields.add(new Schema.Field(field.name(), schema, field.doc(), field.defaultValue()));
        }
        Schema avroSchema = Schema.createRecord(avroFields);
        GenericData.Record record = new GenericData.Record(avroSchema);
        record.put("number", (Object)5L);
        TableRow convertedRow = BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)record, (TableSchema)tableSchema);
        TableRow row = new TableRow().set("number", (Object)"5").set("associates", new ArrayList());
        Assert.assertEquals((Object)row, (Object)convertedRow);
        TableRow clonedRow = convertedRow.clone();
        Assert.assertEquals((Object)convertedRow, (Object)clonedRow);
        record = new GenericData.Record(avroSchema);
        byte[] soundBytes = "chirp,chirp".getBytes(StandardCharsets.UTF_8);
        ByteBuffer soundByteBuffer = ByteBuffer.wrap(soundBytes);
        soundByteBuffer.rewind();
        record.put("number", (Object)5L);
        record.put("quality", (Object)5.0);
        record.put("birthday", (Object)5L);
        record.put("birthdayMoney", (Object)ByteBuffer.wrap((byte[])numericPair.getRight()));
        record.put("lotteryWinnings", (Object)ByteBuffer.wrap((byte[])bigNumericPair.getRight()));
        record.put("flighted", (Object)Boolean.TRUE);
        record.put("sound", (Object)soundByteBuffer);
        record.put("anniversaryDate", (Object)new Utf8("2000-01-01"));
        record.put("anniversaryDatetime", (Object)new String("2000-01-01 00:00:00.000005"));
        record.put("anniversaryTime", (Object)new Utf8("00:00:00.000005"));
        record.put("geoPositions", (Object)new String("LINESTRING(1 2, 3 4, 5 6, 7 8)"));
        TableRow convertedRow2 = BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)record, (TableSchema)tableSchema);
        TableRow row2 = new TableRow().set("number", (Object)"5").set("birthday", (Object)"1970-01-01 00:00:00.000005 UTC").set("birthdayMoney", (Object)numeric.toString()).set("lotteryWinnings", (Object)bigNumeric.toString()).set("quality", (Object)5.0).set("associates", new ArrayList()).set("flighted", (Object)Boolean.TRUE).set("sound", (Object)BaseEncoding.base64().encode(soundBytes)).set("anniversaryDate", (Object)"2000-01-01").set("anniversaryDatetime", (Object)"2000-01-01 00:00:00.000005").set("anniversaryTime", (Object)"00:00:00.000005").set("geoPositions", (Object)"LINESTRING(1 2, 3 4, 5 6, 7 8)");
        TableRow clonedRow2 = convertedRow2.clone();
        Assert.assertEquals((Object)convertedRow2, (Object)clonedRow2);
        Assert.assertEquals((Object)row2, (Object)convertedRow2);
        Schema subBirdSchema = AvroCoder.of(Bird.SubBird.class).getSchema();
        GenericData.Record nestedRecord = new GenericData.Record(subBirdSchema);
        nestedRecord.put("species", (Object)"other");
        GenericData.Record record2 = new GenericData.Record(avroSchema);
        record2.put("number", (Object)5L);
        record2.put("associates", (Object)Lists.newArrayList((Object[])new GenericRecord[]{nestedRecord}));
        record2.put("birthdayMoney", (Object)ByteBuffer.wrap((byte[])numericPair.getRight()));
        record2.put("lotteryWinnings", (Object)ByteBuffer.wrap((byte[])bigNumericPair.getRight()));
        convertedRow2 = BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)record2, (TableSchema)tableSchema);
        row2 = new TableRow().set("associates", (Object)Lists.newArrayList((Object[])new TableRow[]{new TableRow().set("species", (Object)"other")})).set("number", (Object)"5").set("birthdayMoney", (Object)numeric.toString()).set("lotteryWinnings", (Object)bigNumeric.toString());
        Assert.assertEquals((Object)row2, (Object)convertedRow2);
        clonedRow2 = convertedRow2.clone();
        Assert.assertEquals((Object)convertedRow2, (Object)clonedRow2);
    }

    @Test
    public void testConvertBigQuerySchemaToAvroSchema() {
        TableSchema tableSchema = new TableSchema();
        tableSchema.setFields(this.fields);
        Schema avroSchema = BigQueryAvroUtils.toGenericAvroSchema((String)"testSchema", (List)tableSchema.getFields());
        MatcherAssert.assertThat((Object)avroSchema.getField("number").schema(), (Matcher)Matchers.equalTo((Object)Schema.create((Schema.Type)Schema.Type.LONG)));
        MatcherAssert.assertThat((Object)avroSchema.getField("species").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("quality").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.DOUBLE)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("quantity").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("birthday").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("birthdayMoney").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BYTES)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("lotteryWinnings").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BYTES)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("flighted").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BOOLEAN)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("sound").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BYTES)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("anniversaryDate").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("anniversaryDatetime").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("anniversaryTime").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("geoPositions").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        MatcherAssert.assertThat((Object)avroSchema.getField("scion").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.createRecord((String)"scion", (String)"Translated Avro Schema for scion", (String)"org.apache.beam.sdk.io.gcp.bigquery", (boolean)false, (List)ImmutableList.of((Object)new Schema.Field("species", Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)}), null, null)))})));
        MatcherAssert.assertThat((Object)avroSchema.getField("associates").schema(), (Matcher)Matchers.equalTo((Object)Schema.createArray((Schema)Schema.createRecord((String)"associates", (String)"Translated Avro Schema for associates", (String)"org.apache.beam.sdk.io.gcp.bigquery", (boolean)false, (List)ImmutableList.of((Object)new Schema.Field("species", Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)}), null, null))))));
    }

    @Test
    public void testFormatTimestamp() {
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)1452062291123456L), (Matcher)Matchers.equalTo((Object)"2016-01-06 06:38:11.123456 UTC"));
    }

    @Test
    public void testFormatTimestampLeadingZeroesOnMicros() {
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)1452062291000456L), (Matcher)Matchers.equalTo((Object)"2016-01-06 06:38:11.000456 UTC"));
    }

    @Test
    public void testFormatTimestampTrailingZeroesOnMicros() {
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)1452062291123000L), (Matcher)Matchers.equalTo((Object)"2016-01-06 06:38:11.123000 UTC"));
    }

    @Test
    public void testFormatTimestampNegative() {
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)-1L), (Matcher)Matchers.equalTo((Object)"1969-12-31 23:59:59.999999 UTC"));
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)-100000L), (Matcher)Matchers.equalTo((Object)"1969-12-31 23:59:59.900000 UTC"));
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)-1000000L), (Matcher)Matchers.equalTo((Object)"1969-12-31 23:59:59 UTC"));
        MatcherAssert.assertThat((Object)BigQueryAvroUtils.formatTimestamp((Long)-62135596800000000L), (Matcher)Matchers.equalTo((Object)"0001-01-01 00:00:00 UTC"));
    }

    @DefaultCoder(value=AvroCoder.class)
    static class Bird {
        long number;
        @Nullable
        String species;
        @Nullable
        Double quality;
        @Nullable
        Long quantity;
        @Nullable
        Long birthday;
        @Nullable
        ByteBuffer birthdayMoney;
        @Nullable
        ByteBuffer lotteryWinnings;
        @Nullable
        String geoPositions;
        @Nullable
        Boolean flighted;
        @Nullable
        ByteBuffer sound;
        @Nullable
        Utf8 anniversaryDate;
        @Nullable
        String anniversaryDatetime;
        @Nullable
        Utf8 anniversaryTime;
        @Nullable
        SubBird scion;
        SubBird[] associates = new SubBird[1];

        public Bird() {
            this.associates[0] = new SubBird();
        }

        static class SubBird {
            @Nullable
            String species;
        }
    }
}

