/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigquery.BeamRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.CivilTimeEncoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Functions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BeamRowToStorageApiProtoTest {
    private static final EnumerationType TEST_ENUM = EnumerationType.create((String[])new String[]{"ONE", "TWO", "RED", "BLUE"});
    private static final Schema BASE_SCHEMA = Schema.builder().addField("byteValue", Schema.FieldType.BYTE.withNullable(true)).addField("int16Value", Schema.FieldType.INT16).addField("int32Value", Schema.FieldType.INT32.withNullable(true)).addField("int64Value", Schema.FieldType.INT64.withNullable(true)).addField("decimalValue", Schema.FieldType.DECIMAL.withNullable(true)).addField("floatValue", Schema.FieldType.FLOAT.withNullable(true)).addField("doubleValue", Schema.FieldType.DOUBLE.withNullable(true)).addField("stringValue", Schema.FieldType.STRING.withNullable(true)).addField("datetimeValue", Schema.FieldType.DATETIME.withNullable(true)).addField("booleanValue", Schema.FieldType.BOOLEAN.withNullable(true)).addField("bytesValue", Schema.FieldType.BYTES.withNullable(true)).addField("arrayValue", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).addField("iterableValue", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).addField("sqlDateValue", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATE).withNullable(true)).addField("sqlTimeValue", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME).withNullable(true)).addField("sqlDatetimeValue", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME).withNullable(true)).addField("sqlTimestampValue", Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIMESTAMP).withNullable(true)).addField("enumValue", Schema.FieldType.logicalType((Schema.LogicalType)TEST_ENUM).withNullable(true)).build();
    private static final DescriptorProtos.DescriptorProto BASE_SCHEMA_PROTO = DescriptorProtos.DescriptorProto.newBuilder().addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("bytevalue").setNumber(1).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("int16value").setNumber(2).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("int32value").setNumber(3).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("int64value").setNumber(4).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("decimalvalue").setNumber(5).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("floatvalue").setNumber(6).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("doublevalue").setNumber(7).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("stringvalue").setNumber(8).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("datetimevalue").setNumber(9).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("booleanvalue").setNumber(10).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("bytesvalue").setNumber(11).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("arrayvalue").setNumber(12).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("iterablevalue").setNumber(13).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("sqldatevalue").setNumber(14).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("sqltimevalue").setNumber(15).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("sqldatetimevalue").setNumber(16).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("sqltimestampvalue").setNumber(17).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("enumvalue").setNumber(18).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).build();
    private static final byte[] BYTES = "BYTE BYTE BYTE".getBytes(StandardCharsets.UTF_8);
    private static final Row BASE_ROW = Row.withSchema((Schema)BASE_SCHEMA).withFieldValue("byteValue", (Object)1).withFieldValue("int16Value", (Object)2).withFieldValue("int32Value", (Object)3).withFieldValue("int64Value", (Object)4L).withFieldValue("decimalValue", (Object)BigDecimal.valueOf(5L)).withFieldValue("floatValue", (Object)Float.valueOf(3.14f)).withFieldValue("doubleValue", (Object)2.68).withFieldValue("stringValue", (Object)"I am a string. Hear me roar.").withFieldValue("datetimeValue", (Object)org.joda.time.Instant.now()).withFieldValue("booleanValue", (Object)true).withFieldValue("bytesValue", (Object)BYTES).withFieldValue("arrayValue", (Object)ImmutableList.of((Object)"one", (Object)"two", (Object)"red", (Object)"blue")).withFieldValue("iterableValue", (Object)ImmutableList.of((Object)"blue", (Object)"red", (Object)"two", (Object)"one")).withFieldValue("sqlDateValue", (Object)LocalDate.now()).withFieldValue("sqlTimeValue", (Object)LocalTime.now()).withFieldValue("sqlDatetimeValue", (Object)LocalDateTime.now()).withFieldValue("sqlTimestampValue", (Object)Instant.now()).withFieldValue("enumValue", (Object)TEST_ENUM.valueOf("RED")).build();
    private static final Map<String, Object> BASE_PROTO_EXPECTED_FIELDS = ImmutableMap.builder().put((Object)"bytevalue", (Object)1).put((Object)"int16value", (Object)2).put((Object)"int32value", (Object)3).put((Object)"int64value", (Object)4L).put((Object)"decimalvalue", (Object)BeamRowToStorageApiProto.serializeBigDecimalToNumeric((BigDecimal)BigDecimal.valueOf(5L))).put((Object)"floatvalue", (Object)Float.valueOf(3.14f)).put((Object)"doublevalue", (Object)2.68).put((Object)"stringvalue", (Object)"I am a string. Hear me roar.").put((Object)"datetimevalue", (Object)(BASE_ROW.getDateTime("datetimeValue").getMillis() * 1000L)).put((Object)"booleanvalue", (Object)true).put((Object)"bytesvalue", (Object)ByteString.copyFrom((byte[])BYTES)).put((Object)"arrayvalue", (Object)ImmutableList.of((Object)"one", (Object)"two", (Object)"red", (Object)"blue")).put((Object)"iterablevalue", (Object)ImmutableList.of((Object)"blue", (Object)"red", (Object)"two", (Object)"one")).put((Object)"sqldatevalue", (Object)((int)((LocalDate)BASE_ROW.getLogicalTypeValue("sqlDateValue", LocalDate.class)).toEpochDay())).put((Object)"sqltimevalue", (Object)CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)((LocalTime)BASE_ROW.getLogicalTypeValue("sqlTimeValue", LocalTime.class)))).put((Object)"sqldatetimevalue", (Object)CivilTimeEncoder.encodePacked64DatetimeSeconds((LocalDateTime)((LocalDateTime)BASE_ROW.getLogicalTypeValue("sqlDatetimeValue", LocalDateTime.class)))).put((Object)"sqltimestampvalue", (Object)(((Instant)BASE_ROW.getLogicalTypeValue("sqlTimestampValue", Instant.class)).toEpochMilli() * 1000L)).put((Object)"enumvalue", (Object)"RED").build();
    private static final Schema NESTED_SCHEMA = Schema.builder().addField("nested", Schema.FieldType.row((Schema)BASE_SCHEMA).withNullable(true)).addField("nestedArray", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)BASE_SCHEMA))).addField("nestedIterable", Schema.FieldType.iterable((Schema.FieldType)Schema.FieldType.row((Schema)BASE_SCHEMA))).build();
    private static final Row NESTED_ROW = Row.withSchema((Schema)NESTED_SCHEMA).withFieldValue("nested", (Object)BASE_ROW).withFieldValue("nestedArray", (Object)ImmutableList.of((Object)BASE_ROW, (Object)BASE_ROW)).withFieldValue("nestedIterable", (Object)ImmutableList.of((Object)BASE_ROW, (Object)BASE_ROW)).build();

    @Test
    public void testDescriptorFromSchema() {
        DescriptorProtos.DescriptorProto descriptor = BeamRowToStorageApiProto.descriptorSchemaFromBeamSchema((Schema)BASE_SCHEMA);
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> types = descriptor.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> expectedTypes = BASE_SCHEMA_PROTO.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Assert.assertEquals(expectedTypes, types);
        Map<String, String> nameMapping = BASE_SCHEMA.getFields().stream().collect(Collectors.toMap(f -> f.getName().toLowerCase(), Schema.Field::getName));
        descriptor.getFieldList().forEach(p -> {
            Schema.FieldType schemaFieldType = BASE_SCHEMA.getField((String)nameMapping.get(p.getName())).getType();
            DescriptorProtos.FieldDescriptorProto.Label label = schemaFieldType.getTypeName().isCollectionType() ? DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED : (schemaFieldType.getNullable() != false ? DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL : DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
            Assert.assertEquals((Object)label, (Object)p.getLabel());
        });
    }

    @Test
    public void testNestedFromSchema() {
        DescriptorProtos.DescriptorProto descriptor = BeamRowToStorageApiProto.descriptorSchemaFromBeamSchema((Schema)NESTED_SCHEMA);
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> expectedBaseTypes = BASE_SCHEMA_PROTO.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> types = descriptor.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Map<String, String> typeNames = descriptor.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getTypeName));
        Map<String, DescriptorProtos.FieldDescriptorProto.Label> typeLabels = descriptor.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getLabel));
        Assert.assertEquals((long)3L, (long)types.size());
        Map nestedTypes = descriptor.getNestedTypeList().stream().collect(Collectors.toMap(DescriptorProtos.DescriptorProto::getName, Functions.identity()));
        Assert.assertEquals((long)3L, (long)nestedTypes.size());
        Assert.assertEquals((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE, (Object)types.get("nested"));
        Assert.assertEquals((Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL, (Object)typeLabels.get("nested"));
        String nestedTypeName1 = typeNames.get("nested");
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> nestedTypes1 = ((DescriptorProtos.DescriptorProto)nestedTypes.get(nestedTypeName1)).getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Assert.assertEquals(expectedBaseTypes, nestedTypes1);
        Assert.assertEquals((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE, (Object)types.get("nestedarray"));
        Assert.assertEquals((Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED, (Object)typeLabels.get("nestedarray"));
        String nestedTypeName2 = typeNames.get("nestedarray");
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> nestedTypes2 = ((DescriptorProtos.DescriptorProto)nestedTypes.get(nestedTypeName2)).getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Assert.assertEquals(expectedBaseTypes, nestedTypes2);
        Assert.assertEquals((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE, (Object)types.get("nestediterable"));
        Assert.assertEquals((Object)DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED, (Object)typeLabels.get("nestediterable"));
        String nestedTypeName3 = typeNames.get("nestediterable");
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> nestedTypes3 = ((DescriptorProtos.DescriptorProto)nestedTypes.get(nestedTypeName3)).getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Assert.assertEquals(expectedBaseTypes, nestedTypes3);
    }

    private void assertBaseRecord(DynamicMessage msg) {
        Map<String, Object> recordFields = msg.getAllFields().entrySet().stream().collect(Collectors.toMap(entry -> ((Descriptors.FieldDescriptor)entry.getKey()).getName(), entry -> entry.getValue()));
        Assert.assertEquals(BASE_PROTO_EXPECTED_FIELDS, recordFields);
    }

    @Test
    public void testMessageFromTableRow() throws Exception {
        Descriptors.Descriptor descriptor = BeamRowToStorageApiProto.getDescriptorFromSchema((Schema)NESTED_SCHEMA);
        DynamicMessage msg = BeamRowToStorageApiProto.messageFromBeamRow((Descriptors.Descriptor)descriptor, (Row)NESTED_ROW);
        Assert.assertEquals((long)3L, (long)msg.getAllFields().size());
        Map fieldDescriptors = descriptor.getFields().stream().collect(Collectors.toMap(Descriptors.FieldDescriptor::getName, Functions.identity()));
        DynamicMessage nestedMsg = (DynamicMessage)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("nested"));
        this.assertBaseRecord(nestedMsg);
    }
}

