
package org.apache.beam.sdk.io.gcp.spanner;

import java.util.Arrays;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_SerializedMutation extends SerializedMutation {

  private final String tableName;
  private final byte[] encodedKey;
  private final byte[] mutationGroupBytes;

  AutoValue_SerializedMutation(
      String tableName,
      byte[] encodedKey,
      byte[] mutationGroupBytes) {
    if (tableName == null) {
      throw new NullPointerException("Null tableName");
    }
    this.tableName = tableName;
    if (encodedKey == null) {
      throw new NullPointerException("Null encodedKey");
    }
    this.encodedKey = encodedKey;
    if (mutationGroupBytes == null) {
      throw new NullPointerException("Null mutationGroupBytes");
    }
    this.mutationGroupBytes = mutationGroupBytes;
  }

  @Override
  String getTableName() {
    return tableName;
  }

  @Override
  byte[] getEncodedKey() {
    return encodedKey;
  }

  @Override
  byte[] getMutationGroupBytes() {
    return mutationGroupBytes;
  }

  @Override
  public String toString() {
    return "SerializedMutation{"
        + "tableName=" + tableName + ", "
        + "encodedKey=" + Arrays.toString(encodedKey) + ", "
        + "mutationGroupBytes=" + Arrays.toString(mutationGroupBytes)
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SerializedMutation) {
      SerializedMutation that = (SerializedMutation) o;
      return (this.tableName.equals(that.getTableName()))
           && (Arrays.equals(this.encodedKey, (that instanceof AutoValue_SerializedMutation) ? ((AutoValue_SerializedMutation) that).encodedKey : that.getEncodedKey()))
           && (Arrays.equals(this.mutationGroupBytes, (that instanceof AutoValue_SerializedMutation) ? ((AutoValue_SerializedMutation) that).mutationGroupBytes : that.getMutationGroupBytes()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.tableName.hashCode();
    h *= 1000003;
    h ^= Arrays.hashCode(this.encodedKey);
    h *= 1000003;
    h ^= Arrays.hashCode(this.mutationGroupBytes);
    return h;
  }

}
