
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Statement;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ReadOperation extends ReadOperation {

  private final Statement query;
  private final String table;
  private final String index;
  private final List<String> columns;
  private final KeySet keySet;

  private AutoValue_ReadOperation(
      @Nullable Statement query,
      @Nullable String table,
      @Nullable String index,
      @Nullable List<String> columns,
      @Nullable KeySet keySet) {
    this.query = query;
    this.table = table;
    this.index = index;
    this.columns = columns;
    this.keySet = keySet;
  }

  @Nullable
  @Override
  public Statement getQuery() {
    return query;
  }

  @Nullable
  @Override
  public String getTable() {
    return table;
  }

  @Nullable
  @Override
  public String getIndex() {
    return index;
  }

  @Nullable
  @Override
  public List<String> getColumns() {
    return columns;
  }

  @Nullable
  @Override
  public KeySet getKeySet() {
    return keySet;
  }

  @Override
  public String toString() {
    return "ReadOperation{"
        + "query=" + query + ", "
        + "table=" + table + ", "
        + "index=" + index + ", "
        + "columns=" + columns + ", "
        + "keySet=" + keySet
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ReadOperation) {
      ReadOperation that = (ReadOperation) o;
      return ((this.query == null) ? (that.getQuery() == null) : this.query.equals(that.getQuery()))
           && ((this.table == null) ? (that.getTable() == null) : this.table.equals(that.getTable()))
           && ((this.index == null) ? (that.getIndex() == null) : this.index.equals(that.getIndex()))
           && ((this.columns == null) ? (that.getColumns() == null) : this.columns.equals(that.getColumns()))
           && ((this.keySet == null) ? (that.getKeySet() == null) : this.keySet.equals(that.getKeySet()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (query == null) ? 0 : this.query.hashCode();
    h *= 1000003;
    h ^= (table == null) ? 0 : this.table.hashCode();
    h *= 1000003;
    h ^= (index == null) ? 0 : this.index.hashCode();
    h *= 1000003;
    h ^= (columns == null) ? 0 : this.columns.hashCode();
    h *= 1000003;
    h ^= (keySet == null) ? 0 : this.keySet.hashCode();
    return h;
  }

  @Override
  ReadOperation.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ReadOperation.Builder {
    private Statement query;
    private String table;
    private String index;
    private List<String> columns;
    private KeySet keySet;
    Builder() {
    }
    private Builder(ReadOperation source) {
      this.query = source.getQuery();
      this.table = source.getTable();
      this.index = source.getIndex();
      this.columns = source.getColumns();
      this.keySet = source.getKeySet();
    }
    @Override
    ReadOperation.Builder setQuery(@Nullable Statement query) {
      this.query = query;
      return this;
    }
    @Override
    ReadOperation.Builder setTable(@Nullable String table) {
      this.table = table;
      return this;
    }
    @Override
    ReadOperation.Builder setIndex(@Nullable String index) {
      this.index = index;
      return this;
    }
    @Override
    ReadOperation.Builder setColumns(@Nullable List<String> columns) {
      this.columns = columns;
      return this;
    }
    @Override
    ReadOperation.Builder setKeySet(@Nullable KeySet keySet) {
      this.keySet = keySet;
      return this;
    }
    @Override
    ReadOperation build() {
      return new AutoValue_ReadOperation(
          this.query,
          this.table,
          this.index,
          this.columns,
          this.keySet);
    }
  }

}
