
package org.apache.beam.sdk.io.gcp.pubsub;

import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SimpleFunction;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_PubsubIO_Read<T> extends PubsubIO.Read<T> {

  private final ValueProvider<PubsubIO.PubsubTopic> topicProvider;
  private final ValueProvider<PubsubIO.PubsubSubscription> subscriptionProvider;
  private final String timestampAttribute;
  private final String idAttribute;
  private final Coder<T> coder;
  private final SimpleFunction<PubsubMessage, T> parseFn;
  private final boolean needsAttributes;

  private AutoValue_PubsubIO_Read(
      @Nullable ValueProvider<PubsubIO.PubsubTopic> topicProvider,
      @Nullable ValueProvider<PubsubIO.PubsubSubscription> subscriptionProvider,
      @Nullable String timestampAttribute,
      @Nullable String idAttribute,
      @Nullable Coder<T> coder,
      @Nullable SimpleFunction<PubsubMessage, T> parseFn,
      boolean needsAttributes) {
    this.topicProvider = topicProvider;
    this.subscriptionProvider = subscriptionProvider;
    this.timestampAttribute = timestampAttribute;
    this.idAttribute = idAttribute;
    this.coder = coder;
    this.parseFn = parseFn;
    this.needsAttributes = needsAttributes;
  }

  @Nullable
  @Override
  ValueProvider<PubsubIO.PubsubTopic> getTopicProvider() {
    return topicProvider;
  }

  @Nullable
  @Override
  ValueProvider<PubsubIO.PubsubSubscription> getSubscriptionProvider() {
    return subscriptionProvider;
  }

  @Nullable
  @Override
  String getTimestampAttribute() {
    return timestampAttribute;
  }

  @Nullable
  @Override
  String getIdAttribute() {
    return idAttribute;
  }

  @Nullable
  @Override
  Coder<T> getCoder() {
    return coder;
  }

  @Nullable
  @Override
  SimpleFunction<PubsubMessage, T> getParseFn() {
    return parseFn;
  }

  @Override
  boolean getNeedsAttributes() {
    return needsAttributes;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PubsubIO.Read) {
      PubsubIO.Read<?> that = (PubsubIO.Read<?>) o;
      return ((this.topicProvider == null) ? (that.getTopicProvider() == null) : this.topicProvider.equals(that.getTopicProvider()))
           && ((this.subscriptionProvider == null) ? (that.getSubscriptionProvider() == null) : this.subscriptionProvider.equals(that.getSubscriptionProvider()))
           && ((this.timestampAttribute == null) ? (that.getTimestampAttribute() == null) : this.timestampAttribute.equals(that.getTimestampAttribute()))
           && ((this.idAttribute == null) ? (that.getIdAttribute() == null) : this.idAttribute.equals(that.getIdAttribute()))
           && ((this.coder == null) ? (that.getCoder() == null) : this.coder.equals(that.getCoder()))
           && ((this.parseFn == null) ? (that.getParseFn() == null) : this.parseFn.equals(that.getParseFn()))
           && (this.needsAttributes == that.getNeedsAttributes());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (topicProvider == null) ? 0 : this.topicProvider.hashCode();
    h *= 1000003;
    h ^= (subscriptionProvider == null) ? 0 : this.subscriptionProvider.hashCode();
    h *= 1000003;
    h ^= (timestampAttribute == null) ? 0 : this.timestampAttribute.hashCode();
    h *= 1000003;
    h ^= (idAttribute == null) ? 0 : this.idAttribute.hashCode();
    h *= 1000003;
    h ^= (coder == null) ? 0 : this.coder.hashCode();
    h *= 1000003;
    h ^= (parseFn == null) ? 0 : this.parseFn.hashCode();
    h *= 1000003;
    h ^= this.needsAttributes ? 1231 : 1237;
    return h;
  }

  @Override
  PubsubIO.Read.Builder<T> toBuilder() {
    return new Builder<T>(this);
  }

  static final class Builder<T> extends PubsubIO.Read.Builder<T> {
    private ValueProvider<PubsubIO.PubsubTopic> topicProvider;
    private ValueProvider<PubsubIO.PubsubSubscription> subscriptionProvider;
    private String timestampAttribute;
    private String idAttribute;
    private Coder<T> coder;
    private SimpleFunction<PubsubMessage, T> parseFn;
    private Boolean needsAttributes;
    Builder() {
    }
    private Builder(PubsubIO.Read<T> source) {
      this.topicProvider = source.getTopicProvider();
      this.subscriptionProvider = source.getSubscriptionProvider();
      this.timestampAttribute = source.getTimestampAttribute();
      this.idAttribute = source.getIdAttribute();
      this.coder = source.getCoder();
      this.parseFn = source.getParseFn();
      this.needsAttributes = source.getNeedsAttributes();
    }
    @Override
    PubsubIO.Read.Builder<T> setTopicProvider(@Nullable ValueProvider<PubsubIO.PubsubTopic> topicProvider) {
      this.topicProvider = topicProvider;
      return this;
    }
    @Override
    PubsubIO.Read.Builder<T> setSubscriptionProvider(@Nullable ValueProvider<PubsubIO.PubsubSubscription> subscriptionProvider) {
      this.subscriptionProvider = subscriptionProvider;
      return this;
    }
    @Override
    PubsubIO.Read.Builder<T> setTimestampAttribute(@Nullable String timestampAttribute) {
      this.timestampAttribute = timestampAttribute;
      return this;
    }
    @Override
    PubsubIO.Read.Builder<T> setIdAttribute(@Nullable String idAttribute) {
      this.idAttribute = idAttribute;
      return this;
    }
    @Override
    PubsubIO.Read.Builder<T> setCoder(@Nullable Coder<T> coder) {
      this.coder = coder;
      return this;
    }
    @Override
    PubsubIO.Read.Builder<T> setParseFn(@Nullable SimpleFunction<PubsubMessage, T> parseFn) {
      this.parseFn = parseFn;
      return this;
    }
    @Override
    PubsubIO.Read.Builder<T> setNeedsAttributes(boolean needsAttributes) {
      this.needsAttributes = needsAttributes;
      return this;
    }
    @Override
    PubsubIO.Read<T> build() {
      String missing = "";
      if (this.needsAttributes == null) {
        missing += " needsAttributes";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PubsubIO_Read<T>(
          this.topicProvider,
          this.subscriptionProvider,
          this.timestampAttribute,
          this.idAttribute,
          this.coder,
          this.parseFn,
          this.needsAttributes);
    }
  }

}
