
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Query;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.apache.beam.sdk.options.ValueProvider;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_DatastoreV1_Read extends DatastoreV1.Read {

  private final ValueProvider<String> projectId;
  private final Query query;
  private final ValueProvider<String> literalGqlQuery;
  private final ValueProvider<String> namespace;
  private final int numQuerySplits;
  private final String localhost;

  private AutoValue_DatastoreV1_Read(
      @Nullable ValueProvider<String> projectId,
      @Nullable Query query,
      @Nullable ValueProvider<String> literalGqlQuery,
      @Nullable ValueProvider<String> namespace,
      int numQuerySplits,
      @Nullable String localhost) {
    this.projectId = projectId;
    this.query = query;
    this.literalGqlQuery = literalGqlQuery;
    this.namespace = namespace;
    this.numQuerySplits = numQuerySplits;
    this.localhost = localhost;
  }

  @Nullable
  @Override
  public ValueProvider<String> getProjectId() {
    return projectId;
  }

  @Nullable
  @Override
  public Query getQuery() {
    return query;
  }

  @Nullable
  @Override
  public ValueProvider<String> getLiteralGqlQuery() {
    return literalGqlQuery;
  }

  @Nullable
  @Override
  public ValueProvider<String> getNamespace() {
    return namespace;
  }

  @Override
  public int getNumQuerySplits() {
    return numQuerySplits;
  }

  @Nullable
  @Override
  public String getLocalhost() {
    return localhost;
  }

  @Override
  public String toString() {
    return "Read{"
        + "projectId=" + projectId + ", "
        + "query=" + query + ", "
        + "literalGqlQuery=" + literalGqlQuery + ", "
        + "namespace=" + namespace + ", "
        + "numQuerySplits=" + numQuerySplits + ", "
        + "localhost=" + localhost
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DatastoreV1.Read) {
      DatastoreV1.Read that = (DatastoreV1.Read) o;
      return ((this.projectId == null) ? (that.getProjectId() == null) : this.projectId.equals(that.getProjectId()))
           && ((this.query == null) ? (that.getQuery() == null) : this.query.equals(that.getQuery()))
           && ((this.literalGqlQuery == null) ? (that.getLiteralGqlQuery() == null) : this.literalGqlQuery.equals(that.getLiteralGqlQuery()))
           && ((this.namespace == null) ? (that.getNamespace() == null) : this.namespace.equals(that.getNamespace()))
           && (this.numQuerySplits == that.getNumQuerySplits())
           && ((this.localhost == null) ? (that.getLocalhost() == null) : this.localhost.equals(that.getLocalhost()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (projectId == null) ? 0 : this.projectId.hashCode();
    h *= 1000003;
    h ^= (query == null) ? 0 : this.query.hashCode();
    h *= 1000003;
    h ^= (literalGqlQuery == null) ? 0 : this.literalGqlQuery.hashCode();
    h *= 1000003;
    h ^= (namespace == null) ? 0 : this.namespace.hashCode();
    h *= 1000003;
    h ^= this.numQuerySplits;
    h *= 1000003;
    h ^= (localhost == null) ? 0 : this.localhost.hashCode();
    return h;
  }

  @Override
  DatastoreV1.Read.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends DatastoreV1.Read.Builder {
    private ValueProvider<String> projectId;
    private Query query;
    private ValueProvider<String> literalGqlQuery;
    private ValueProvider<String> namespace;
    private Integer numQuerySplits;
    private String localhost;
    Builder() {
    }
    private Builder(DatastoreV1.Read source) {
      this.projectId = source.getProjectId();
      this.query = source.getQuery();
      this.literalGqlQuery = source.getLiteralGqlQuery();
      this.namespace = source.getNamespace();
      this.numQuerySplits = source.getNumQuerySplits();
      this.localhost = source.getLocalhost();
    }
    @Override
    DatastoreV1.Read.Builder setProjectId(@Nullable ValueProvider<String> projectId) {
      this.projectId = projectId;
      return this;
    }
    @Override
    DatastoreV1.Read.Builder setQuery(@Nullable Query query) {
      this.query = query;
      return this;
    }
    @Override
    DatastoreV1.Read.Builder setLiteralGqlQuery(@Nullable ValueProvider<String> literalGqlQuery) {
      this.literalGqlQuery = literalGqlQuery;
      return this;
    }
    @Override
    DatastoreV1.Read.Builder setNamespace(@Nullable ValueProvider<String> namespace) {
      this.namespace = namespace;
      return this;
    }
    @Override
    DatastoreV1.Read.Builder setNumQuerySplits(int numQuerySplits) {
      this.numQuerySplits = numQuerySplits;
      return this;
    }
    @Override
    DatastoreV1.Read.Builder setLocalhost(@Nullable String localhost) {
      this.localhost = localhost;
      return this;
    }
    @Override
    DatastoreV1.Read build() {
      String missing = "";
      if (this.numQuerySplits == null) {
        missing += " numQuerySplits";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DatastoreV1_Read(
          this.projectId,
          this.query,
          this.literalGqlQuery,
          this.namespace,
          this.numQuerySplits,
          this.localhost);
    }
  }

}
