
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_BigQueryIO_Write<T> extends BigQueryIO.Write<T> {

  private final ValueProvider<String> jsonTableRef;
  private final SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction;
  private final SerializableFunction<T, TableRow> formatFunction;
  private final DynamicDestinations<T, ?> dynamicDestinations;
  private final PCollectionView<Map<String, String>> schemaFromView;
  private final ValueProvider<String> jsonSchema;
  private final ValueProvider<String> jsonTimePartitioning;
  private final BigQueryIO.Write.CreateDisposition createDisposition;
  private final BigQueryIO.Write.WriteDisposition writeDisposition;
  private final String tableDescription;
  private final boolean validate;
  private final BigQueryServices bigQueryServices;
  private final Integer maxFilesPerBundle;
  private final Long maxFileSize;
  private final int numFileShards;
  private final Duration triggeringFrequency;
  private final BigQueryIO.Write.Method method;
  private final InsertRetryPolicy failedInsertRetryPolicy;
  private final ValueProvider<String> customGcsTempLocation;

  private AutoValue_BigQueryIO_Write(
      @Nullable ValueProvider<String> jsonTableRef,
      @Nullable SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction,
      @Nullable SerializableFunction<T, TableRow> formatFunction,
      @Nullable DynamicDestinations<T, ?> dynamicDestinations,
      @Nullable PCollectionView<Map<String, String>> schemaFromView,
      @Nullable ValueProvider<String> jsonSchema,
      @Nullable ValueProvider<String> jsonTimePartitioning,
      BigQueryIO.Write.CreateDisposition createDisposition,
      BigQueryIO.Write.WriteDisposition writeDisposition,
      @Nullable String tableDescription,
      boolean validate,
      BigQueryServices bigQueryServices,
      @Nullable Integer maxFilesPerBundle,
      @Nullable Long maxFileSize,
      int numFileShards,
      @Nullable Duration triggeringFrequency,
      BigQueryIO.Write.Method method,
      @Nullable InsertRetryPolicy failedInsertRetryPolicy,
      @Nullable ValueProvider<String> customGcsTempLocation) {
    this.jsonTableRef = jsonTableRef;
    this.tableFunction = tableFunction;
    this.formatFunction = formatFunction;
    this.dynamicDestinations = dynamicDestinations;
    this.schemaFromView = schemaFromView;
    this.jsonSchema = jsonSchema;
    this.jsonTimePartitioning = jsonTimePartitioning;
    this.createDisposition = createDisposition;
    this.writeDisposition = writeDisposition;
    this.tableDescription = tableDescription;
    this.validate = validate;
    this.bigQueryServices = bigQueryServices;
    this.maxFilesPerBundle = maxFilesPerBundle;
    this.maxFileSize = maxFileSize;
    this.numFileShards = numFileShards;
    this.triggeringFrequency = triggeringFrequency;
    this.method = method;
    this.failedInsertRetryPolicy = failedInsertRetryPolicy;
    this.customGcsTempLocation = customGcsTempLocation;
  }

  @Nullable
  @Override
  ValueProvider<String> getJsonTableRef() {
    return jsonTableRef;
  }

  @Nullable
  @Override
  SerializableFunction<ValueInSingleWindow<T>, TableDestination> getTableFunction() {
    return tableFunction;
  }

  @Nullable
  @Override
  SerializableFunction<T, TableRow> getFormatFunction() {
    return formatFunction;
  }

  @Nullable
  @Override
  DynamicDestinations<T, ?> getDynamicDestinations() {
    return dynamicDestinations;
  }

  @Nullable
  @Override
  PCollectionView<Map<String, String>> getSchemaFromView() {
    return schemaFromView;
  }

  @Nullable
  @Override
  ValueProvider<String> getJsonSchema() {
    return jsonSchema;
  }

  @Nullable
  @Override
  ValueProvider<String> getJsonTimePartitioning() {
    return jsonTimePartitioning;
  }

  @Override
  BigQueryIO.Write.CreateDisposition getCreateDisposition() {
    return createDisposition;
  }

  @Override
  BigQueryIO.Write.WriteDisposition getWriteDisposition() {
    return writeDisposition;
  }

  @Nullable
  @Override
  String getTableDescription() {
    return tableDescription;
  }

  @Override
  boolean getValidate() {
    return validate;
  }

  @Override
  BigQueryServices getBigQueryServices() {
    return bigQueryServices;
  }

  @Nullable
  @Override
  Integer getMaxFilesPerBundle() {
    return maxFilesPerBundle;
  }

  @Nullable
  @Override
  Long getMaxFileSize() {
    return maxFileSize;
  }

  @Override
  int getNumFileShards() {
    return numFileShards;
  }

  @Nullable
  @Override
  Duration getTriggeringFrequency() {
    return triggeringFrequency;
  }

  @Override
  BigQueryIO.Write.Method getMethod() {
    return method;
  }

  @Nullable
  @Override
  InsertRetryPolicy getFailedInsertRetryPolicy() {
    return failedInsertRetryPolicy;
  }

  @Nullable
  @Override
  ValueProvider<String> getCustomGcsTempLocation() {
    return customGcsTempLocation;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BigQueryIO.Write) {
      BigQueryIO.Write<?> that = (BigQueryIO.Write<?>) o;
      return ((this.jsonTableRef == null) ? (that.getJsonTableRef() == null) : this.jsonTableRef.equals(that.getJsonTableRef()))
           && ((this.tableFunction == null) ? (that.getTableFunction() == null) : this.tableFunction.equals(that.getTableFunction()))
           && ((this.formatFunction == null) ? (that.getFormatFunction() == null) : this.formatFunction.equals(that.getFormatFunction()))
           && ((this.dynamicDestinations == null) ? (that.getDynamicDestinations() == null) : this.dynamicDestinations.equals(that.getDynamicDestinations()))
           && ((this.schemaFromView == null) ? (that.getSchemaFromView() == null) : this.schemaFromView.equals(that.getSchemaFromView()))
           && ((this.jsonSchema == null) ? (that.getJsonSchema() == null) : this.jsonSchema.equals(that.getJsonSchema()))
           && ((this.jsonTimePartitioning == null) ? (that.getJsonTimePartitioning() == null) : this.jsonTimePartitioning.equals(that.getJsonTimePartitioning()))
           && (this.createDisposition.equals(that.getCreateDisposition()))
           && (this.writeDisposition.equals(that.getWriteDisposition()))
           && ((this.tableDescription == null) ? (that.getTableDescription() == null) : this.tableDescription.equals(that.getTableDescription()))
           && (this.validate == that.getValidate())
           && (this.bigQueryServices.equals(that.getBigQueryServices()))
           && ((this.maxFilesPerBundle == null) ? (that.getMaxFilesPerBundle() == null) : this.maxFilesPerBundle.equals(that.getMaxFilesPerBundle()))
           && ((this.maxFileSize == null) ? (that.getMaxFileSize() == null) : this.maxFileSize.equals(that.getMaxFileSize()))
           && (this.numFileShards == that.getNumFileShards())
           && ((this.triggeringFrequency == null) ? (that.getTriggeringFrequency() == null) : this.triggeringFrequency.equals(that.getTriggeringFrequency()))
           && (this.method.equals(that.getMethod()))
           && ((this.failedInsertRetryPolicy == null) ? (that.getFailedInsertRetryPolicy() == null) : this.failedInsertRetryPolicy.equals(that.getFailedInsertRetryPolicy()))
           && ((this.customGcsTempLocation == null) ? (that.getCustomGcsTempLocation() == null) : this.customGcsTempLocation.equals(that.getCustomGcsTempLocation()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (jsonTableRef == null) ? 0 : this.jsonTableRef.hashCode();
    h *= 1000003;
    h ^= (tableFunction == null) ? 0 : this.tableFunction.hashCode();
    h *= 1000003;
    h ^= (formatFunction == null) ? 0 : this.formatFunction.hashCode();
    h *= 1000003;
    h ^= (dynamicDestinations == null) ? 0 : this.dynamicDestinations.hashCode();
    h *= 1000003;
    h ^= (schemaFromView == null) ? 0 : this.schemaFromView.hashCode();
    h *= 1000003;
    h ^= (jsonSchema == null) ? 0 : this.jsonSchema.hashCode();
    h *= 1000003;
    h ^= (jsonTimePartitioning == null) ? 0 : this.jsonTimePartitioning.hashCode();
    h *= 1000003;
    h ^= this.createDisposition.hashCode();
    h *= 1000003;
    h ^= this.writeDisposition.hashCode();
    h *= 1000003;
    h ^= (tableDescription == null) ? 0 : this.tableDescription.hashCode();
    h *= 1000003;
    h ^= this.validate ? 1231 : 1237;
    h *= 1000003;
    h ^= this.bigQueryServices.hashCode();
    h *= 1000003;
    h ^= (maxFilesPerBundle == null) ? 0 : this.maxFilesPerBundle.hashCode();
    h *= 1000003;
    h ^= (maxFileSize == null) ? 0 : this.maxFileSize.hashCode();
    h *= 1000003;
    h ^= this.numFileShards;
    h *= 1000003;
    h ^= (triggeringFrequency == null) ? 0 : this.triggeringFrequency.hashCode();
    h *= 1000003;
    h ^= this.method.hashCode();
    h *= 1000003;
    h ^= (failedInsertRetryPolicy == null) ? 0 : this.failedInsertRetryPolicy.hashCode();
    h *= 1000003;
    h ^= (customGcsTempLocation == null) ? 0 : this.customGcsTempLocation.hashCode();
    return h;
  }

  @Override
  BigQueryIO.Write.Builder<T> toBuilder() {
    return new Builder<T>(this);
  }

  static final class Builder<T> extends BigQueryIO.Write.Builder<T> {
    private ValueProvider<String> jsonTableRef;
    private SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction;
    private SerializableFunction<T, TableRow> formatFunction;
    private DynamicDestinations<T, ?> dynamicDestinations;
    private PCollectionView<Map<String, String>> schemaFromView;
    private ValueProvider<String> jsonSchema;
    private ValueProvider<String> jsonTimePartitioning;
    private BigQueryIO.Write.CreateDisposition createDisposition;
    private BigQueryIO.Write.WriteDisposition writeDisposition;
    private String tableDescription;
    private Boolean validate;
    private BigQueryServices bigQueryServices;
    private Integer maxFilesPerBundle;
    private Long maxFileSize;
    private Integer numFileShards;
    private Duration triggeringFrequency;
    private BigQueryIO.Write.Method method;
    private InsertRetryPolicy failedInsertRetryPolicy;
    private ValueProvider<String> customGcsTempLocation;
    Builder() {
    }
    private Builder(BigQueryIO.Write<T> source) {
      this.jsonTableRef = source.getJsonTableRef();
      this.tableFunction = source.getTableFunction();
      this.formatFunction = source.getFormatFunction();
      this.dynamicDestinations = source.getDynamicDestinations();
      this.schemaFromView = source.getSchemaFromView();
      this.jsonSchema = source.getJsonSchema();
      this.jsonTimePartitioning = source.getJsonTimePartitioning();
      this.createDisposition = source.getCreateDisposition();
      this.writeDisposition = source.getWriteDisposition();
      this.tableDescription = source.getTableDescription();
      this.validate = source.getValidate();
      this.bigQueryServices = source.getBigQueryServices();
      this.maxFilesPerBundle = source.getMaxFilesPerBundle();
      this.maxFileSize = source.getMaxFileSize();
      this.numFileShards = source.getNumFileShards();
      this.triggeringFrequency = source.getTriggeringFrequency();
      this.method = source.getMethod();
      this.failedInsertRetryPolicy = source.getFailedInsertRetryPolicy();
      this.customGcsTempLocation = source.getCustomGcsTempLocation();
    }
    @Override
    BigQueryIO.Write.Builder<T> setJsonTableRef(@Nullable ValueProvider<String> jsonTableRef) {
      this.jsonTableRef = jsonTableRef;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setTableFunction(@Nullable SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction) {
      this.tableFunction = tableFunction;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setFormatFunction(@Nullable SerializableFunction<T, TableRow> formatFunction) {
      this.formatFunction = formatFunction;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setDynamicDestinations(@Nullable DynamicDestinations<T, ?> dynamicDestinations) {
      this.dynamicDestinations = dynamicDestinations;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setSchemaFromView(@Nullable PCollectionView<Map<String, String>> schemaFromView) {
      this.schemaFromView = schemaFromView;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setJsonSchema(@Nullable ValueProvider<String> jsonSchema) {
      this.jsonSchema = jsonSchema;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setJsonTimePartitioning(@Nullable ValueProvider<String> jsonTimePartitioning) {
      this.jsonTimePartitioning = jsonTimePartitioning;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setCreateDisposition(BigQueryIO.Write.CreateDisposition createDisposition) {
      if (createDisposition == null) {
        throw new NullPointerException("Null createDisposition");
      }
      this.createDisposition = createDisposition;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setWriteDisposition(BigQueryIO.Write.WriteDisposition writeDisposition) {
      if (writeDisposition == null) {
        throw new NullPointerException("Null writeDisposition");
      }
      this.writeDisposition = writeDisposition;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setTableDescription(@Nullable String tableDescription) {
      this.tableDescription = tableDescription;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setValidate(boolean validate) {
      this.validate = validate;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setBigQueryServices(BigQueryServices bigQueryServices) {
      if (bigQueryServices == null) {
        throw new NullPointerException("Null bigQueryServices");
      }
      this.bigQueryServices = bigQueryServices;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setMaxFilesPerBundle(@Nullable Integer maxFilesPerBundle) {
      this.maxFilesPerBundle = maxFilesPerBundle;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setMaxFileSize(@Nullable Long maxFileSize) {
      this.maxFileSize = maxFileSize;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setNumFileShards(int numFileShards) {
      this.numFileShards = numFileShards;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setTriggeringFrequency(@Nullable Duration triggeringFrequency) {
      this.triggeringFrequency = triggeringFrequency;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setMethod(BigQueryIO.Write.Method method) {
      if (method == null) {
        throw new NullPointerException("Null method");
      }
      this.method = method;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setFailedInsertRetryPolicy(@Nullable InsertRetryPolicy failedInsertRetryPolicy) {
      this.failedInsertRetryPolicy = failedInsertRetryPolicy;
      return this;
    }
    @Override
    BigQueryIO.Write.Builder<T> setCustomGcsTempLocation(@Nullable ValueProvider<String> customGcsTempLocation) {
      this.customGcsTempLocation = customGcsTempLocation;
      return this;
    }
    @Override
    BigQueryIO.Write<T> build() {
      String missing = "";
      if (this.createDisposition == null) {
        missing += " createDisposition";
      }
      if (this.writeDisposition == null) {
        missing += " writeDisposition";
      }
      if (this.validate == null) {
        missing += " validate";
      }
      if (this.bigQueryServices == null) {
        missing += " bigQueryServices";
      }
      if (this.numFileShards == null) {
        missing += " numFileShards";
      }
      if (this.method == null) {
        missing += " method";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BigQueryIO_Write<T>(
          this.jsonTableRef,
          this.tableFunction,
          this.formatFunction,
          this.dynamicDestinations,
          this.schemaFromView,
          this.jsonSchema,
          this.jsonTimePartitioning,
          this.createDisposition,
          this.writeDisposition,
          this.tableDescription,
          this.validate,
          this.bigQueryServices,
          this.maxFilesPerBundle,
          this.maxFileSize,
          this.numFileShards,
          this.triggeringFrequency,
          this.method,
          this.failedInsertRetryPolicy,
          this.customGcsTempLocation);
    }
  }

}
