
package org.apache.beam.sdk.io.gcp.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_BigQueryIO_TypedRead<T> extends BigQueryIO.TypedRead<T> {

  private final ValueProvider<String> jsonTableRef;
  private final ValueProvider<String> query;
  private final boolean validate;
  private final Boolean flattenResults;
  private final Boolean useLegacySql;
  private final Boolean withTemplateCompatibility;
  private final BigQueryServices bigQueryServices;
  private final SerializableFunction<SchemaAndRecord, T> parseFn;
  private final Coder<T> coder;

  private AutoValue_BigQueryIO_TypedRead(
      @Nullable ValueProvider<String> jsonTableRef,
      @Nullable ValueProvider<String> query,
      boolean validate,
      @Nullable Boolean flattenResults,
      @Nullable Boolean useLegacySql,
      Boolean withTemplateCompatibility,
      BigQueryServices bigQueryServices,
      SerializableFunction<SchemaAndRecord, T> parseFn,
      @Nullable Coder<T> coder) {
    this.jsonTableRef = jsonTableRef;
    this.query = query;
    this.validate = validate;
    this.flattenResults = flattenResults;
    this.useLegacySql = useLegacySql;
    this.withTemplateCompatibility = withTemplateCompatibility;
    this.bigQueryServices = bigQueryServices;
    this.parseFn = parseFn;
    this.coder = coder;
  }

  @Nullable
  @Override
  ValueProvider<String> getJsonTableRef() {
    return jsonTableRef;
  }

  @Nullable
  @Override
  ValueProvider<String> getQuery() {
    return query;
  }

  @Override
  boolean getValidate() {
    return validate;
  }

  @Nullable
  @Override
  Boolean getFlattenResults() {
    return flattenResults;
  }

  @Nullable
  @Override
  Boolean getUseLegacySql() {
    return useLegacySql;
  }

  @Override
  Boolean getWithTemplateCompatibility() {
    return withTemplateCompatibility;
  }

  @Override
  BigQueryServices getBigQueryServices() {
    return bigQueryServices;
  }

  @Override
  SerializableFunction<SchemaAndRecord, T> getParseFn() {
    return parseFn;
  }

  @Nullable
  @Override
  Coder<T> getCoder() {
    return coder;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BigQueryIO.TypedRead) {
      BigQueryIO.TypedRead<?> that = (BigQueryIO.TypedRead<?>) o;
      return ((this.jsonTableRef == null) ? (that.getJsonTableRef() == null) : this.jsonTableRef.equals(that.getJsonTableRef()))
           && ((this.query == null) ? (that.getQuery() == null) : this.query.equals(that.getQuery()))
           && (this.validate == that.getValidate())
           && ((this.flattenResults == null) ? (that.getFlattenResults() == null) : this.flattenResults.equals(that.getFlattenResults()))
           && ((this.useLegacySql == null) ? (that.getUseLegacySql() == null) : this.useLegacySql.equals(that.getUseLegacySql()))
           && (this.withTemplateCompatibility.equals(that.getWithTemplateCompatibility()))
           && (this.bigQueryServices.equals(that.getBigQueryServices()))
           && (this.parseFn.equals(that.getParseFn()))
           && ((this.coder == null) ? (that.getCoder() == null) : this.coder.equals(that.getCoder()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (jsonTableRef == null) ? 0 : this.jsonTableRef.hashCode();
    h *= 1000003;
    h ^= (query == null) ? 0 : this.query.hashCode();
    h *= 1000003;
    h ^= this.validate ? 1231 : 1237;
    h *= 1000003;
    h ^= (flattenResults == null) ? 0 : this.flattenResults.hashCode();
    h *= 1000003;
    h ^= (useLegacySql == null) ? 0 : this.useLegacySql.hashCode();
    h *= 1000003;
    h ^= this.withTemplateCompatibility.hashCode();
    h *= 1000003;
    h ^= this.bigQueryServices.hashCode();
    h *= 1000003;
    h ^= this.parseFn.hashCode();
    h *= 1000003;
    h ^= (coder == null) ? 0 : this.coder.hashCode();
    return h;
  }

  @Override
  BigQueryIO.TypedRead.Builder<T> toBuilder() {
    return new Builder<T>(this);
  }

  static final class Builder<T> extends BigQueryIO.TypedRead.Builder<T> {
    private ValueProvider<String> jsonTableRef;
    private ValueProvider<String> query;
    private Boolean validate;
    private Boolean flattenResults;
    private Boolean useLegacySql;
    private Boolean withTemplateCompatibility;
    private BigQueryServices bigQueryServices;
    private SerializableFunction<SchemaAndRecord, T> parseFn;
    private Coder<T> coder;
    Builder() {
    }
    private Builder(BigQueryIO.TypedRead<T> source) {
      this.jsonTableRef = source.getJsonTableRef();
      this.query = source.getQuery();
      this.validate = source.getValidate();
      this.flattenResults = source.getFlattenResults();
      this.useLegacySql = source.getUseLegacySql();
      this.withTemplateCompatibility = source.getWithTemplateCompatibility();
      this.bigQueryServices = source.getBigQueryServices();
      this.parseFn = source.getParseFn();
      this.coder = source.getCoder();
    }
    @Override
    BigQueryIO.TypedRead.Builder<T> setJsonTableRef(@Nullable ValueProvider<String> jsonTableRef) {
      this.jsonTableRef = jsonTableRef;
      return this;
    }
    @Override
    BigQueryIO.TypedRead.Builder<T> setQuery(@Nullable ValueProvider<String> query) {
      this.query = query;
      return this;
    }
    @Override
    BigQueryIO.TypedRead.Builder<T> setValidate(boolean validate) {
      this.validate = validate;
      return this;
    }
    @Override
    BigQueryIO.TypedRead.Builder<T> setFlattenResults(@Nullable Boolean flattenResults) {
      this.flattenResults = flattenResults;
      return this;
    }
    @Override
    BigQueryIO.TypedRead.Builder<T> setUseLegacySql(@Nullable Boolean useLegacySql) {
      this.useLegacySql = useLegacySql;
      return this;
    }
    @Override
    BigQueryIO.TypedRead.Builder<T> setWithTemplateCompatibility(Boolean withTemplateCompatibility) {
      if (withTemplateCompatibility == null) {
        throw new NullPointerException("Null withTemplateCompatibility");
      }
      this.withTemplateCompatibility = withTemplateCompatibility;
      return this;
    }
    @Override
    BigQueryIO.TypedRead.Builder<T> setBigQueryServices(BigQueryServices bigQueryServices) {
      if (bigQueryServices == null) {
        throw new NullPointerException("Null bigQueryServices");
      }
      this.bigQueryServices = bigQueryServices;
      return this;
    }
    @Override
    BigQueryIO.TypedRead.Builder<T> setParseFn(SerializableFunction<SchemaAndRecord, T> parseFn) {
      if (parseFn == null) {
        throw new NullPointerException("Null parseFn");
      }
      this.parseFn = parseFn;
      return this;
    }
    @Override
    BigQueryIO.TypedRead.Builder<T> setCoder(@Nullable Coder<T> coder) {
      this.coder = coder;
      return this;
    }
    @Override
    BigQueryIO.TypedRead<T> build() {
      String missing = "";
      if (this.validate == null) {
        missing += " validate";
      }
      if (this.withTemplateCompatibility == null) {
        missing += " withTemplateCompatibility";
      }
      if (this.bigQueryServices == null) {
        missing += " bigQueryServices";
      }
      if (this.parseFn == null) {
        missing += " parseFn";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BigQueryIO_TypedRead<T>(
          this.jsonTableRef,
          this.query,
          this.validate,
          this.flattenResults,
          this.useLegacySql,
          this.withTemplateCompatibility,
          this.bigQueryServices,
          this.parseFn,
          this.coder);
    }
  }

}
