/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import java.io.IOException;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BigqueryClient.class})
public class BigqueryClientTest {
    private final @UnknownKeyFor @NonNull @Initialized String projectId = "test-project";
    private final @UnknownKeyFor @NonNull @Initialized String query = "test-query";
    private @UnknownKeyFor @NonNull @Initialized BigqueryClient bqClient;
    @Rule
    public @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();
    @Mock
    private @UnknownKeyFor @NonNull @Initialized Bigquery mockBigqueryClient;
    @Mock
    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Bigquery. @UnknownKeyFor @NonNull @Initialized Jobs mockJobs;
    @Mock
    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Bigquery. @UnknownKeyFor @NonNull @Initialized Jobs. @UnknownKeyFor @NonNull @Initialized Query mockQuery;

    @Before
    public void setUp() throws @UnknownKeyFor @NonNull @Initialized IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockBigqueryClient.jobs()).thenReturn((Object)this.mockJobs);
        Mockito.when((Object)this.mockJobs.query(ArgumentMatchers.anyString(), (QueryRequest)Matchers.any(QueryRequest.class))).thenReturn((Object)this.mockQuery);
        PowerMockito.mockStatic(BigqueryClient.class, (Class[])new Class[0]);
        Mockito.when((Object)BigqueryClient.getNewBigquerryClient((String)ArgumentMatchers.anyString())).thenReturn((Object)this.mockBigqueryClient);
        this.bqClient = (BigqueryClient)Mockito.spy((Object)new BigqueryClient("test-app"));
    }

    @Test
    public void testQueryWithRetriesWhenServiceFails() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Mockito.when((Object)((QueryResponse)this.mockQuery.execute())).thenThrow(new Throwable[]{new IOException()});
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Unable to get BigQuery response after retrying");
        try {
            this.bqClient.queryWithRetries("test-query", "test-project");
        }
        finally {
            ((Bigquery.Jobs)Mockito.verify((Object)this.mockJobs, (VerificationMode)Mockito.atLeast((int)4))).query((String)Matchers.eq((Object)"test-project"), (QueryRequest)Matchers.any(QueryRequest.class));
        }
    }

    @Test
    public void testQueryWithRetriesWhenQueryResponseNull() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Mockito.when((Object)((QueryResponse)this.mockQuery.execute())).thenReturn(null);
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Unable to get BigQuery response after retrying");
        try {
            this.bqClient.queryWithRetries("test-query", "test-project");
        }
        finally {
            ((Bigquery.Jobs)Mockito.verify((Object)this.mockJobs, (VerificationMode)Mockito.atLeast((int)4))).query((String)Matchers.eq((Object)"test-project"), (QueryRequest)Matchers.any(QueryRequest.class));
        }
    }
}

