/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerSchemaTest {
    @Test
    public void testSingleTable() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema schema = SpannerSchema.builder().addColumn("test", "pk", "STRING(48)").addKeyPart("test", "pk", false).addColumn("test", "maxKey", "STRING(MAX)").addColumn("test", "numericVal", "NUMERIC").build();
        Assert.assertEquals((long)1L, (long)schema.getTables().size());
        Assert.assertEquals((long)3L, (long)schema.getColumns("test").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("test").size());
    }

    @Test
    public void testTwoTables() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema schema = SpannerSchema.builder().addColumn("test", "pk", "STRING(48)").addKeyPart("test", "pk", false).addColumn("test", "maxKey", "STRING(MAX)").addColumn("other", "pk", "INT64").addKeyPart("other", "pk", true).addColumn("other", "maxKey", "STRING(MAX)").build();
        Assert.assertEquals((long)2L, (long)schema.getTables().size());
        Assert.assertEquals((long)2L, (long)schema.getColumns("test").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("test").size());
        Assert.assertEquals((long)2L, (long)schema.getColumns("other").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("other").size());
    }
}

