/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.gcp.spanner.MutationUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class MutationUtilsTest {
    private static final @UnknownKeyFor @NonNull @Initialized Schema EMPTY_SCHEMA = Schema.builder().build();
    private static final @UnknownKeyFor @NonNull @Initialized Schema INT64_SCHEMA = Schema.builder().addInt64Field("int64").build();
    private static final @UnknownKeyFor @NonNull @Initialized Row EMPTY_ROW = Row.withSchema((Schema)EMPTY_SCHEMA).build();
    private static final @UnknownKeyFor @NonNull @Initialized Row INT64_ROW = Row.withSchema((Schema)INT64_SCHEMA).withFieldValue("int64", (Object)3L).build();
    private static final @UnknownKeyFor @NonNull @Initialized Struct EMPTY_STRUCT = Struct.newBuilder().build();
    private static final @UnknownKeyFor @NonNull @Initialized Struct INT64_STRUCT = ((Struct.Builder)Struct.newBuilder().set("int64").to(3L)).build();
    private static final @UnknownKeyFor @NonNull @Initialized String TABLE = "some_table";
    private static final @UnknownKeyFor @NonNull @Initialized Schema WRITE_ROW_SCHEMA = Schema.builder().addNullableField("f_int64", Schema.FieldType.INT64).addNullableField("f_float64", Schema.FieldType.DOUBLE).addNullableField("f_string", Schema.FieldType.STRING).addNullableField("f_bytes", Schema.FieldType.BYTES).addNullableField("f_date_time", Schema.FieldType.DATETIME).addNullableField("f_bool", Schema.FieldType.BOOLEAN).addNullableField("f_struct", Schema.FieldType.row((Schema)EMPTY_SCHEMA)).addNullableField("f_struct_int64", Schema.FieldType.row((Schema)INT64_SCHEMA)).addNullableField("f_array", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT64)).addNullableField("f_struct_array", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)INT64_SCHEMA))).build();
    private static final @UnknownKeyFor @NonNull @Initialized Row WRITE_ROW = Row.withSchema((Schema)WRITE_ROW_SCHEMA).withFieldValue("f_int64", (Object)1L).withFieldValue("f_float64", (Object)1.1).withFieldValue("f_string", (Object)"donald_duck").withFieldValue("f_bytes", (Object)"some_bytes".getBytes(StandardCharsets.UTF_8)).withFieldValue("f_date_time", (Object)DateTime.parse((String)"2077-10-15T00:00:00+00:00")).withFieldValue("f_bool", (Object)false).withFieldValue("f_struct", (Object)EMPTY_ROW).withFieldValue("f_struct_int64", (Object)INT64_ROW).withFieldValue("f_array", (Object)ImmutableList.of((Object)2L, (Object)3L)).withFieldValue("f_struct_array", (Object)ImmutableList.of((Object)INT64_ROW, (Object)INT64_ROW)).build();
    private static final @UnknownKeyFor @NonNull @Initialized Row WRITE_ROW_NULLS = Row.withSchema((Schema)WRITE_ROW_SCHEMA).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).build();
    private static final @UnknownKeyFor @NonNull @Initialized Schema KEY_SCHEMA = Schema.builder().addNullableField("f_int64", Schema.FieldType.INT64).addNullableField("f_float64", Schema.FieldType.DOUBLE).addNullableField("f_string", Schema.FieldType.STRING).addNullableField("f_bytes", Schema.FieldType.BYTES).addNullableField("f_date_time", Schema.FieldType.DATETIME).addNullableField("f_bool", Schema.FieldType.BOOLEAN).build();
    private static final @UnknownKeyFor @NonNull @Initialized Row KEY_ROW = Row.withSchema((Schema)KEY_SCHEMA).withFieldValue("f_int64", (Object)1L).withFieldValue("f_float64", (Object)1.1).withFieldValue("f_string", (Object)"donald_duck").withFieldValue("f_bytes", (Object)"some_bytes".getBytes(StandardCharsets.UTF_8)).withFieldValue("f_date_time", (Object)DateTime.parse((String)"2077-10-15T00:00:00+00:00")).withFieldValue("f_bool", (Object)false).build();
    private static final @UnknownKeyFor @NonNull @Initialized Row KEY_ROW_NULLS = Row.withSchema((Schema)KEY_SCHEMA).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).build();

    @Test
    public void testCreateInsertMutationFromRow() {
        Mutation expectedMutation = MutationUtilsTest.createMutation(Mutation.Op.INSERT);
        Mutation mutation = (Mutation)MutationUtils.beamRowToMutationFn((Mutation.Op)Mutation.Op.INSERT, (String)TABLE).apply((Object)WRITE_ROW);
        Assert.assertEquals((Object)expectedMutation, (Object)mutation);
    }

    @Test
    public void testCreateUpdateMutationFromRow() {
        Mutation expectedMutation = MutationUtilsTest.createMutation(Mutation.Op.UPDATE);
        Mutation mutation = (Mutation)MutationUtils.beamRowToMutationFn((Mutation.Op)Mutation.Op.UPDATE, (String)TABLE).apply((Object)WRITE_ROW);
        Assert.assertEquals((Object)expectedMutation, (Object)mutation);
    }

    @Test
    public void testCreateReplaceMutationFromRow() {
        Mutation expectedMutation = MutationUtilsTest.createMutation(Mutation.Op.REPLACE);
        Mutation mutation = (Mutation)MutationUtils.beamRowToMutationFn((Mutation.Op)Mutation.Op.REPLACE, (String)TABLE).apply((Object)WRITE_ROW);
        Assert.assertEquals((Object)expectedMutation, (Object)mutation);
    }

    @Test
    public void testCreateInsertOrUpdateMutationFromRow() {
        Mutation expectedMutation = MutationUtilsTest.createMutation(Mutation.Op.INSERT_OR_UPDATE);
        Mutation mutation = (Mutation)MutationUtils.beamRowToMutationFn((Mutation.Op)Mutation.Op.INSERT_OR_UPDATE, (String)TABLE).apply((Object)WRITE_ROW);
        Assert.assertEquals((Object)expectedMutation, (Object)mutation);
    }

    @Test
    public void testCreateDeleteMutationFromRow() {
        Mutation expectedMutation = MutationUtilsTest.createDeleteMutation();
        Mutation mutation = (Mutation)MutationUtils.beamRowToMutationFn((Mutation.Op)Mutation.Op.DELETE, (String)TABLE).apply((Object)KEY_ROW);
        Assert.assertEquals((Object)expectedMutation, (Object)mutation);
    }

    @Test
    public void testCreateInsertMutationFromRowWithNulls() {
        Mutation expectedMutation = MutationUtilsTest.createMutationNulls(Mutation.Op.INSERT);
        Mutation mutation = (Mutation)MutationUtils.beamRowToMutationFn((Mutation.Op)Mutation.Op.INSERT, (String)TABLE).apply((Object)WRITE_ROW_NULLS);
        Assert.assertEquals((Object)expectedMutation, (Object)mutation);
    }

    @Test
    public void testCreateInsertOrUpdateMutationFromRowWithNulls() {
        Mutation expectedMutation = MutationUtilsTest.createMutationNulls(Mutation.Op.INSERT_OR_UPDATE);
        Mutation mutation = (Mutation)MutationUtils.beamRowToMutationFn((Mutation.Op)Mutation.Op.INSERT_OR_UPDATE, (String)TABLE).apply((Object)WRITE_ROW_NULLS);
        Assert.assertEquals((Object)expectedMutation, (Object)mutation);
    }

    @Test
    public void testCreateUpdateMutationFromRowWithNulls() {
        Mutation expectedMutation = MutationUtilsTest.createMutationNulls(Mutation.Op.UPDATE);
        Mutation mutation = (Mutation)MutationUtils.beamRowToMutationFn((Mutation.Op)Mutation.Op.UPDATE, (String)TABLE).apply((Object)WRITE_ROW_NULLS);
        Assert.assertEquals((Object)expectedMutation, (Object)mutation);
    }

    @Test
    public void testCreateReplaceMutationFromRowWithNulls() {
        Mutation expectedMutation = MutationUtilsTest.createMutationNulls(Mutation.Op.REPLACE);
        Mutation mutation = (Mutation)MutationUtils.beamRowToMutationFn((Mutation.Op)Mutation.Op.REPLACE, (String)TABLE).apply((Object)WRITE_ROW_NULLS);
        Assert.assertEquals((Object)expectedMutation, (Object)mutation);
    }

    @Test
    public void testCreateDeleteMutationFromRowWithNulls() {
        Mutation expectedMutation = MutationUtilsTest.createDeleteMutationNulls();
        Mutation mutation = (Mutation)MutationUtils.beamRowToMutationFn((Mutation.Op)Mutation.Op.DELETE, (String)TABLE).apply((Object)KEY_ROW_NULLS);
        Assert.assertEquals((Object)expectedMutation, (Object)mutation);
    }

    private static @UnknownKeyFor @NonNull @Initialized Mutation createDeleteMutation() {
        Key key = Key.newBuilder().append(1L).append(1.1).append("donald_duck").append(ByteArray.copyFrom((byte[])"some_bytes".getBytes(StandardCharsets.UTF_8))).append(Timestamp.parseTimestamp((String)"2077-10-15T00:00:00")).append(Boolean.valueOf(false)).build();
        return Mutation.delete((String)TABLE, (Key)key);
    }

    private static @UnknownKeyFor @NonNull @Initialized Mutation createDeleteMutationNulls() {
        Key key = Key.newBuilder().append((Long)null).append((Double)null).append((String)null).append((ByteArray)null).append((Timestamp)null).append((Boolean)null).build();
        return Mutation.delete((String)TABLE, (Key)key);
    }

    private static @UnknownKeyFor @NonNull @Initialized Mutation createMutation(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Mutation.Op operation) {
        Mutation.WriteBuilder builder = MutationUtilsTest.chooseBuilder(operation);
        return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)builder.set("f_int64").to(1L)).set("f_float64").to(1.1)).set("f_string").to("donald_duck")).set("f_bytes").to(ByteArray.copyFrom((byte[])"some_bytes".getBytes(StandardCharsets.UTF_8)))).set("f_date_time").to(Timestamp.parseTimestamp((String)"2077-10-15T00:00:00"))).set("f_bool").to(false)).set("f_struct").to(EMPTY_STRUCT)).set("f_struct_int64").to(((Struct.Builder)Struct.newBuilder().set("int64").to(3L)).build())).set("f_array").toInt64Array((Iterable)ImmutableList.of((Object)2L, (Object)3L))).set("f_struct_array").toStructArray(Type.struct((Iterable)ImmutableList.of((Object)Type.StructField.of((String)"int64", (Type)Type.int64()))), (Iterable)ImmutableList.of((Object)INT64_STRUCT, (Object)INT64_STRUCT))).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Mutation createMutationNulls(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Mutation.Op operation) {
        Mutation.WriteBuilder builder = MutationUtilsTest.chooseBuilder(operation);
        return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)builder.set("f_int64").to((Long)null)).set("f_float64").to((Double)null)).set("f_string").to((String)null)).set("f_bytes").to((ByteArray)null)).set("f_date_time").to((Timestamp)null)).set("f_bool").to((Boolean)null)).set("f_struct").to(Type.struct((Type.StructField[])new Type.StructField[0]), null)).set("f_struct_int64").to(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"int64", (Type)Type.int64())}), null)).set("f_array").toInt64Array((Iterable)null)).set("f_struct_array").toStructArray(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"int64", (Type)Type.int64())}), null)).build();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Mutation.WriteBuilder chooseBuilder(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Mutation.Op op) {
        switch (op) {
            case INSERT: {
                return Mutation.newInsertBuilder((String)TABLE);
            }
            case UPDATE: {
                return Mutation.newUpdateBuilder((String)TABLE);
            }
            case REPLACE: {
                return Mutation.newReplaceBuilder((String)TABLE);
            }
            case INSERT_OR_UPDATE: {
                return Mutation.newInsertOrUpdateBuilder((String)TABLE);
            }
        }
        throw new IllegalArgumentException("Operation '" + op + "' not supported");
    }
}

