/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.io.gcp.spanner.MutationKeyEncoder;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.TreeMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.UnsignedBytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MutationKeyEncoderTest {
    @Rule
    public @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();

    @Test
    public void tableNameOrdering() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test1", "key", "INT64");
        builder.addKeyPart("test1", "key", false);
        builder.addColumn("test2", "key", "INT64");
        builder.addKeyPart("test2", "key", false);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test1").set("key").to(1L)).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test1").set("key").to(2L)).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test1").set("key").to((Long)null)).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test2").set("key").to(1L)).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test2").set("key").to(2L)).build());
        this.verifyEncodedOrdering(schema, sortedMutations);
    }

    @Test
    public void int64Keys() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "INT64");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "INT64");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(1L)).set("keydesc").to(0L)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2L)).set("keydesc").to((Long)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2L)).set("keydesc").to(10L)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2L)).set("keydesc").to(9L)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to((Long)null)).set("keydesc").to(0L)).build());
        this.verifyEncodedOrdering(schema, sortedMutations);
    }

    @Test
    public void float64Keys() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "FLOAT64");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "FLOAT64");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(1.0)).set("keydesc").to(0.0)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2.0)).set("keydesc").to((Long)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2.0)).set("keydesc").to(10.0)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2.0)).set("keydesc").to(9.0)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2.0)).set("keydesc").to(0.0)).build());
        this.verifyEncodedOrdering(schema, sortedMutations);
    }

    @Test
    public void stringKeys() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "STRING");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "STRING");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("a")).set("keydesc").to("bc")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("b")).set("keydesc").to((String)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("b")).set("keydesc").to("z")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("b")).set("keydesc").to("y")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("b")).set("keydesc").to("a")).build());
        this.verifyEncodedOrdering(schema, sortedMutations);
    }

    @Test
    public void bytesKeys() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "BYTES");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "BYTES");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(ByteArray.fromBase64((String)"abc"))).set("keydesc").to(ByteArray.fromBase64((String)"zzz"))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(ByteArray.fromBase64((String)"xxx"))).set("keydesc").to((ByteArray)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(ByteArray.fromBase64((String)"xxx"))).set("keydesc").to(ByteArray.fromBase64((String)"zzzz"))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(ByteArray.fromBase64((String)"xxx"))).set("keydesc").to(ByteArray.fromBase64((String)"ssss"))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(ByteArray.fromBase64((String)"xxx"))).set("keydesc").to(ByteArray.fromBase64((String)"aaa"))).build());
        this.verifyEncodedOrdering(schema, sortedMutations);
    }

    @Test
    public void dateKeys() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "DATE");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "DATE");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Date.fromYearMonthDay((int)2012, (int)10, (int)10))).set("keydesc").to(Date.fromYearMonthDay((int)2000, (int)10, (int)10))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Date.fromYearMonthDay((int)2020, (int)10, (int)10))).set("keydesc").to((Date)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Date.fromYearMonthDay((int)2020, (int)10, (int)10))).set("keydesc").to(Date.fromYearMonthDay((int)2050, (int)10, (int)10))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Date.fromYearMonthDay((int)2020, (int)10, (int)10))).set("keydesc").to(Date.fromYearMonthDay((int)2000, (int)10, (int)10))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Date.fromYearMonthDay((int)2020, (int)10, (int)10))).set("keydesc").to(Date.fromYearMonthDay((int)1900, (int)10, (int)10))).build());
        this.verifyEncodedOrdering(schema, sortedMutations);
    }

    @Test
    public void timestampKeys() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "TIMESTAMP");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "TIMESTAMP");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Timestamp.ofTimeMicroseconds((long)10000L))).set("keydesc").to(Timestamp.ofTimeMicroseconds((long)50000L))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Timestamp.ofTimeMicroseconds((long)20000L))).set("keydesc").to((Timestamp)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Timestamp.ofTimeMicroseconds((long)20000L))).set("keydesc").to(Timestamp.ofTimeMicroseconds((long)90000L))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Timestamp.ofTimeMicroseconds((long)20000L))).set("keydesc").to(Timestamp.ofTimeMicroseconds((long)50000L))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Timestamp.ofTimeMicroseconds((long)20000L))).set("keydesc").to(Timestamp.ofTimeMicroseconds((long)10000L))).build());
        this.verifyEncodedOrdering(schema, sortedMutations);
    }

    @Test
    public void boolKeys() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "boolkey", "BOOL");
        builder.addKeyPart("test", "boolkey", false);
        builder.addColumn("test", "boolkeydesc", "BOOL");
        builder.addKeyPart("test", "boolkeydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("boolkey").to(true)).set("boolkeydesc").to(false)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("boolkey").to(true)).set("boolkeydesc").to(true)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("boolkey").to(false)).set("boolkeydesc").to(false)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("boolkey").to(false)).set("boolkeydesc").to(true)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("boolkey").to((Boolean)null)).set("boolkeydesc").to(false)).build());
        this.verifyEncodedOrdering(schema, sortedMutations);
    }

    @Test
    public void unspecifiedStringKeys() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "STRING");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "STRING");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("a")).set("keydesc").to("b")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("a")).set("keydesc").to("a")).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("b")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("b")).set("keydesc").to("a")).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("keydesc").to("a")).build());
        this.verifyEncodedOrdering(schema, sortedMutations);
    }

    @Test
    public void deleteOrdering() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test1", "key", "INT64");
        builder.addKeyPart("test1", "key", false);
        builder.addColumn("test2", "key", "INT64");
        builder.addKeyPart("test2", "key", false);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(Mutation.delete((String)"test1", (KeySet)KeySet.all()), Mutation.delete((String)"test1", (Key)Key.of((Object[])new Object[]{1L})), Mutation.delete((String)"test1", (Key)Key.of((Object[])new Object[]{2L})), Mutation.delete((String)"test2", (KeySet)KeySet.prefixRange((Key)Key.of((Object[])new Object[]{1L}))), Mutation.delete((String)"test2", (Key)Key.of((Object[])new Object[]{2L})));
        this.verifyEncodedOrdering(schema, sortedMutations);
    }

    @Test
    public void unknownTableOrdering() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test1", "key", "INT64");
        builder.addKeyPart("test1", "key", false);
        SpannerSchema schema = builder.build();
        List<Mutation> sortedMutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test2").set("key").to("a")).set("keydesc").to("a")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test2").set("key").to("a")).set("keydesc").to("b")).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test3").set("key").to("b")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test4").set("key").to("b")).set("keydesc").to("a")).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test4").set("keydesc").to("a")).build());
        this.verifyEncodedOrdering(schema, sortedMutations);
        Assert.assertEquals((long)3L, (long)MutationKeyEncoder.getUnknownTablesWarningsMap().size());
        Assert.assertEquals((long)2L, (long)((AtomicInteger)MutationKeyEncoder.getUnknownTablesWarningsMap().get("test2")).get());
        Assert.assertEquals((long)1L, (long)((AtomicInteger)MutationKeyEncoder.getUnknownTablesWarningsMap().get("test3")).get());
        Assert.assertEquals((long)2L, (long)((AtomicInteger)MutationKeyEncoder.getUnknownTablesWarningsMap().get("test4")).get());
    }

    private void verifyEncodedOrdering(@UnknownKeyFor @NonNull @Initialized SpannerSchema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Mutation> expectedMutations) {
        MutationKeyEncoder encoder = new MutationKeyEncoder(schema);
        Assert.assertEquals((long)5L, (long)expectedMutations.size());
        List<Mutation> unsortedMutations = Arrays.asList(expectedMutations.get(3), expectedMutations.get(4), expectedMutations.get(1), expectedMutations.get(2), expectedMutations.get(0));
        TreeMultimap mutationsByEncoding = TreeMultimap.create((Comparator)UnsignedBytes.lexicographicalComparator(), Comparator.comparing(Mutation::toString));
        for (Mutation m : unsortedMutations) {
            mutationsByEncoding.put((Object)encoder.encodeTableNameAndKey(m), (Object)m);
        }
        Assert.assertEquals(expectedMutations, new ArrayList(mutationsByEncoding.values()));
    }
}

