/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;

class FakeServiceFactory
implements ServiceFactory<Spanner, SpannerOptions>,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Object lock = new Object();
    @GuardedBy(value="lock")
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Spanner> mockSpanners = new ArrayList<Spanner>();
    @GuardedBy(value="lock")
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DatabaseClient> mockDatabaseClients = new ArrayList<DatabaseClient>();
    @GuardedBy(value="lock")
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BatchClient> mockBatchClients = new ArrayList<BatchClient>();
    @GuardedBy(value="lock")
    private static @UnknownKeyFor @NonNull @Initialized int count = 0;
    private final @UnknownKeyFor @NonNull @Initialized int index;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FakeServiceFactory() {
        Object object = lock;
        synchronized (object) {
            this.index = count++;
            mockSpanners.add((Spanner)Mockito.mock(Spanner.class, (MockSettings)Mockito.withSettings().serializable()));
            mockDatabaseClients.add((DatabaseClient)Mockito.mock(DatabaseClient.class, (MockSettings)Mockito.withSettings().serializable()));
            mockBatchClients.add((BatchClient)Mockito.mock(BatchClient.class, (MockSettings)Mockito.withSettings().serializable()));
        }
        Mockito.when((Object)this.mockSpanner().getDatabaseClient((DatabaseId)Matchers.any(DatabaseId.class))).thenReturn((Object)this.mockDatabaseClient());
        Mockito.when((Object)this.mockSpanner().getBatchClient((DatabaseId)Matchers.any(DatabaseId.class))).thenReturn((Object)this.mockBatchClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnknownKeyFor @NonNull @Initialized DatabaseClient mockDatabaseClient() {
        Object object = lock;
        synchronized (object) {
            return mockDatabaseClients.get(this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnknownKeyFor @NonNull @Initialized BatchClient mockBatchClient() {
        Object object = lock;
        synchronized (object) {
            return mockBatchClients.get(this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnknownKeyFor @NonNull @Initialized Spanner mockSpanner() {
        Object object = lock;
        synchronized (object) {
            return mockSpanners.get(this.index);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Spanner create(@UnknownKeyFor @NonNull @Initialized SpannerOptions serviceOptions) {
        return this.mockSpanner();
    }
}

