/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.internal.testing.UnitTestExamples;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import com.google.protobuf.Timestamp;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReaderImpl;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=JUnit4.class)
public final class TopicBacklogReaderImplTest {
    @Rule
    public final @UnknownKeyFor @NonNull @Initialized MockitoRule mockito = MockitoJUnit.rule();
    @Mock
    @UnknownKeyFor @NonNull @Initialized TopicStatsClient mockClient;
    private @UnknownKeyFor @NonNull @Initialized TopicBacklogReader reader;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.reader = new TopicBacklogReaderImpl(this.mockClient, (TopicPath)UnitTestExamples.example(TopicPath.class), (Partition)UnitTestExamples.example(Partition.class));
    }

    @Test
    public void computeMessageStats_failure() {
        Mockito.when((Object)this.mockClient.computeMessageStats((TopicPath)UnitTestExamples.example(TopicPath.class), (Partition)UnitTestExamples.example(Partition.class), (Offset)UnitTestExamples.example(Offset.class), Offset.of((long)Integer.MAX_VALUE))).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new CheckedApiException((StatusCode.Code)StatusCode.Code.UNAVAILABLE).underlying));
        ApiException e = (ApiException)Assert.assertThrows(ApiException.class, () -> this.reader.computeMessageStats((Offset)UnitTestExamples.example(Offset.class)));
        Assert.assertEquals((Object)StatusCode.Code.UNAVAILABLE, (Object)e.getStatusCode().getCode());
    }

    @Test
    public void computeMessageStats_validResponseCached() {
        Timestamp minEventTime = Timestamp.newBuilder().setSeconds(1000L).setNanos(10).build();
        Timestamp minPublishTime = Timestamp.newBuilder().setSeconds(1001L).setNanos(11).build();
        ComputeMessageStatsResponse response = ComputeMessageStatsResponse.newBuilder().setMessageCount(10L).setMessageBytes(100L).setMinimumEventTime(minEventTime.toBuilder().setSeconds(1002L).build()).setMinimumPublishTime(minPublishTime).build();
        Mockito.when((Object)this.mockClient.computeMessageStats((TopicPath)UnitTestExamples.example(TopicPath.class), (Partition)UnitTestExamples.example(Partition.class), (Offset)UnitTestExamples.example(Offset.class), Offset.of((long)Integer.MAX_VALUE))).thenReturn((Object)ApiFutures.immediateFuture((Object)response));
        Assert.assertEquals((Object)this.reader.computeMessageStats((Offset)UnitTestExamples.example(Offset.class)), (Object)response);
    }
}

