/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetByteRangeTracker;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReader;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Ticker;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

@RunWith(value=JUnit4.class)
public class OffsetByteRangeTrackerTest {
    private static final @UnknownKeyFor @NonNull @Initialized double IGNORED_FRACTION = -1.0E7;
    private static final @UnknownKeyFor @NonNull @Initialized long MIN_BYTES = 1000L;
    private static final @UnknownKeyFor @NonNull @Initialized OffsetRange RANGE = new OffsetRange(123L, Long.MAX_VALUE);
    private final @UnknownKeyFor @NonNull @Initialized TopicBacklogReader reader = (TopicBacklogReader)Mockito.mock(TopicBacklogReader.class);
    @Spy
    @UnknownKeyFor @NonNull @Initialized Ticker ticker;
    private @UnknownKeyFor @NonNull @Initialized OffsetByteRangeTracker tracker;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ticker.read()).thenReturn((Object)0L);
        this.tracker = new OffsetByteRangeTracker(RANGE, this.reader, Stopwatch.createUnstarted((Ticker)this.ticker), Duration.millis((long)500L), 1000L);
    }

    @Test
    public void progressTracked() {
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)123L), (long)10L)));
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)124L), (long)11L)));
        Mockito.when((Object)this.reader.computeMessageStats(Offset.of((long)125L))).thenReturn((Object)ComputeMessageStatsResponse.newBuilder().setMessageBytes(1000L).build());
        RestrictionTracker.Progress progress = this.tracker.getProgress();
        Assert.assertEquals((double)21.0, (double)progress.getWorkCompleted(), (double)1.0E-4);
        Assert.assertEquals((double)1000.0, (double)progress.getWorkRemaining(), (double)1.0E-4);
    }

    @Test
    public void getProgressStatsFailure() {
        Mockito.when((Object)this.reader.computeMessageStats(Offset.of((long)123L))).thenThrow(new Throwable[]{new CheckedApiException((StatusCode.Code)StatusCode.Code.INTERNAL).underlying});
        Assert.assertThrows(ApiException.class, () -> ((OffsetByteRangeTracker)this.tracker).getProgress());
    }

    @Test
    public void claimSplitSuccess() {
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1000L), (long)1000L)));
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)10000L), (long)1000L)));
        SplitResult splits = this.tracker.trySplit(-1.0E7);
        Assert.assertEquals((long)RANGE.getFrom(), (long)((OffsetRange)splits.getPrimary()).getFrom());
        Assert.assertEquals((long)10001L, (long)((OffsetRange)splits.getPrimary()).getTo());
        Assert.assertEquals((long)10001L, (long)((OffsetRange)splits.getResidual()).getFrom());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((OffsetRange)splits.getResidual()).getTo());
        Assert.assertEquals((Object)splits.getPrimary(), (Object)this.tracker.currentRestriction());
        this.tracker.checkDone();
        Assert.assertNull((Object)this.tracker.trySplit(-1.0E7));
    }

    @Test
    public void splitWithoutClaimEmpty() {
        Mockito.when((Object)this.ticker.read()).thenReturn((Object)100000000000000L);
        SplitResult splits = this.tracker.trySplit(-1.0E7);
        Assert.assertEquals((long)RANGE.getFrom(), (long)((OffsetRange)splits.getPrimary()).getFrom());
        Assert.assertEquals((long)RANGE.getFrom(), (long)((OffsetRange)splits.getPrimary()).getTo());
        Assert.assertEquals((Object)RANGE, (Object)splits.getResidual());
        Assert.assertEquals((Object)splits.getPrimary(), (Object)this.tracker.currentRestriction());
        this.tracker.checkDone();
        Assert.assertNull((Object)this.tracker.trySplit(-1.0E7));
    }

    @Test
    public void unboundedNotDone() {
        Assert.assertThrows(IllegalStateException.class, () -> ((OffsetByteRangeTracker)this.tracker).checkDone());
    }

    @Test
    public void cannotClaimBackwards() {
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1000L), (long)1000L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1000L), (long)1000L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)999L), (long)1000L)));
    }

    @Test
    public void cannotClaimSplitRange() {
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1000L), (long)1000L)));
        Assert.assertTrue((this.tracker.trySplit(-1.0E7) != null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1001L), (long)1000L)));
    }

    @Test
    public void cannotSplitNotEnoughBytesOrTime() {
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1000L), (long)998L)));
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1001L), (long)1L)));
        Mockito.when((Object)this.ticker.read()).thenReturn((Object)100000000L);
        Assert.assertTrue((this.tracker.trySplit(-1.0E7) == null ? 1 : 0) != 0);
    }

    @Test
    public void canSplitTimeOnly() {
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1000L), (long)998L)));
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1001L), (long)1L)));
        Mockito.when((Object)this.ticker.read()).thenReturn((Object)1000000000L);
        Assert.assertTrue((this.tracker.trySplit(-1.0E7) != null ? 1 : 0) != 0);
    }

    @Test
    public void canSplitBytesOnly() {
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1000L), (long)998L)));
        Assert.assertTrue((boolean)this.tracker.tryClaim(OffsetByteProgress.of((Offset)Offset.of((long)1001L), (long)2L)));
        Mockito.when((Object)this.ticker.read()).thenReturn((Object)100000000L);
        Assert.assertTrue((this.tracker.trySplit(-1.0E7) != null ? 1 : 0) != 0);
    }
}

