/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class FakeSerializable {
    private static final @UnknownKeyFor @NonNull @Initialized AtomicInteger idCounter = new AtomicInteger(0);
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Object> map = new ConcurrentHashMap();

    private FakeSerializable() {
    }

    static <T> @UnknownKeyFor @NonNull @Initialized Handle<T> put(T value) {
        int id = idCounter.incrementAndGet();
        map.put(id, value);
        return new Handle(id);
    }

    static <T> @UnknownKeyFor @NonNull @Initialized SerializableSupplier<T> getSupplier(T value) {
        Handle<T> handle = FakeSerializable.put(value);
        return handle::get;
    }

    static class Handle<@UnknownKeyFor T>
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized int id;

        private Handle(@UnknownKeyFor @NonNull @Initialized int id) {
            this.id = id;
        }

        T get() {
            return (T)map.get(this.id);
        }
    }
}

