/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.gcp.pubsublite.AddUuidsTransform;
import org.apache.beam.sdk.io.gcp.pubsublite.Uuid;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class AddUuidsTransformTest {
    @Rule
    public final @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();

    private static @UnknownKeyFor @NonNull @Initialized PubSubMessage newMessage(@UnknownKeyFor @NonNull @Initialized int identifier) {
        return PubSubMessage.newBuilder().setKey(ByteString.copyFromUtf8((String)Integer.toString(identifier))).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PubSubMessage>, @UnknownKeyFor @Nullable @Initialized Void> identifiersInAnyOrder(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> identifiers) {
        return (SerializableFunction & Serializable)messages -> {
            HashSet uuids = new HashSet();
            messages.forEach(message -> {
                int identifier = Integer.parseInt(message.getKey().toStringUtf8());
                if (!identifiers.remove(identifier)) {
                    throw new IllegalStateException("Duplicate element " + identifier);
                }
                if (!uuids.add(Uuid.of((ByteString)((ByteString)Iterables.getOnlyElement((Iterable)((AttributeValues)message.getAttributesMap().get("x-goog-pubsublite-dataflow-uuid")).getValuesList()))))) {
                    throw new IllegalStateException("Invalid duplicate Uuid: " + message.toString());
                }
            });
            if (!identifiers.isEmpty()) {
                throw new IllegalStateException("Elements not in collection: " + identifiers);
            }
            return null;
        };
    }

    @Test
    public void messagesSameBatch() {
        TestStream messageStream = TestStream.create((Coder)ProtoCoder.of(PubSubMessage.class)).addElements((Object)AddUuidsTransformTest.newMessage(1), (Object[])new PubSubMessage[]{AddUuidsTransformTest.newMessage(2), AddUuidsTransformTest.newMessage(85)}).advanceWatermarkToInfinity();
        PCollection outputs = (PCollection)((PCollection)this.pipeline.apply((PTransform)messageStream)).apply((PTransform)new AddUuidsTransform());
        PAssert.that((PCollection)outputs).satisfies(AddUuidsTransformTest.identifiersInAnyOrder(Sets.newHashSet((Object[])new Integer[]{1, 2, 85})));
        this.pipeline.run();
    }

    @Test
    public void messagesTimeDelayed() {
        TestStream messageStream = TestStream.create((Coder)ProtoCoder.of(PubSubMessage.class)).addElements((Object)AddUuidsTransformTest.newMessage(1), (Object[])new PubSubMessage[]{AddUuidsTransformTest.newMessage(2)}).advanceProcessingTime(Duration.standardDays((long)1L)).addElements((Object)AddUuidsTransformTest.newMessage(85), (Object[])new PubSubMessage[0]).advanceWatermarkToInfinity();
        PCollection outputs = (PCollection)((PCollection)this.pipeline.apply((PTransform)messageStream)).apply((PTransform)new AddUuidsTransform());
        PAssert.that((PCollection)outputs).satisfies(AddUuidsTransformTest.identifiersInAnyOrder(Sets.newHashSet((Object[])new Integer[]{1, 2, 85})));
        this.pipeline.run();
    }
}

