/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubTestClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSink;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PubsubUnboundedSinkTest
implements Serializable {
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath TOPIC = PubsubClient.topicPathFromName((String)"testProject", (String)"testTopic");
    private static final @UnknownKeyFor @NonNull @Initialized String DATA = "testData";
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> ATTRIBUTES = ImmutableMap.builder().put((Object)"a", (Object)"b").put((Object)"c", (Object)"d").build();
    private static final @UnknownKeyFor @NonNull @Initialized long TIMESTAMP = 1234L;
    private static final @UnknownKeyFor @NonNull @Initialized String TIMESTAMP_ATTRIBUTE = "timestamp";
    private static final @UnknownKeyFor @NonNull @Initialized String ID_ATTRIBUTE = "id";
    private static final @UnknownKeyFor @NonNull @Initialized int NUM_SHARDS = 10;
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized TestPipeline p = TestPipeline.create();

    private @UnknownKeyFor @NonNull @Initialized String getRecordId(@UnknownKeyFor @NonNull @Initialized String data) {
        return Hashing.murmur3_128().hashBytes(data.getBytes(StandardCharsets.UTF_8)).toString();
    }

    @Test
    public void saneCoder() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PubsubClient.OutgoingMessage message = PubsubClient.OutgoingMessage.of((com.google.pubsub.v1.PubsubMessage)com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)DATA)).build(), (long)1234L, (String)this.getRecordId(DATA));
        CoderProperties.coderDecodeEncodeEqual((Coder)PubsubUnboundedSink.CODER, (Object)message);
        CoderProperties.coderSerializable((Coder)PubsubUnboundedSink.CODER);
    }

    @Test
    public void sendOneMessage() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ImmutableList outgoing = ImmutableList.of((Object)PubsubClient.OutgoingMessage.of((com.google.pubsub.v1.PubsubMessage)com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)DATA)).putAllAttributes(ATTRIBUTES).build(), (long)1234L, (String)this.getRecordId(DATA)));
        int batchSize = 1;
        int batchBytes = 1;
        try (PubsubTestClient.PubsubTestClientFactory factory = PubsubTestClient.createFactoryForPublish((PubsubClient.TopicPath)TOPIC, (Iterable)outgoing, (Iterable)ImmutableList.of());){
            PubsubUnboundedSink sink = new PubsubUnboundedSink((PubsubClient.PubsubClientFactory)factory, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)TOPIC), TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, 10, batchSize, batchBytes, Duration.standardSeconds((long)2L), PubsubUnboundedSink.RecordIdMethod.DETERMINISTIC);
            ((PCollection)((PCollection)this.p.apply((PTransform)Create.of((Iterable)ImmutableList.of((Object)DATA)))).apply((PTransform)ParDo.of((DoFn)new Stamp((Map)ATTRIBUTES)))).apply((PTransform)sink);
            this.p.run();
        }
    }

    @Test
    public void sendOneMessageWithoutAttributes() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ImmutableList outgoing = ImmutableList.of((Object)PubsubClient.OutgoingMessage.of((com.google.pubsub.v1.PubsubMessage)com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)DATA)).build(), (long)1234L, (String)this.getRecordId(DATA)));
        try (PubsubTestClient.PubsubTestClientFactory factory = PubsubTestClient.createFactoryForPublish((PubsubClient.TopicPath)TOPIC, (Iterable)outgoing, (Iterable)ImmutableList.of());){
            PubsubUnboundedSink sink = new PubsubUnboundedSink((PubsubClient.PubsubClientFactory)factory, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)TOPIC), TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, 10, 1, 1, Duration.standardSeconds((long)2L), PubsubUnboundedSink.RecordIdMethod.DETERMINISTIC);
            ((PCollection)((PCollection)this.p.apply((PTransform)Create.of((Iterable)ImmutableList.of((Object)DATA)))).apply((PTransform)ParDo.of((DoFn)new Stamp(null)))).apply((PTransform)sink);
            this.p.run();
        }
    }

    @Test
    public void sendMoreThanOneBatchByNumMessages() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<PubsubClient.OutgoingMessage> outgoing = new ArrayList<PubsubClient.OutgoingMessage>();
        ArrayList<String> data = new ArrayList<String>();
        int batchSize = 2;
        int batchBytes = 1000;
        for (int i = 0; i < batchSize * 10; ++i) {
            String str = String.valueOf(i);
            outgoing.add(PubsubClient.OutgoingMessage.of((com.google.pubsub.v1.PubsubMessage)com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)str)).build(), (long)1234L, (String)this.getRecordId(str)));
            data.add(str);
        }
        try (PubsubTestClient.PubsubTestClientFactory factory = PubsubTestClient.createFactoryForPublish((PubsubClient.TopicPath)TOPIC, outgoing, (Iterable)ImmutableList.of());){
            PubsubUnboundedSink sink = new PubsubUnboundedSink((PubsubClient.PubsubClientFactory)factory, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)TOPIC), TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, 10, batchSize, batchBytes, Duration.standardSeconds((long)2L), PubsubUnboundedSink.RecordIdMethod.DETERMINISTIC);
            ((PCollection)((PCollection)this.p.apply((PTransform)Create.of(data))).apply((PTransform)ParDo.of((DoFn)new Stamp()))).apply((PTransform)sink);
            this.p.run();
        }
    }

    @Test
    public void sendMoreThanOneBatchByByteSize() throws @UnknownKeyFor @NonNull @Initialized IOException {
        String str;
        ArrayList<PubsubClient.OutgoingMessage> outgoing = new ArrayList<PubsubClient.OutgoingMessage>();
        ArrayList<String> data = new ArrayList<String>();
        int batchSize = 100;
        int batchBytes = 10;
        for (int n = 0; n < batchBytes * 10; n += str.length()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < batchBytes; ++i) {
                sb.append(String.valueOf(n));
            }
            str = sb.toString();
            outgoing.add(PubsubClient.OutgoingMessage.of((com.google.pubsub.v1.PubsubMessage)com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)str)).build(), (long)1234L, (String)this.getRecordId(str)));
            data.add(str);
        }
        try (PubsubTestClient.PubsubTestClientFactory factory = PubsubTestClient.createFactoryForPublish((PubsubClient.TopicPath)TOPIC, outgoing, (Iterable)ImmutableList.of());){
            PubsubUnboundedSink sink = new PubsubUnboundedSink((PubsubClient.PubsubClientFactory)factory, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)TOPIC), TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, 10, batchSize, batchBytes, Duration.standardSeconds((long)2L), PubsubUnboundedSink.RecordIdMethod.DETERMINISTIC);
            ((PCollection)((PCollection)this.p.apply((PTransform)Create.of(data))).apply((PTransform)ParDo.of((DoFn)new Stamp()))).apply((PTransform)sink);
            this.p.run();
        }
    }

    private static class Stamp
    extends DoFn<String, PubsubMessage> {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributes;

        private Stamp() {
            this((Map<String, String>)ImmutableMap.of());
        }

        private Stamp(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributes) {
            this.attributes = attributes;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.outputWithTimestamp((Object)new PubsubMessage(((String)c.element()).getBytes(StandardCharsets.UTF_8), this.attributes), new Instant(1234L));
        }
    }
}

