/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithAttributesCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PubsubMessageWithAttributesCoderTest {
    private static final @UnknownKeyFor @NonNull @Initialized String DATA = "testData";
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> ATTRIBUTES = new ImmutableMap.Builder().put((Object)"1", (Object)"hello").build();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized PubsubMessage> TEST_CODER = PubsubMessageWithAttributesCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized PubsubMessage TEST_VALUE = new PubsubMessage("testData".getBytes(StandardCharsets.UTF_8), ATTRIBUTES);

    @Test
    public void testValueEncodable() throws @UnknownKeyFor @NonNull @Initialized Exception {
        SerializableUtils.ensureSerializableByCoder(TEST_CODER, (Object)TEST_VALUE, (String)"error");
    }

    @Test
    public void testCoderDecodeEncodeEqual() throws @UnknownKeyFor @NonNull @Initialized Exception {
        CoderProperties.structuralValueDecodeEncodeEqual(TEST_CODER, (Object)TEST_VALUE);
    }

    @Test
    public void testEncodedTypeDescriptor() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TypeDescriptor<PubsubMessage> typeDescriptor = new TypeDescriptor<PubsubMessage>(){};
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)typeDescriptor));
    }
}

