/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.AvroSchema;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.AvroGeneratedUser;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubGrpcClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessagePayloadOnlyCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubTestClient;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.model.Statement;

@RunWith(value=JUnit4.class)
public class PubsubIOTest {
    @Rule
    public @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();
    private transient @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath SUBSCRIPTION = PubsubClient.subscriptionPathFromName((String)"test-project", (String)"testSubscription");
    private static final @UnknownKeyFor @NonNull @Initialized Clock CLOCK = (Clock & Serializable)() -> 673L;
    transient @UnknownKeyFor @NonNull @Initialized TestPipeline readPipeline;
    private static final @UnknownKeyFor @NonNull @Initialized String SCHEMA_STRING = "{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"AvroGeneratedUser\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"favorite_number\", \"type\": [\"int\", \"null\"]},\n     {\"name\": \"favorite_color\", \"type\": [\"string\", \"null\"]}\n ]\n}";
    private static final @UnknownKeyFor @NonNull @Initialized Schema SCHEMA = new Schema.Parser().parse("{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"AvroGeneratedUser\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"favorite_number\", \"type\": [\"int\", \"null\"]},\n     {\"name\": \"favorite_color\", \"type\": [\"string\", \"null\"]}\n ]\n}");
    @Rule
    public final transient @UnknownKeyFor @NonNull @Initialized TestRule setupPipeline = new TestRule(){

        public @UnknownKeyFor @NonNull @Initialized Statement apply(final @UnknownKeyFor @NonNull @Initialized Statement base, final @UnknownKeyFor @NonNull @Initialized Description description) {
            Statement withPipeline = new Statement(){

                public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    PubsubIOTest.this.options = TestPipeline.testingPipelineOptions();
                    ((PubsubOptions)PubsubIOTest.this.options.as(PubsubOptions.class)).setProject("test-project");
                    PubsubIOTest.this.readPipeline = TestPipeline.fromOptions((PipelineOptions)PubsubIOTest.this.options);
                    PubsubIOTest.this.readPipeline.apply(base, description).evaluate();
                }
            };
            return withPipeline;
        }
    };
    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PubsubTestClient.PubsubTestClientFactory clientFactory;

    @Test
    public void testPubsubIOGetName() {
        Assert.assertEquals((Object)"PubsubIO.Read", (Object)PubsubIO.readStrings().fromTopic("projects/myproject/topics/mytopic").getName());
        Assert.assertEquals((Object)"PubsubIO.Write", (Object)PubsubIO.writeStrings().to("projects/myproject/topics/mytopic").getName());
    }

    @Test
    public void testTopicValidationSuccess() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/abc");
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/ABC");
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/AbC-DeF");
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/AbC-1234");
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/AbC-1234-_.~%+-_.~%+-_.~%+-abc");
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/A-really-long-one-" + "111111111111111111111111111111111111111111111111111111111111111111111111111111111" + "111111111111111111111111111111111111111111111111111111111111111111111111111111111" + "11111111111111111111111111111111111111111111111111111111111111111111111111");
    }

    @Test
    public void testTopicValidationBadCharacter() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.thrown.expect(IllegalArgumentException.class);
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/abc-*-abc");
    }

    @Test
    public void testTopicValidationTooLong() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.thrown.expect(IllegalArgumentException.class);
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/A-really-long-one-" + "111111111111111111111111111111111111111111111111111111111111111111111111111111111" + "111111111111111111111111111111111111111111111111111111111111111111111111111111111" + "1111111111111111111111111111111111111111111111111111111111111111111111111111");
    }

    @Test
    public void testReadTopicDisplayData() {
        String topic = "projects/project/topics/topic";
        PubsubIO.Read read = PubsubIO.readStrings().fromTopic((ValueProvider)ValueProvider.StaticValueProvider.of((Object)topic)).withTimestampAttribute("myTimestamp").withIdAttribute("myId");
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic", (String)topic));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"timestampAttribute", (String)"myTimestamp"));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"idAttribute", (String)"myId"));
    }

    @Test
    public void testReadSubscriptionDisplayData() {
        String subscription = "projects/project/subscriptions/subscription";
        PubsubIO.Read read = PubsubIO.readStrings().fromSubscription((ValueProvider)ValueProvider.StaticValueProvider.of((Object)subscription)).withTimestampAttribute("myTimestamp").withIdAttribute("myId");
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"subscription", (String)subscription));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"timestampAttribute", (String)"myTimestamp"));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"idAttribute", (String)"myId"));
    }

    @Test
    public void testNullTopic() {
        String subscription = "projects/project/subscriptions/subscription";
        PubsubIO.Read read = PubsubIO.readStrings().fromSubscription((ValueProvider)ValueProvider.StaticValueProvider.of((Object)subscription));
        Assert.assertNull((Object)read.getTopicProvider());
        Assert.assertNotNull((Object)read.getSubscriptionProvider());
        Assert.assertNotNull((Object)DisplayData.from((HasDisplayData)read));
    }

    @Test
    public void testNullSubscription() {
        String topic = "projects/project/topics/topic";
        PubsubIO.Read read = PubsubIO.readStrings().fromTopic((ValueProvider)ValueProvider.StaticValueProvider.of((Object)topic));
        Assert.assertNotNull((Object)read.getTopicProvider());
        Assert.assertNull((Object)read.getSubscriptionProvider());
        Assert.assertNotNull((Object)DisplayData.from((HasDisplayData)read));
    }

    @Test
    public void testValueProviderSubscription() {
        ValueProvider.StaticValueProvider provider = ValueProvider.StaticValueProvider.of((Object)"projects/project/subscriptions/subscription");
        PubsubIO.Read pubsubRead = PubsubIO.readStrings().fromSubscription((ValueProvider)provider);
        Pipeline.create().apply((PTransform)pubsubRead);
        Assert.assertThat((Object)pubsubRead.getSubscriptionProvider(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)pubsubRead.getSubscriptionProvider().isAccessible(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((PubsubIO.PubsubSubscription)pubsubRead.getSubscriptionProvider().get()).asPath(), (Matcher)Matchers.equalTo((Object)((String)provider.get())));
    }

    @Test
    public void testRuntimeValueProviderSubscription() {
        TestPipeline pipeline = TestPipeline.create();
        ValueProvider subscription = pipeline.newProvider((Object)"projects/project/subscriptions/subscription");
        PubsubIO.Read pubsubRead = PubsubIO.readStrings().fromSubscription(subscription);
        pipeline.apply((PTransform)pubsubRead);
        Assert.assertThat((Object)pubsubRead.getSubscriptionProvider(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)pubsubRead.getSubscriptionProvider().isAccessible(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testValueProviderTopic() {
        ValueProvider.StaticValueProvider provider = ValueProvider.StaticValueProvider.of((Object)"projects/project/topics/topic");
        PubsubIO.Read pubsubRead = PubsubIO.readStrings().fromTopic((ValueProvider)provider);
        Pipeline.create().apply((PTransform)pubsubRead);
        Assert.assertThat((Object)pubsubRead.getTopicProvider(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)pubsubRead.getTopicProvider().isAccessible(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((PubsubIO.PubsubTopic)pubsubRead.getTopicProvider().get()).asPath(), (Matcher)Matchers.equalTo((Object)((String)provider.get())));
    }

    @Test
    public void testRuntimeValueProviderTopic() {
        TestPipeline pipeline = TestPipeline.create();
        ValueProvider topic = pipeline.newProvider((Object)"projects/project/topics/topic");
        PubsubIO.Read pubsubRead = PubsubIO.readStrings().fromTopic(topic);
        pipeline.apply((PTransform)pubsubRead);
        Assert.assertThat((Object)pubsubRead.getTopicProvider(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)pubsubRead.getTopicProvider().isAccessible(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testPrimitiveReadDisplayData() {
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        PubsubIO.Read baseRead = PubsubIO.readStrings();
        PubsubIO.Read read = baseRead.fromSubscription("projects/project/subscriptions/subscription");
        Set displayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform)read);
        Assert.assertThat((String)"PubsubIO.Read should include the subscription in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"subscription")));
        read = baseRead.fromTopic("projects/project/topics/topic");
        displayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform)read);
        Assert.assertThat((String)"PubsubIO.Read should include the topic in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic")));
    }

    @Test
    public void testReadWithPubsubGrpcClientFactory() {
        String topic = "projects/project/topics/topic";
        PubsubIO.Read read = PubsubIO.readStrings().fromTopic((ValueProvider)ValueProvider.StaticValueProvider.of((Object)topic)).withClientFactory(PubsubGrpcClient.FACTORY).withTimestampAttribute("myTimestamp").withIdAttribute("myId");
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic", (String)topic));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"timestampAttribute", (String)"myTimestamp"));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"idAttribute", (String)"myId"));
    }

    @Test
    public void testWriteDisplayData() {
        String topic = "projects/project/topics/topic";
        PubsubIO.Write write = PubsubIO.writeStrings().to(topic).withTimestampAttribute("myTimestamp").withIdAttribute("myId");
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic", (String)topic));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"timestampAttribute", (String)"myTimestamp"));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"idAttribute", (String)"myId"));
    }

    @Test
    public void testPrimitiveWriteDisplayData() {
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        PubsubIO.Write write = PubsubIO.writeStrings().to("projects/project/topics/topic");
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        Assert.assertThat((String)"PubsubIO.Write should include the topic in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic")));
    }

    private <T> void setupTestClient(@UnknownKeyFor @NonNull @Initialized List<T> inputs, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        List messages = inputs.stream().map(t -> {
            try {
                return CoderUtils.encodeToByteArray((Coder)coder, (Object)t);
            }
            catch (CoderException e) {
                throw new RuntimeException(e);
            }
        }).map(ba -> PubsubClient.IncomingMessage.of((com.google.pubsub.v1.PubsubMessage)com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])ba)).build(), (long)1234L, (long)0L, (String)UUID.randomUUID().toString(), (String)UUID.randomUUID().toString())).collect(Collectors.toList());
        this.clientFactory = PubsubTestClient.createFactoryForPull((Clock)CLOCK, (PubsubClient.SubscriptionPath)SUBSCRIPTION, (int)60, messages);
    }

    @After
    public void after() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.clientFactory != null) {
            this.clientFactory.close();
            this.clientFactory = null;
        }
    }

    @Test
    public void testAvroGenericRecords() {
        AvroCoder coder = AvroCoder.of(GenericRecord.class, (Schema)SCHEMA);
        ImmutableList inputs = ImmutableList.of((Object)new AvroGeneratedUser("Bob", Integer.valueOf(256), null), (Object)new AvroGeneratedUser("Alice", Integer.valueOf(128), null), (Object)new AvroGeneratedUser("Ted", null, "white"));
        this.setupTestClient((List)inputs, (Coder)coder);
        PCollection read = (PCollection)this.readPipeline.apply((PTransform)PubsubIO.readAvroGenericRecords((Schema)SCHEMA).fromSubscription(SUBSCRIPTION.getPath()).withClock(CLOCK).withClientFactory((PubsubClient.PubsubClientFactory)this.clientFactory));
        PAssert.that((PCollection)read).containsInAnyOrder((Iterable)inputs);
        this.readPipeline.run();
    }

    @Test
    public void testAvroPojo() {
        AvroCoder coder = AvroCoder.of(GenericClass.class);
        ArrayList inputs = Lists.newArrayList((Object[])new GenericClass[]{new GenericClass(1, "foo", new DateTime().withDate(2019, 10, 1).withZone(DateTimeZone.UTC)), new GenericClass(2, "bar", new DateTime().withDate(1986, 10, 1).withZone(DateTimeZone.UTC))});
        this.setupTestClient(inputs, (Coder)coder);
        PCollection read = (PCollection)this.readPipeline.apply((PTransform)PubsubIO.readAvrosWithBeamSchema(GenericClass.class).fromSubscription(SUBSCRIPTION.getPath()).withClock(CLOCK).withClientFactory((PubsubClient.PubsubClientFactory)this.clientFactory));
        PAssert.that((PCollection)read).containsInAnyOrder((Iterable)inputs);
        this.readPipeline.run();
    }

    @Test
    public void testAvroSpecificRecord() {
        AvroCoder coder = AvroCoder.of(AvroGeneratedUser.class);
        ImmutableList inputs = ImmutableList.of((Object)new AvroGeneratedUser("Bob", Integer.valueOf(256), null), (Object)new AvroGeneratedUser("Alice", Integer.valueOf(128), null), (Object)new AvroGeneratedUser("Ted", null, "white"));
        this.setupTestClient((List)inputs, (Coder)coder);
        PCollection read = (PCollection)this.readPipeline.apply((PTransform)PubsubIO.readAvrosWithBeamSchema(AvroGeneratedUser.class).fromSubscription(SUBSCRIPTION.getPath()).withClock(CLOCK).withClientFactory((PubsubClient.PubsubClientFactory)this.clientFactory));
        PAssert.that((PCollection)read).containsInAnyOrder((Iterable)inputs);
        this.readPipeline.run();
    }

    @Test
    public void testWriteWithPubsubGrpcClientFactory() {
        String topic = "projects/project/topics/topic";
        PubsubIO.Write write = PubsubIO.writeStrings().to(topic).withClientFactory(PubsubGrpcClient.FACTORY).withTimestampAttribute("myTimestamp").withIdAttribute("myId");
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic", (String)topic));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"timestampAttribute", (String)"myTimestamp"));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"idAttribute", (String)"myId"));
    }

    @Test
    public void testReadMessagesWithCoderAndParseFn() {
        PubsubMessagePayloadOnlyCoder coder = PubsubMessagePayloadOnlyCoder.of();
        ImmutableList inputs = ImmutableList.of((Object)new PubsubMessage("foo".getBytes(StandardCharsets.UTF_8), new HashMap()), (Object)new PubsubMessage("bar".getBytes(StandardCharsets.UTF_8), new HashMap()));
        this.setupTestClient((List)inputs, (Coder)coder);
        PCollection read = (PCollection)this.readPipeline.apply((PTransform)PubsubIO.readMessagesWithCoderAndParseFn((Coder)StringUtf8Coder.of(), (SimpleFunction)new StringPayloadParseFn()).fromSubscription(SUBSCRIPTION.getPath()).withClock(CLOCK).withClientFactory((PubsubClient.PubsubClientFactory)this.clientFactory));
        ImmutableList outputs = ImmutableList.of((Object)"foo", (Object)"bar");
        PAssert.that((PCollection)read).containsInAnyOrder((Iterable)outputs);
        this.readPipeline.run();
    }

    static class StringPayloadParseFn
    extends SimpleFunction<PubsubMessage, String> {
        StringPayloadParseFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized PubsubMessage input) {
            return new String(input.getPayload(), StandardCharsets.UTF_8);
        }
    }

    static class GenericClass {
        @UnknownKeyFor @NonNull @Initialized int intField;
        @UnknownKeyFor @NonNull @Initialized String stringField;
        @AvroSchema(value="{\"type\": \"long\", \"logicalType\": \"timestamp-millis\"}")
        public @UnknownKeyFor @NonNull @Initialized DateTime timestamp;

        public GenericClass() {
        }

        public GenericClass(@UnknownKeyFor @NonNull @Initialized int intField, @UnknownKeyFor @NonNull @Initialized String stringField, @UnknownKeyFor @NonNull @Initialized DateTime timestamp) {
            this.intField = intField;
            this.stringField = stringField;
            this.timestamp = timestamp;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("intField", this.intField).add("stringField", (Object)this.stringField).add("timestamp", (Object)this.timestamp).toString();
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.intField, this.stringField, this.timestamp);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other == null || !(other instanceof GenericClass)) {
                return false;
            }
            GenericClass o = (GenericClass)other;
            return Objects.equals(this.intField, o.intField) && Objects.equals(this.stringField, o.stringField) && Objects.equals(this.timestamp, o.timestamp);
        }
    }
}

