/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import org.apache.beam.sdk.io.gcp.healthcare.WebPathParser;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WebPathParserTest {
    @Test
    public void test_parsedAllElements() throws @UnknownKeyFor @NonNull @Initialized IOException {
        String webpathStr = "projects/foo/location/earth/datasets/bar/dicomStores/fee/dicomWeb/studies/abc/series/xyz/instances/123";
        WebPathParser parser = new WebPathParser();
        WebPathParser.DicomWebPath dicomWebPath = parser.parseDicomWebpath(webpathStr);
        Assert.assertNotNull((Object)dicomWebPath);
        Assert.assertEquals((Object)"foo", (Object)dicomWebPath.project);
        Assert.assertEquals((Object)"earth", (Object)dicomWebPath.location);
        Assert.assertEquals((Object)"bar", (Object)dicomWebPath.dataset);
        Assert.assertEquals((Object)"fee", (Object)dicomWebPath.storeId);
        Assert.assertEquals((Object)"abc", (Object)dicomWebPath.studyId);
        Assert.assertEquals((Object)"xyz", (Object)dicomWebPath.seriesId);
        Assert.assertEquals((Object)"123", (Object)dicomWebPath.instanceId);
        Assert.assertEquals((Object)"projects/foo/location/earth/datasets/bar/dicomStores/fee", (Object)dicomWebPath.dicomStorePath);
    }
}

