/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.services.healthcare.v1beta1.model.Hl7V2Store;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.concurrent.TimeoutException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2IO;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2IOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2MessageCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HL7v2IOWriteIT {
    private transient @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
    private static @UnknownKeyFor @NonNull @Initialized String healthcareDataset;
    private static final @UnknownKeyFor @NonNull @Initialized String HL7V2_STORE_NAME;
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void createHL7v2tore() throws @UnknownKeyFor @NonNull @Initialized IOException {
        String project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
        healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", project);
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        Hl7V2Store store = client.createHL7v2Store(healthcareDataset, HL7V2_STORE_NAME);
        store.getParserConfig();
    }

    @AfterClass
    public static void deleteHL7v2tore() throws @UnknownKeyFor @NonNull @Initialized IOException {
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        client.deleteHL7v2Store(healthcareDataset + "/hl7V2Stores/" + HL7V2_STORE_NAME);
    }

    @Before
    public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
    }

    @After
    public void tearDown() throws @UnknownKeyFor @NonNull @Initialized Exception {
        HL7v2IOTestUtil.deleteAllHL7v2Messages(this.client, healthcareDataset + "/hl7V2Stores/" + HL7V2_STORE_NAME);
    }

    @Test
    public void testHL7v2IOWrite() throws @UnknownKeyFor @NonNull @Initialized Exception {
        HL7v2IO.Write.Result result = (HL7v2IO.Write.Result)((PCollection)this.pipeline.apply((PTransform)Create.of(HL7v2IOTestUtil.MESSAGES).withCoder((Coder)HL7v2MessageCoder.of()))).apply((PTransform)HL7v2IO.ingestMessages((String)(healthcareDataset + "/hl7V2Stores/" + HL7V2_STORE_NAME)));
        PAssert.that((PCollection)result.getFailedInsertsWithErr()).empty();
        this.pipeline.run().waitUntilFinish();
        try {
            HL7v2IOTestUtil.waitForHL7v2Indexing(this.client, healthcareDataset + "/hl7V2Stores/" + HL7V2_STORE_NAME, HL7v2IOTestUtil.MESSAGES.size(), Duration.standardMinutes((long)10L));
        }
        catch (TimeoutException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    static {
        HL7V2_STORE_NAME = "hl7v2_store_write_it_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
    }
}

