/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2IO;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2IOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2MessageCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HL7v2IOReadIT {
    private transient @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
    private static @UnknownKeyFor @NonNull @Initialized String healthcareDataset;
    private static final @UnknownKeyFor @NonNull @Initialized String HL7V2_STORE_NAME;
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void createHL7v2tore() throws @UnknownKeyFor @NonNull @Initialized IOException {
        String project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
        healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", project);
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        client.createHL7v2Store(healthcareDataset, HL7V2_STORE_NAME);
    }

    @AfterClass
    public static void deleteHL7v2tore() throws @UnknownKeyFor @NonNull @Initialized IOException {
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        client.deleteHL7v2Store(healthcareDataset + "/hl7V2Stores/" + HL7V2_STORE_NAME);
    }

    @Before
    public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
        HL7v2IOTestUtil.writeHL7v2Messages(this.client, healthcareDataset + "/hl7V2Stores/" + HL7V2_STORE_NAME);
    }

    @After
    public void tearDown() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
        HL7v2IOTestUtil.deleteAllHL7v2Messages(this.client, healthcareDataset + "/hl7V2Stores/" + HL7V2_STORE_NAME);
    }

    @Test
    public void testHL7v2IO_ListHL7v2Messages() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Pipeline pipeline = Pipeline.create();
        PCollection result = (PCollection)pipeline.apply((PTransform)HL7v2IO.read((String)(healthcareDataset + "/hl7V2Stores/" + HL7V2_STORE_NAME)));
        PCollection numReadMessages = (PCollection)result.setCoder((Coder)HL7v2MessageCoder.of()).apply(Count.globally());
        PAssert.thatSingleton((PCollection)numReadMessages).isEqualTo((Object)HL7v2IOTestUtil.MESSAGES.size());
        PAssert.that((PCollection)result).satisfies((SerializableFunction & Serializable)input -> {
            for (HL7v2Message elem : input) {
                Assert.assertFalse((boolean)elem.getName().isEmpty());
                Assert.assertFalse((boolean)elem.getData().isEmpty());
                Assert.assertFalse((boolean)elem.getMessageType().isEmpty());
            }
            return null;
        });
        pipeline.run();
    }

    @Test
    public void testHL7v2IO_ListHL7v2Messages_filtered() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String adtFilter = "messageType = \"ADT\"";
        Pipeline pipeline = Pipeline.create();
        PCollection result = (PCollection)pipeline.apply((PTransform)HL7v2IO.readWithFilter((String)(healthcareDataset + "/hl7V2Stores/" + HL7V2_STORE_NAME), (String)"messageType = \"ADT\""));
        PCollection numReadMessages = (PCollection)result.setCoder((Coder)HL7v2MessageCoder.of()).apply(Count.globally());
        PAssert.thatSingleton((PCollection)numReadMessages).isEqualTo((Object)2L);
        PAssert.that((PCollection)result).satisfies((SerializableFunction & Serializable)input -> {
            for (HL7v2Message elem : input) {
                Assert.assertEquals((Object)"ADT", (Object)elem.getMessageType());
            }
            return null;
        });
        pipeline.run();
    }

    static {
        HL7V2_STORE_NAME = "hl7v2_store_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32) + "_read_it";
    }
}

