/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.services.healthcare.v1beta1.model.ListMessagesResponse;
import com.google.api.services.healthcare.v1beta1.model.Message;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2IOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class HL7V2MessagePagesTest {
    private transient @UnknownKeyFor @NonNull @Initialized HttpHealthcareApiClient client;

    @Before
    public void setUp() {
        this.client = (HttpHealthcareApiClient)Mockito.mock(HttpHealthcareApiClient.class);
    }

    @Test
    public void test_EmptyStoreEmptyIterator() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ((HttpHealthcareApiClient)Mockito.doReturn((Object)new ListMessagesResponse()).when((Object)this.client)).makeSendTimeBoundHL7v2ListRequest("foo", null, null, null, null, null);
        HttpHealthcareApiClient.HL7v2MessagePages emptyPages = new HttpHealthcareApiClient.HL7v2MessagePages((HealthcareApiClient)this.client, "foo", null, null);
        Assert.assertFalse((boolean)emptyPages.iterator().hasNext());
    }

    @Test
    public void test_NonEmptyExpectedIterator() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ListMessagesResponse page0 = new ListMessagesResponse().setHl7V2Messages(Stream.of("foo0", "foo1", "foo2").map(HL7v2IOTestUtil::testMessage).collect(Collectors.toList())).setNextPageToken("page1");
        ListMessagesResponse page1 = new ListMessagesResponse().setHl7V2Messages(Stream.of("foo3", "foo4", "foo5").map(HL7v2IOTestUtil::testMessage).collect(Collectors.toList()));
        ((HttpHealthcareApiClient)Mockito.doReturn((Object)page0).when((Object)this.client)).makeSendTimeBoundHL7v2ListRequest("foo", null, null, null, null, null);
        ((HttpHealthcareApiClient)Mockito.doReturn((Object)page1).when((Object)this.client)).makeSendTimeBoundHL7v2ListRequest("foo", null, null, null, null, "page1");
        HttpHealthcareApiClient.HL7v2MessagePages pages = new HttpHealthcareApiClient.HL7v2MessagePages((HealthcareApiClient)this.client, "foo", null, null);
        Assert.assertTrue((boolean)pages.iterator().hasNext());
        Iterator pagesIterator = pages.iterator();
        TestCase.assertEquals(page0.getHl7V2Messages().stream().map(Message::getName).collect(Collectors.toList()), ((List)pagesIterator.next()).stream().map(HL7v2Message::getName).collect(Collectors.toList()));
        TestCase.assertEquals(page1.getHl7V2Messages().stream().map(Message::getName).collect(Collectors.toList()), ((List)pagesIterator.next()).stream().map(HL7v2Message::getName).collect(Collectors.toList()));
        Assert.assertFalse((boolean)pagesIterator.hasNext());
    }
}

