/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOTestOptions;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FhirIOWriteIT {
    private final @UnknownKeyFor @NonNull @Initialized String fhirStoreName;
    private @UnknownKeyFor @NonNull @Initialized FhirIOTestOptions options;
    private transient @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
    private @UnknownKeyFor @NonNull @Initialized String healthcareDataset;
    private @UnknownKeyFor @NonNull @Initialized long testTime = System.currentTimeMillis();
    public @UnknownKeyFor @NonNull @Initialized String version;
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();

    @Parameterized.Parameters(name="{0}")
    public static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> versions() {
        return Arrays.asList("DSTU2", "STU3", "R4");
    }

    public FhirIOWriteIT(@UnknownKeyFor @NonNull @Initialized String version) {
        this.version = version;
        this.fhirStoreName = "FHIR_store_" + version + "_write_it_" + this.testTime + "_" + new SecureRandom().nextInt(32);
    }

    @Before
    public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
        PipelineOptionsFactory.register(FhirIOTestOptions.class);
        String project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
        this.healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", project);
        this.options = (FhirIOTestOptions)TestPipeline.testingPipelineOptions().as(FhirIOTestOptions.class);
        if (this.options.getGcsTempPath() == null) {
            this.options.setGcsTempPath(String.format("gs://%s/FhirIOWrite%sIT/%s/temp/", "temp-storage-for-healthcare-io-tests", this.version, this.testTime));
        }
        if (this.options.getGcsDeadLetterPath() == null) {
            this.options.setGcsDeadLetterPath(String.format("gs://%s/FhirIOWrite%sIT/%s/deadletter/", "temp-storage-for-healthcare-io-tests", this.version, this.testTime));
        }
        this.options.setFhirStore(this.healthcareDataset + "/fhirStores/" + this.fhirStoreName);
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        client.createFhirStore(this.healthcareDataset, this.fhirStoreName, this.version);
    }

    @After
    public void teardownFhirStore() throws @UnknownKeyFor @NonNull @Initialized IOException {
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        client.deleteFhirStore(this.healthcareDataset + "/fhirStores/" + this.fhirStoreName);
    }

    @AfterClass
    public static void teardownBucket() throws @UnknownKeyFor @NonNull @Initialized IOException {
        FhirIOTestUtil.tearDownTempBucket();
    }

    @Test
    public void testFhirIO_ExecuteBundle() throws @UnknownKeyFor @NonNull @Initialized IOException {
        FhirIO.Write.Result writeResult = (FhirIO.Write.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)FhirIOTestUtil.BUNDLES.get(this.version)))).apply((PTransform)FhirIO.Write.executeBundles((String)this.options.getFhirStore()));
        PAssert.that((PCollection)writeResult.getFailedBodies()).empty();
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testFhirIO_Import() {
        Pipeline pipeline = Pipeline.create((PipelineOptions)this.options);
        if (this.options.getTempLocation() == null) {
            this.options.setTempLocation("gs://temp-storage-for-healthcare-io-tests");
        }
        FhirIO.Write.Result result = (FhirIO.Write.Result)((PCollection)pipeline.apply((PTransform)Create.of((Iterable)FhirIOTestUtil.BUNDLES.get(this.version)))).apply((PTransform)FhirIO.Write.fhirStoresImport((String)this.options.getFhirStore(), (String)this.options.getGcsDeadLetterPath(), (FhirIO.Import.ContentStructure)FhirIO.Import.ContentStructure.BUNDLE));
        PAssert.that((PCollection)result.getFailedBodies()).empty();
        PAssert.that((PCollection)result.getFailedFiles()).empty();
        pipeline.run().waitUntilFinish();
    }
}

